/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.report;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import javax.json.JsonObject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.fframes.FFrameView;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.report.LayoutReportAction;
import org.gvsig.app.project.documents.layout.report.LayoutReportActionParameters;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.desktopopen.DesktopOpen;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.report.AbstractReportAction;
import org.gvsig.fmap.dal.swing.report.ReportActionFactory;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.swing.api.PDFSwingLocator;
import org.gvsig.pdf.swing.api.PDFSwingManager;
import org.gvsig.pdf.swing.api.PDFViewer;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.task.JTaskStatus;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.ToolsUtilLocator;

public class LayoutReportActionImpl
extends AbstractReportAction
implements LayoutReportAction {
    private final FeatureStore store;
    private FeatureQuery query;
    private FeatureSet selection;
    private Feature current_row;
    private MutableSymbolTable symbolTable;
    private FeatureSymbolTable fSymbolTable;
    private Iterable<Feature> set;
    private int featuresCount;
    private LayoutReportActionParameters parameters;

    public static LayoutReportActionImpl createFakeLayoutReportAction(Document doc) {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        Feature f = null;
        FeatureStore theStore = null;
        ReportActionFactory theFactory = dataSwingManager.getReportActionFactory("Layout");
        try {
            IWindow activeView = application.getActiveWindow(ViewDocument.class);
            ViewDocument viewdoc = (ViewDocument)((IView)activeView).getDocument();
            FLyrVect layer = viewdoc.getMapContext().getLayers().getFirstActiveVectorLayer();
            theStore = layer.getFeatureStore();
            f = theStore.isFeatureSelectionEmpty() ? theStore.first() : theStore.getFeatureSelection().first();
        }
        catch (Throwable t) {
            LOGGER.debug("Can't retrieve test feature", t);
        }
        LayoutReportActionImpl report = new LayoutReportActionImpl(theFactory, theStore, f);
        report.getSymbolTable().setVar("$LAYOUT", (Object)doc);
        report.getSymbolTable().setVar("$PAGE", (Object)1);
        report.getSymbolTable().setVar("$PAGES", (Object)1);
        return report;
    }

    private LayoutReportActionImpl(ReportActionFactory factory, FeatureStore store, JsonObject json) {
        super(factory, null);
        this.store = store;
        this.selection = null;
        this.query = null;
        this.current_row = null;
        this.parameters = LayoutReportActionParameters.create();
        this.parameters.fromJson(json);
        this.setReportName(this.parameters.getIdentifier());
        this.setReportLabel(this.parameters.getLabel());
    }

    private LayoutReportActionImpl(ReportActionFactory factory, FeatureStore store, Feature feature) {
        this(factory, store, LayoutReportActionParameters.create(store.getName()).toJson());
        try {
            this.selection = store.createFeatureSelection();
            ((FeatureSelection)this.selection).select(feature);
        }
        catch (Throwable t) {
            LOGGER.debug("Can't initialize selection", t);
        }
        this.query = store.createFeatureQuery(feature.createFilter());
        this.current_row = feature;
    }

    public LayoutReportActionImpl(ReportActionFactory factory, FeatureStore store, FeatureQuery query, FeatureSet selection, JsonObject json) {
        this(factory, store, json);
        this.selection = selection;
        this.query = query;
    }

    public Feature row() {
        return this.current_row;
    }

    private Iterable<Feature> features() {
        if (this.set == null) {
            if (this.selection == null) {
                try {
                    FeatureSet fset = this.store.getFeatureSet(this.query);
                    this.featuresCount = fset.size();
                    this.set = fset;
                }
                catch (DataException ex) {
                    throw new RuntimeException("Can't create dynamic-text report.", ex);
                }
            } else {
                this.featuresCount = this.selection.size();
                if (this.selection instanceof FeatureSelection) {
                    this.set = this.store.getFeaturesIterable(((FeatureSelection)this.selection).referenceIterator());
                } else {
                    this.set = this.selection;
                    DisposeUtils.bind(this.set);
                }
            }
        }
        return this.set;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        JTaskStatus taskStatusPanel = ToolsSwingLocator.getTaskStatusSwingManager().createJTaskStatus();
        LayoutReportActionImpl report = this;
        SimpleTaskStatus theStatus = this.getStatus();
        theStatus.setIndeterminate();
        taskStatusPanel.setShowRemoveTaskButton(false);
        taskStatusPanel.bind((TaskStatus)theStatus);
        ToolsSwingUtils.ensureRowsCols((JComponent)taskStatusPanel, (int)4, (int)100, (int)5, (int)200);
        windowManager.showWindow(taskStatusPanel.asJComponent(), i18n.getTranslation("_Creating_report") + " '" + this.getReportLabel() + "'...", WindowManager.MODE.TOOL);
        Thread task = new Thread(() -> {
            ArrayList<File> singlePdfFiles = new ArrayList<File>();
            Iterable<Feature> features = null;
            try {
                String title = this.getReportLabel();
                String creator = "gvSIG-desktop";
                String subject = "Layout report";
                File pdfFile = ToolsLocator.getFoldersManager().getUniqueTemporaryFile(new String[]{"report.pdf"});
                int pag = 0;
                features = this.features();
                theStatus.setRangeOfValues(1L, (long)this.featuresCount);
                theStatus.message(i18n.getTranslation("_Building_pages"));
                for (Feature feature : features) {
                    if (theStatus.isCancellationRequested()) {
                        theStatus.cancel();
                        return;
                    }
                    File f = this.printReport(feature, ++pag);
                    singlePdfFiles.add(f);
                    theStatus.incrementCurrentValue();
                }
                theStatus.message(i18n.getTranslation("_Building_pdf"));
                PDFManager pdfManager = PDFLocator.getPDFManager();
                pdfManager.merge(singlePdfFiles, pdfFile, title, creator, subject, theStatus);
                if (this.parameters.isUseInternalPdfViewer()) {
                    this.showEmbedded(pdfFile);
                } else {
                    this.showExternal(pdfFile);
                }
                theStatus.terminate();
                SwingUtilities.invokeLater(() -> taskStatusPanel.setVisible(false));
            }
            catch (Throwable t) {
                LOGGER.warn("Can't create layout report.", t);
                theStatus.abort();
            }
            finally {
                for (File singlePdfFile : singlePdfFiles) {
                    singlePdfFile.delete();
                }
                DisposeUtils.disposeQuietly(features);
            }
        }, "Report_" + report.getReportName());
        task.start();
    }

    private File printReport(Feature feature, int page) throws Exception {
        this.current_row = feature;
        LayoutPanel layout = this.getTemplateAsLayout();
        LayoutContext context = layout.getLayoutContext();
        Document document = layout.getDocument();
        this.getSymbolTable();
        this.fSymbolTable.setFeature(this.current_row);
        this.symbolTable.setVar("$LAYOUT", (Object)document);
        this.symbolTable.setVar("$PAGE", (Object)page);
        this.symbolTable.setVar("$PAGES", (Object)this.featuresCount);
        File pdfFile = null;
        Object previous_report = document.getProperty("$REPORT");
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            document.setProperty("$REPORT", (Object)this);
            int count = 1;
            MapContext mapContext = null;
            MapContext mapContextCandidate = null;
            for (IFFrame frame : context.getAllFFrames()) {
                if (!(frame instanceof FFrameView)) continue;
                if (mapContextCandidate == null) {
                    mapContextCandidate = ((FFrameView)frame).getMapContext();
                }
                String frameTag = frame.getTag();
                String countTag = "#" + count;
                if (!StringUtils.equalsIgnoreCase((CharSequence)this.parameters.getViewTag(), (CharSequence)frameTag) && !StringUtils.equalsIgnoreCase((CharSequence)this.parameters.getViewTag(), (CharSequence)countTag)) continue;
                mapContext = ((FFrameView)frame).getMapContext();
                break;
            }
            if (mapContext == null) {
                mapContext = mapContextCandidate;
            }
            if (mapContext != null) {
                Geometry geom;
                mapContext.setPrintGraphicsLayer(this.parameters.isHighlightRecord());
                ICoordTrans ct = null;
                for (FLayer layer : mapContext.getLayers().getLayers(null)) {
                    FeatureStore layerStore;
                    if (!(layer instanceof FLyrVect) || (layerStore = ((FLyrVect)layer).getFeatureStore()) == null || !layerStore.getParameters().isTheSameStore(this.store.getParameters())) continue;
                    ct = ((FLyrVect)layer).getCoordTrans();
                    break;
                }
                if ((geom = this.current_row.getDefaultGeometry()) != null) {
                    geom = geom.cloneGeometry();
                    if (ct != null && ct.getPOrig().equals(geom.getProjection())) {
                        geom.reProject(ct);
                    } else if (!geom.getProjection().equals(mapContext.getProjection())) {
                        ct = geom.getProjection().getCT(mapContext.getProjection());
                        geom.reProject(ct);
                    }
                    if (this.parameters.isZoomToCurrentRow()) {
                        Envelope envelope = geom.getEnvelope().getGeometry().buffer(this.parameters.getBufferSize()).getEnvelope();
                        mapContext.getViewPort().setEnvelope(envelope);
                    } else if (this.parameters.isCenterToCurrentRow()) {
                        Envelope envelope = geom.getEnvelope().getGeometry().buffer(this.parameters.getBufferSize()).getEnvelope();
                        this.center(mapContext, envelope);
                    }
                    if (this.parameters.isHighlightRecord()) {
                        GraphicLayer graphicsLayer = mapContext.getGraphicsLayer();
                        graphicsLayer.clear();
                        int idSymbol = graphicsLayer.addSymbol(this.parameters.getHighlightSymbol(this.store));
                        if (this.parameters.isApplySymbolToRecord()) {
                            // empty if block
                        }
                        if (this.parameters.isApplySymbolToEverythingExceptRecord()) {
                            Geometry viewPortGeom = mapContext.getViewPort().getAdjustedEnvelope().getGeometry();
                            if (geom.isValid()) {
                                geom = viewPortGeom.difference(geom);
                            } else {
                                Geometry geom2 = geom.fix();
                                if (geom2 != null) {
                                    geom = viewPortGeom.difference(geom2);
                                } else {
                                    geom = viewPortGeom;
                                    ISimpleTextSymbol textSymbol = SymbologyLocator.getSymbologyManager().createSimpleTextSymbol();
                                    textSymbol.setTextColor(Color.RED.darker());
                                    textSymbol.setHaloColor(Color.WHITE);
                                    textSymbol.setDrawWithHalo(true);
                                    int idPointSymbol = graphicsLayer.addSymbol((ISymbol)textSymbol);
                                    graphicsLayer.addGraphic("LayourReport", (Geometry)geom.centroid(), idPointSymbol, i18n.getTranslation("_Invalid_geometry"));
                                }
                            }
                        }
                        graphicsLayer.addGraphic("LayourReport", geom, idSymbol);
                    }
                }
            }
            context.fullRefresh();
            layout.getLayoutControl().getLayoutDraw().initialize();
            pdfFile = ToolsLocator.getFoldersManager().getUniqueTemporaryFile(new String[]{"report.pdf"});
            layout.layoutToPDF(pdfFile);
        }
        catch (Throwable th) {
            LOGGER.warn("Can't print report.", th);
            this.getStatus().message(i18n.getTranslation("_Cant_print_report") + "\n\n" + th.getMessage());
            throw th;
        }
        finally {
            document.setProperty("$REPORT", previous_report);
        }
        return pdfFile;
    }

    private void center(MapContext mapContext, Envelope envelope) throws LocatorException, CreateEnvelopeException {
        ViewPort viewPort = mapContext.getViewPort();
        Envelope oldExtent = viewPort.getAdjustedEnvelope();
        double oldCenterX = oldExtent.getCenter(0);
        double oldCenterY = oldExtent.getCenter(1);
        double centerX = envelope.getCenter(0);
        double centerY = envelope.getCenter(1);
        Point2D.Double center = new Point2D.Double(centerX, centerY);
        double movX = centerX - oldCenterX;
        double movY = centerY - oldCenterY;
        double minx = oldExtent.getMinimum(0) + movX;
        double miny = oldExtent.getMinimum(1) + movY;
        double maxX = oldExtent.getMaximum(0) + movX;
        double maxY = oldExtent.getMaximum(1) + movY;
        Envelope extent = GeometryLocator.getGeometryManager().createEnvelope(minx, miny, maxX, maxY, 0);
        viewPort.setEnvelope(extent);
    }

    private void showEmbedded(File pdfFile) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.showEmbedded(pdfFile));
            return;
        }
        try {
            WindowManager windowManager = ToolsSwingLocator.getWindowManager();
            PDFSwingManager pdfSwingManager = PDFSwingLocator.getPDFSwingManager();
            PDFManager pdfManager = PDFLocator.getPDFManager();
            PDFDocument pdfdoc = pdfManager.createPDFDocument(pdfFile);
            PDFViewer viewer = pdfSwingManager.createPDFViewer();
            viewer.put(pdfdoc);
            viewer.setMode(0);
            JComponent comp = viewer.asJComponent();
            Dimension size = ToolsSwingUtils.ensureRowsCols((Dimension)comp.getPreferredSize(), (int)20, (int)100, (int)40, (int)150);
            comp.setSize(size);
            String title = ToolsSwingUtils.makeTitle((String)"Report", (String)this.getLabel(), null);
            windowManager.showWindow(comp, title, WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show pdf file '" + Objects.toString(pdfFile) + "'", (Throwable)ex);
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_Cant_show_pdf_file") + " (" + Objects.toString(pdfFile) + ")\n\n" + BaseException.getMessageStack((Throwable)ex, (int)0), "Creating report '" + this.getReportLabel() + "'", 2);
        }
    }

    private void showExternal(File pdfFile) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.showExternal(pdfFile));
            return;
        }
        DesktopOpen desktop = ToolsUtilLocator.getToolsUtilManager().createDesktopOpen();
        desktop.open(pdfFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayoutPanel getTemplateAsLayout() throws Exception {
        ResourcesStorage.Resource resource = this.getTemplateAsResource();
        if (resource == null) {
            return null;
        }
        InputStream is = null;
        try {
            LayoutPanel layout;
            is = resource.asInputStream();
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            PersistentState persistentState = persistenceManager.loadState(is);
            LayoutPanel layoutPanel = layout = (LayoutPanel)persistenceManager.create(persistentState);
            return layoutPanel;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Override
    public ResourcesStorage.Resource getTemplateAsResource() {
        ResourcesStorage resources = this.store.getResourcesStorage();
        if (resources == null) {
            return null;
        }
        String templateName = this.parameters.getTemplateName();
        ResourcesStorage.Resource resource = resources.getResource(templateName);
        return resource;
    }

    public MutableSymbolTable getSymbolTable() {
        if (this.symbolTable == null) {
            this.symbolTable = ExpressionUtils.createSymbolTable();
            this.fSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
            this.fSymbolTable.setFeature(this.current_row);
            this.symbolTable.addSymbolTable((SymbolTable)this.fSymbolTable);
            this.symbolTable.setVar("$REPORT", (Object)this);
        }
        return this.symbolTable;
    }

    @Override
    public String evaluateDynamicText(String s) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        if (!manager.isDynamicText(s)) {
            return s;
        }
        String x = manager.evaluateDynamicText((SymbolTable)this.getSymbolTable(), s, null, this.store.getResourcesStorage());
        return x;
    }

    @Override
    public LayoutReportActionParameters getParameters() {
        return this.parameters;
    }
}

