/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools.behavior;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutBehavior;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutMoveListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutToolListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;

public class LayoutViewMoveBehavior
extends LayoutBehavior {
    private LayoutMoveListener listener;

    public LayoutViewMoveBehavior(LayoutMoveListener lpl) {
        this.listener = lpl;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle origClip = g.getClipBounds();
        g.drawImage(this.getLayoutControl().getImage(), 0, 0, this.getLayoutControl().getComponent());
        IFFrameUseFMap[] fframes = this.getLayoutControl().getLayoutContext().getSelectedFFrames(IFFrameUseFMap.class);
        for (int i = 0; i < fframes.length; ++i) {
            IFFrameUseFMap fframe = fframes[i];
            Rectangle2D.Double rec = fframe.getBoundingBox(this.getLayoutControl().getAT());
            if (this.getLayoutControl().getImage() != null) {
                rec = (Rectangle2D.Double)rec.createIntersection(this.getLayoutControl().getComponent().getVisibleRect());
            }
            if (fframe.getBufferedImage() == null) continue;
            Color c = g.getColor();
            g.setColor(fframe.getMapContext().getViewPort().getBackColor());
            g.fillRect((int)rec.x, (int)rec.y, (int)rec.width, (int)rec.height);
            g.setColor(c);
            g.clipRect((int)rec.x, (int)rec.y, (int)rec.width, (int)rec.height);
            g.drawImage(fframe.getBufferedImage(), (int)rec.getX() + this.getLayoutControl().getLastPoint().x - this.getLayoutControl().getPointAnt().x, (int)rec.getY() + this.getLayoutControl().getLastPoint().y - this.getLayoutControl().getPointAnt().y, this.getLayoutControl().getComponent());
            fframe.refresh();
        }
        g.setClip(origClip);
        this.getLayoutControl().getLayoutDraw().drawHandlers((Graphics2D)g, Color.black);
        g.drawImage(this.getLayoutControl().getImgRuler(), 0, 0, this.getLayoutControl().getComponent());
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        super.mousePressed(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.press(event);
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        super.mouseReleased(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.release(event);
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        super.mouseDragged(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.drag(event);
    }

    public void setListener(LayoutToolListener listener) {
        this.listener = (LayoutMoveListener)listener;
    }

    @Override
    public LayoutToolListener getListener() {
        return this.listener;
    }
}

