/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools.behavior;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutBehavior;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutMoveListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutToolListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;

public class LayoutViewZoomBehavior
extends LayoutBehavior {
    private LayoutMoveListener listener;
    private boolean dragged = false;

    public LayoutViewZoomBehavior(LayoutMoveListener lpl) {
        this.listener = lpl;
    }

    @Override
    public void paintComponent(Graphics g) {
        BufferedImage img = this.getLayoutControl().getImage();
        BufferedImage imgRuler = this.getLayoutControl().getImgRuler();
        g.drawImage(img, 0, 0, this.getLayoutControl().getComponent());
        g.drawImage(imgRuler, 0, 0, this.getLayoutControl().getComponent());
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        Rectangle r = new Rectangle();
        if (this.dragged && this.getLayoutControl().getFirstPoint() != null && this.getLayoutControl().getLastPoint() != null) {
            r.setFrameFromDiagonal(this.getLayoutControl().getFirstPoint(), this.getLayoutControl().getLastPoint());
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        IFFrame[] frames = this.getLayoutControl().getLayoutContext().getSelectedFFrames();
        for (int i = 0; i < frames.length; ++i) {
            g.setColor(Color.black);
            frames[i].drawHandlers((Graphics2D)g);
        }
        g.setPaintMode();
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        super.mousePressed(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.press(event);
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        super.mouseReleased(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.release(event);
        this.dragged = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        super.mouseDragged(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.drag(event);
        this.dragged = true;
    }

    public void setListener(LayoutToolListener listener) {
        this.listener = (LayoutMoveListener)listener;
    }

    @Override
    public LayoutToolListener getListener() {
        return this.listener;
    }
}

