/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools.listener;

import java.awt.geom.Rectangle2D;
import org.apache.commons.lang.StringUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameDialogNotification;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.IFFrameDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.IFFramePanel;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutAddRectangleListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public abstract class LayoutAddRectangleWithDialogListener
extends LayoutAddRectangleListener {
    public LayoutAddRectangleWithDialogListener(LayoutPanel layoutPanel) {
        super(layoutPanel);
    }

    private void doPanelAccept(IFFramePanel panel) {
        IFFrame newFrame = panel.getFFrame();
        if (newFrame != null) {
            this.layoutPanel.getLayoutContext().addFFrame(newFrame, true, true);
        }
        PluginServices.getMainFrame().enableControls();
        this.layoutPanel.getLayoutControl().refresh();
    }

    @Override
    public void rectangle(EnvelopeEvent event) throws BehaviorException {
        IFFrame fframe = this.layoutManager.createFrame(this.getFFrameName());
        fframe.setDocument(this.layoutPanel.getDocument());
        fframe.setLayoutContext(this.layoutPanel.getLayoutContext());
        Rectangle2D r = this.getRectangle(TOLERANCE);
        fframe.setBoundBox(FLayoutUtilities.toSheetRect(r, this.layoutPanel.getLayoutControl().getAT()));
        IFFramePanel panel = this.layoutManager.createFFrameDialog(fframe, this.layoutPanel);
        if (panel instanceof IFFrameDialog) {
            IFFrameDialog fframeDialog = (IFFrameDialog)panel;
            fframeDialog.addObserver((observable, notification) -> {
                if (notification instanceof FFrameDialogNotification && StringUtils.equals((String)((FFrameDialogNotification)((Object)((Object)notification))).getType(), (String)"DialogClosed")) {
                    this.doPanelAccept(panel);
                }
            });
            PluginServices.getMDIManager().addWindow((IWindow)fframeDialog);
        } else if (panel != null) {
            WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            Dialog dialog = winManager.createDialog(panel.asJComponent(), panel.getTitle(), "", 3);
            dialog.addActionListener(e -> {
                if (dialog.getAction() == 1) {
                    this.doPanelAccept(panel);
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
    }

    public abstract String getFFrameName();
}

