/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox.model;

import java.awt.geom.Rectangle2D;
import org.gvsig.layout.mapbox.model.Cell;
import org.gvsig.layout.mapbox.model.SelectionCell;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class SelectionCellImpl
implements SelectionCell {
    public static final String PERSISTENCE_DEFINITION_NAME = "SelectionCell";
    private Cell start;
    private Cell end;

    @Override
    public void add(Cell cell) {
        if (this.start == null) {
            this.start = cell;
            return;
        }
        this.end = cell;
    }

    @Override
    public boolean isSelected(Cell cell) {
        Rectangle2D r = this.getRectangle();
        if (r == null) {
            return false;
        }
        return cell.isContained(r);
    }

    @Override
    public void clear() {
        this.start = null;
        this.end = null;
    }

    @Override
    public Cell getStartCell() {
        return this.start;
    }

    @Override
    public Rectangle2D getRectangle() {
        if (this.start == null) {
            return null;
        }
        if (this.end == null) {
            return this.start.getRectangle();
        }
        Rectangle2D r1 = this.start.getRectangle();
        Rectangle2D r2 = this.end.getRectangle();
        double x = Math.min(r1.getMinX(), r2.getMinX());
        double y = Math.min(r1.getMinY(), r2.getMinY());
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, Math.max(r1.getMaxX(), r2.getMaxX()) - x, Math.max(r1.getMaxY(), r2.getMaxY()) - y);
        return r;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(SelectionCellImpl.class, PERSISTENCE_DEFINITION_NAME, "SelectionCell persistence definition", null, null);
            definition.addDynFieldObject("start").setClassOfValue(Cell.class).setMandatory(false);
            definition.addDynFieldObject("end").setClassOfValue(Cell.class).setMandatory(false);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("start", (Persistent)this.start);
        state.set("end", (Persistent)this.end);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.start = (Cell)state.get("start");
        this.end = (Cell)state.get("end");
    }

    public Object clone() throws CloneNotSupportedException {
        SelectionCellImpl other = (SelectionCellImpl)super.clone();
        other.start = (Cell)CloneableUtils.cloneQuietly((Cloneable)this.start);
        other.end = (Cell)CloneableUtils.cloneQuietly((Cloneable)this.end);
        return other;
    }
}

