/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox.tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.fframes.FFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutBehavior;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutToolListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.layout.mapbox.fframe.FFrameMapBox;
import org.gvsig.layout.mapbox.model.Cell;
import org.gvsig.layout.mapbox.tools.LayoutEditMapBoxListenerImpl;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutEditMapBoxBehavior
extends LayoutBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayoutEditMapBoxBehavior.class);
    private final LayoutEditMapBoxListenerImpl listener;
    private boolean dragging = false;
    private Point2D.Double pointPressed;
    private Pair<Integer, Cell> relativePosition;
    private FFrameMapBox dragFrame;

    public LayoutEditMapBoxBehavior(LayoutEditMapBoxListenerImpl lpl) {
        this.listener = lpl;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.getLayoutControl().getLayoutDraw().drawRectangle((Graphics2D)g);
        g.drawImage(this.getLayoutControl().getImage(), 0, 0, this.getLayoutControl().getComponent());
        this.getLayoutControl().getLayoutDraw().drawHandlers((Graphics2D)g, Color.black);
        if (this.dragFrame != null) {
            this.dragFrame.draw((Graphics2D)g, this.getLayoutControl().getAT());
        }
        g.drawImage(this.getLayoutControl().getImgRuler(), 0, 0, this.getLayoutControl().getComponent());
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        super.mousePressed(e);
        this.dragFrame = null;
        this.dragging = false;
        IFFrame[] fframes = this.getLayoutControl().getLayoutContext().getSelectedFFrames();
        if (fframes.length != 1 || !(fframes[0] instanceof FFrameMapBox)) {
            return;
        }
        AffineTransform at = this.getLayoutControl().getAT();
        for (IFFrame frame : fframes) {
            if (!(frame instanceof FFrameMapBox)) continue;
            this.pointPressed = FLayoutUtilities.toSheetPoint(e.getPoint(), at);
            this.relativePosition = ((FFrameMapBox)frame).getModel().getRelativePosition(((FFrameMapBox)frame).fromSheetPointToMapBoxPoint(this.pointPressed), FLayoutUtilities.toSheetDistance(2.0, at));
            if ((Integer)this.relativePosition.getLeft() != -1) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        super.mouseReleased(e);
        LayoutContext layoutContext = this.getLayoutControl().getLayoutContext();
        IFFrame[] fframes = layoutContext.getSelectedFFrames();
        if (fframes.length != 1 || !(fframes[0] instanceof FFrameMapBox)) {
            return;
        }
        FFrameMapBox currFrame = (FFrameMapBox)fframes[0];
        Point2D.Double point = FLayoutUtilities.toSheetPoint(e.getPoint(), this.getLayoutControl().getAT());
        try {
            FFrameMapBox newFrame = (FFrameMapBox)CloneableUtils.cloneQuietly((Cloneable)currFrame);
            if (this.dragging) {
                this.listener.drag(newFrame, (Integer)this.relativePosition.getLeft(), (Cell)this.relativePosition.getRight(), point);
            } else {
                Point2D.Double mapPoint = newFrame.fromSheetPointToMapBoxPoint(point);
                Cell cell = newFrame.getModel().getCell(mapPoint.getX(), mapPoint.getY());
                if (cell == null) {
                    return;
                }
                this.listener.selectCell(newFrame, cell);
            }
            layoutContext.getFrameCommandsRecord().update(currFrame, newFrame);
            layoutContext.updateFFrames();
        }
        catch (Exception ex) {
            LOGGER.warn("Failed releasing mouse over FFrameMapBox", (Throwable)ex);
        }
        finally {
            this.dragging = false;
            this.dragFrame = null;
        }
        this.getLayoutControl().refresh();
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        super.mouseDragged(e);
        IFFrame[] fframes = this.getLayoutControl().getLayoutContext().getSelectedFFrames();
        if (fframes.length != 1 || !(fframes[0] instanceof FFrameMapBox)) {
            return;
        }
        FFrameMapBox currFrame = (FFrameMapBox)fframes[0];
        this.dragFrame = (FFrameMapBox)CloneableUtils.cloneQuietly((Cloneable)currFrame);
        AffineTransform at = this.getLayoutControl().getAT();
        Point2D.Double point = FLayoutUtilities.toSheetPoint(e.getPoint(), at);
        Pair<Integer, Cell> rP = this.dragFrame.getModel().getRelativePosition(this.dragFrame.fromSheetPointToMapBoxPoint(this.pointPressed), FLayoutUtilities.toSheetDistance(2.0, at));
        this.dragging = true;
        Point2D.Double dragPoint = FLayoutUtilities.toSheetPoint(e.getPoint(), this.getLayoutControl().getAT());
        this.listener.drag(this.dragFrame, (Integer)rP.getLeft(), (Cell)rP.getRight(), dragPoint);
        this.getLayoutControl().refresh();
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
        super.mouseMoved(e);
        IFFrame[] fframes = this.getLayoutControl().getLayoutContext().getSelectedFFrames();
        if (fframes.length != 1 || !(fframes[0] instanceof FFrameMapBox)) {
            return;
        }
        FFrameMapBox currFrame = (FFrameMapBox)fframes[0];
        if (this.dragging) {
            return;
        }
        AffineTransform at = this.getLayoutControl().getAT();
        Point2D.Double point = FLayoutUtilities.toSheetPoint(e.getPoint(), at);
        Point2D.Double mapBoxPoint = currFrame.fromSheetPointToMapBoxPoint(point);
        Pair<Integer, Cell> cursorPosition = currFrame.getModel().getRelativePosition(mapBoxPoint, FLayoutUtilities.toSheetDistance(2.0, at));
        switch ((Integer)cursorPosition.getLeft()) {
            case 3: 
            case 4: {
                this.getLayoutControl().setMapCursor(FFrame.iEResize);
                break;
            }
            case 1: 
            case 2: {
                this.getLayoutControl().setMapCursor(FFrame.iNResize);
                break;
            }
            default: {
                this.getLayoutControl().setMapCursor(this.listener.getImageCursor());
            }
        }
    }

    @Override
    public LayoutToolListener getListener() {
        return this.listener;
    }

    @Override
    public boolean isAdjustable() {
        return true;
    }
}

