/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox.tools;

import java.awt.Image;
import java.awt.geom.Point2D;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.tools.AbstractLayoutToolListener;
import org.gvsig.layout.mapbox.fframe.FFrameMapBox;
import org.gvsig.layout.mapbox.model.Cell;

public class LayoutEditMapBoxListenerImpl
extends AbstractLayoutToolListener {
    public static final Image icrux = PluginServices.getIconTheme().get("cursor-layout-graphic-edit-vertex").getImage();

    public LayoutEditMapBoxListenerImpl(LayoutPanel layoutPanel) {
        super(layoutPanel);
    }

    @Override
    public Image getImageCursor() {
        return icrux;
    }

    @Override
    public boolean cancelDrawing() {
        return true;
    }

    public void selectCell(FFrameMapBox frame, Cell cell) {
        if (frame.getSelection().getStartCell() == null) {
            frame.getSelection().add(cell);
            return;
        }
        if (cell.equals(frame.getSelection().getStartCell())) {
            frame.getSelection().clear();
            return;
        }
        frame.getSelection().add(cell);
    }

    public void drag(FFrameMapBox frame, Integer relativePosition, Cell cell, Point2D.Double secondPoint) {
        switch (relativePosition) {
            case 1: {
                frame.moveHorizontalLine(cell.getY(), frame.fromSheetPointToMapBoxPoint(secondPoint).getY());
                break;
            }
            case 2: {
                frame.moveHorizontalLine(cell.getY() + cell.getHeight(), frame.fromSheetPointToMapBoxPoint(secondPoint).getY());
                break;
            }
            case 3: {
                frame.moveVerticalLine(cell.getX(), frame.fromSheetPointToMapBoxPoint(secondPoint).getX());
                break;
            }
            case 4: {
                frame.moveVerticalLine(cell.getX() + cell.getWidth(), frame.fromSheetPointToMapBoxPoint(secondPoint).getX());
                break;
            }
        }
    }
}

