/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.math.intervals;

public class IntervalUtils {
    public static double roundIntervalDivision(double intervalLength, int numberOfDivisions) {
        if (intervalLength <= 0.0 || numberOfDivisions <= 0) {
            return 0.0;
        }
        double division = intervalLength / (double)numberOfDivisions;
        if (division == 0.0) {
            return 0.0;
        }
        double digitShift = Math.floor(Math.log10(division));
        double scale = Math.pow(10.0, -digitShift);
        double firstSignificatDigit = Math.floor(scale * division);
        double result = firstSignificatDigit * Math.pow(10.0, digitShift);
        if (result * (double)numberOfDivisions >= intervalLength) {
            return result;
        }
        result = (0.5 + firstSignificatDigit) * Math.pow(10.0, digitShift);
        if (result * (double)numberOfDivisions >= intervalLength) {
            return result;
        }
        result = (1.0 + firstSignificatDigit) * Math.pow(10.0, digitShift);
        return result;
    }
}

