/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.connector;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Buffer;
import com.jcraft.jsch.agentproxy.Connector;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PageantConnector
implements Connector {
    private User32 libU = null;
    private Kernel32 libK = null;

    public PageantConnector() throws AgentProxyException {
        try {
            this.libU = User32.INSTANCE;
            this.libK = Kernel32.INSTANCE;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new AgentProxyException(unsatisfiedLinkError.toString());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new AgentProxyException(noClassDefFoundError.toString());
        }
    }

    @Override
    public String getName() {
        return "pageant";
    }

    public static boolean isConnectorAvailable() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    @Override
    public boolean isAvailable() {
        return PageantConnector.isConnectorAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Buffer buffer) throws AgentProxyException {
        WinNT.HANDLE hANDLE = null;
        Pointer pointer = null;
        WinDef.HWND hWND = this.libU.FindWindow("Pageant", "Pageant");
        if (hWND == null) {
            throw new AgentProxyException("Pageant is not runnning.");
        }
        String string = String.format("PageantRequest%08x", this.libK.GetCurrentThreadId());
        WinBase.SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES = null;
        hANDLE = this.libK.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, sECURITY_ATTRIBUTES, 4, 0, 8192, string);
        pointer = Kernel32.INSTANCE.MapViewOfFile(hANDLE, 2, 0, 0, 0);
        byte[] byArray = null;
        long l = 0L;
        try {
            Structure structure;
            pointer.write(0L, buffer.buffer, 0, buffer.getLength());
            if (Platform.is64Bit()) {
                structure = new COPYDATASTRUCT64();
                byArray = this.install64(string, (COPYDATASTRUCT64)structure);
                l = this.sendMessage(hWND, byArray);
            } else {
                structure = new COPYDATASTRUCT32();
                byArray = this.install32(string, (COPYDATASTRUCT32)structure);
                l = this.sendMessage(hWND, byArray);
            }
            buffer.rewind();
            if (l != 0L) {
                pointer.read(0L, buffer.buffer, 0, 4);
                int n = buffer.getInt();
                buffer.rewind();
                buffer.checkFreeSize(n);
                pointer.read(4L, buffer.buffer, 0, n);
            }
        }
        finally {
            if (pointer != null) {
                this.libK.UnmapViewOfFile(pointer);
            }
            if (hANDLE != null) {
                this.libK.CloseHandle(hANDLE);
            }
        }
    }

    private byte[] install32(String string, COPYDATASTRUCT32 cOPYDATASTRUCT32) {
        cOPYDATASTRUCT32.dwData = -2142351174;
        cOPYDATASTRUCT32.cbData = string.length() + 1;
        cOPYDATASTRUCT32.lpData = new Memory((long)(string.length() + 1));
        byte[] byArray = string.getBytes();
        cOPYDATASTRUCT32.lpData.write(0L, byArray, 0, byArray.length);
        cOPYDATASTRUCT32.lpData.setByte((long)byArray.length, (byte)0);
        cOPYDATASTRUCT32.write();
        byArray = new byte[12];
        Pointer pointer = cOPYDATASTRUCT32.getPointer();
        pointer.read(0L, byArray, 0, 12);
        return byArray;
    }

    private byte[] install64(String string, COPYDATASTRUCT64 cOPYDATASTRUCT64) {
        cOPYDATASTRUCT64.dwData = -2142351174;
        cOPYDATASTRUCT64.cbData = string.length() + 1;
        cOPYDATASTRUCT64.lpData = new Memory((long)(string.length() + 1));
        byte[] byArray = string.getBytes();
        cOPYDATASTRUCT64.lpData.write(0L, byArray, 0, byArray.length);
        cOPYDATASTRUCT64.lpData.setByte((long)byArray.length, (byte)0);
        cOPYDATASTRUCT64.write();
        byArray = new byte[24];
        Pointer pointer = cOPYDATASTRUCT64.getPointer();
        pointer.read(0L, byArray, 0, 24);
        return byArray;
    }

    long sendMessage(WinDef.HWND hWND, byte[] byArray) {
        long l = this.libU.SendMessage(hWND, 74, null, byArray);
        return l;
    }

    public class COPYDATASTRUCT64
    extends Structure {
        public int dwData;
        public long cbData;
        public Pointer lpData;

        protected List getFieldOrder() {
            return Arrays.asList("dwData", "cbData", "lpData");
        }
    }

    public class COPYDATASTRUCT32
    extends Structure {
        public int dwData;
        public int cbData;
        public Pointer lpData;

        protected List getFieldOrder() {
            return Arrays.asList("dwData", "cbData", "lpData");
        }
    }

    public static interface User32
    extends com.sun.jna.platform.win32.User32 {
        public static final User32 INSTANCE = (User32)Native.loadLibrary((String)"user32", User32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public long SendMessage(WinDef.HWND var1, int var2, WinDef.WPARAM var3, byte[] var4);
    }
}

