/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.connector;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Buffer;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import java.io.IOException;

public class SSHAgentConnector
implements Connector {
    private USocketFactory factory;

    public SSHAgentConnector(USocketFactory uSocketFactory) throws AgentProxyException {
        this.factory = uSocketFactory;
        USocketFactory.Socket socket = null;
        try {
            socket = this.open();
        }
        catch (IOException iOException) {
            throw new AgentProxyException(iOException.toString());
        }
        catch (Exception exception) {
            throw new AgentProxyException(exception.toString());
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                throw new AgentProxyException(iOException.toString());
            }
        }
    }

    @Override
    public String getName() {
        return "ssh-agent";
    }

    public static boolean isConnectorAvailable() {
        return System.getenv("SSH_AUTH_SOCK") != null;
    }

    @Override
    public boolean isAvailable() {
        return SSHAgentConnector.isConnectorAvailable();
    }

    private USocketFactory.Socket open() throws IOException {
        String string = System.getenv("SSH_AUTH_SOCK");
        if (string == null) {
            throw new IOException("SSH_AUTH_SOCK is not defined.");
        }
        return this.factory.open(string);
    }

    @Override
    public void query(Buffer buffer) throws AgentProxyException {
        USocketFactory.Socket socket = null;
        try {
            socket = this.open();
            socket.write(buffer.buffer, 0, buffer.getLength());
            buffer.rewind();
            int n = socket.readFull(buffer.buffer, 0, 4);
            n = buffer.getInt();
            buffer.rewind();
            buffer.checkFreeSize(n);
            n = socket.readFull(buffer.buffer, 0, n);
        }
        catch (IOException iOException) {
            throw new AgentProxyException(iOException.toString());
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                throw new AgentProxyException(iOException.toString());
            }
        }
    }
}

