/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import jline.Terminal;

public class WindowsTerminal
extends Terminal {
    private static final int ENABLE_LINE_INPUT = 2;
    private static final int ENABLE_ECHO_INPUT = 4;
    private static final int ENABLE_PROCESSED_INPUT = 1;
    private static final int ENABLE_WINDOW_INPUT = 8;
    private static final int ENABLE_MOUSE_INPUT = 16;
    private static final int ENABLE_PROCESSED_OUTPUT = 1;
    private static final int ENABLE_WRAP_AT_EOL_OUTPUT = 2;
    public static final int SPECIAL_KEY_INDICATOR = 224;
    public static final int NUMPAD_KEY_INDICATOR = 0;
    public static final int LEFT_ARROW_KEY = 75;
    public static final int RIGHT_ARROW_KEY = 77;
    public static final int UP_ARROW_KEY = 72;
    public static final int DOWN_ARROW_KEY = 80;
    public static final int DELETE_KEY = 83;
    public static final int HOME_KEY = 71;
    public static final char END_KEY = 'O';
    public static final char PAGE_UP_KEY = 'I';
    public static final char PAGE_DOWN_KEY = 'Q';
    public static final char INSERT_KEY = 'R';
    public static final char ESCAPE_KEY = '\u0000';
    private Boolean directConsole;
    private boolean echoEnabled;
    String encoding = System.getProperty("jline.WindowsTerminal.input.encoding", System.getProperty("file.encoding"));
    ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(this.encoding);
    InputStreamReader replayReader;

    public WindowsTerminal() {
        String string = System.getProperty("jline.WindowsTerminal.directConsole");
        if ("true".equals(string)) {
            this.directConsole = Boolean.TRUE;
        } else if ("false".equals(string)) {
            this.directConsole = Boolean.FALSE;
        }
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private native int getConsoleMode();

    private native void setConsoleMode(int var1);

    private native int readByte();

    private native int getWindowsTerminalWidth();

    private native int getWindowsTerminalHeight();

    @Override
    public int readCharacter(InputStream inputStream) throws IOException {
        if (this.directConsole == Boolean.FALSE) {
            return super.readCharacter(inputStream);
        }
        if (this.directConsole == Boolean.TRUE || inputStream == System.in || inputStream instanceof FileInputStream && ((FileInputStream)inputStream).getFD() == FileDescriptor.in) {
            return this.readByte();
        }
        return super.readCharacter(inputStream);
    }

    @Override
    public void initializeTerminal() throws Exception {
        this.loadLibrary("jline");
        final int n = this.getConsoleMode();
        this.setConsoleMode(n & 0xFFFFFFFB);
        int n2 = n & 0xFFFFFFF0;
        this.echoEnabled = false;
        this.setConsoleMode(n2);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void start() {
                    WindowsTerminal.this.setConsoleMode(n);
                }
            });
        }
        catch (AbstractMethodError abstractMethodError) {
            this.consumeException(abstractMethodError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLibrary(String string) throws IOException {
        String string2 = WindowsTerminal.class.getPackage().getImplementationVersion();
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2.replace('.', '_');
        File file = new File(System.getProperty("java.io.tmpdir"), string + "_" + string2 + ".dll");
        boolean bl = file.isFile();
        int n = 32;
        if (System.getProperty("os.arch").indexOf("64") != -1) {
            n = 64;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(WindowsTerminal.class.getResourceAsStream(string + n + ".dll"));
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[10240];
            int n2 = 0;
            while (n2 != -1) {
                outputStream.write(byArray, 0, n2);
                n2 = ((InputStream)bufferedInputStream).read(byArray);
            }
        }
        catch (IOException iOException) {
            if (!bl) {
                throw iOException;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        file.deleteOnExit();
        System.load(file.getAbsolutePath());
    }

    @Override
    public int readVirtualKey(InputStream inputStream) throws IOException {
        int n = this.readCharacter(inputStream);
        if (n == 224 || n == 0) {
            int n2 = this.readCharacter(inputStream);
            switch (n2) {
                case 72: {
                    return 16;
                }
                case 75: {
                    return 2;
                }
                case 77: {
                    return 6;
                }
                case 80: {
                    return 14;
                }
                case 83: {
                    return 127;
                }
                case 71: {
                    return 1;
                }
                case 79: {
                    return 5;
                }
                case 73: {
                    return 11;
                }
                case 81: {
                    return 12;
                }
                case 0: {
                    return 27;
                }
                case 82: {
                    return 3;
                }
            }
            return 0;
        }
        if (n > 128) {
            this.replayStream.setInput(n, inputStream);
            n = this.replayReader.read();
        }
        return n;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean isANSISupported() {
        return false;
    }

    @Override
    public boolean getEcho() {
        return false;
    }

    @Override
    public int getTerminalWidth() {
        return this.getWindowsTerminalWidth();
    }

    @Override
    public int getTerminalHeight() {
        return this.getWindowsTerminalHeight();
    }

    private void consumeException(Throwable throwable) {
    }

    public void setDirectConsole(Boolean bl) {
        this.directConsole = bl;
    }

    public Boolean getDirectConsole() {
        return this.directConsole;
    }

    @Override
    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    @Override
    public synchronized void enableEcho() {
        this.setConsoleMode(this.getConsoleMode() | 4 | 2 | 1 | 8);
        this.echoEnabled = true;
    }

    @Override
    public synchronized void disableEcho() {
        this.setConsoleMode(this.getConsoleMode() & 0xFFFFFFF0);
        this.echoEnabled = true;
    }

    @Override
    public InputStream getDefaultBindings() {
        return WindowsTerminal.class.getResourceAsStream("windowsbindings.properties");
    }

    static class ReplayPrefixOneCharInputStream
    extends InputStream {
        byte firstByte;
        int byteLength;
        InputStream wrappedStream;
        int byteRead;
        final String encoding;

        public ReplayPrefixOneCharInputStream(String string) {
            this.encoding = string;
        }

        public void setInput(int n, InputStream inputStream) throws IOException {
            this.byteRead = 0;
            this.firstByte = (byte)n;
            this.wrappedStream = inputStream;
            this.byteLength = 1;
            if (this.encoding.equalsIgnoreCase("UTF-8")) {
                this.setInputUTF8(n, inputStream);
            } else if (this.encoding.equalsIgnoreCase("UTF-16")) {
                this.byteLength = 2;
            } else if (this.encoding.equalsIgnoreCase("UTF-32")) {
                this.byteLength = 4;
            }
        }

        public void setInputUTF8(int n, InputStream inputStream) throws IOException {
            if ((this.firstByte & 0xFFFFFFE0) == -64) {
                this.byteLength = 2;
            } else if ((this.firstByte & 0xFFFFFFF0) == -32) {
                this.byteLength = 3;
            } else if ((this.firstByte & 0xFFFFFFF8) == -16) {
                this.byteLength = 4;
            } else {
                throw new IOException("invalid UTF-8 first byte: " + this.firstByte);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            ++this.byteRead;
            if (this.byteRead == 1) {
                return this.firstByte;
            }
            return this.wrappedStream.read();
        }

        @Override
        public int available() {
            return this.byteLength - this.byteRead;
        }
    }
}

