/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import java.io.FileInputStream;
import org.mozilla.universalchardet.CharsetListener;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EscCharsetProber;
import org.mozilla.universalchardet.prober.Latin1Prober;
import org.mozilla.universalchardet.prober.MBCSGroupProber;
import org.mozilla.universalchardet.prober.SBCSGroupProber;

public class UniversalDetector {
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    public static final float MINIMUM_THRESHOLD = 0.2f;
    private InputState inputState;
    private boolean done;
    private boolean start;
    private boolean gotData;
    private byte lastChar;
    private String detectedCharset;
    private CharsetProber[] probers;
    private CharsetProber escCharsetProber;
    private CharsetListener listener;

    public UniversalDetector(CharsetListener charsetListener) {
        this.listener = charsetListener;
        this.escCharsetProber = null;
        this.probers = new CharsetProber[3];
        for (int i = 0; i < this.probers.length; ++i) {
            this.probers[i] = null;
        }
        this.reset();
    }

    public boolean isDone() {
        return this.done;
    }

    public String getDetectedCharset() {
        return this.detectedCharset;
    }

    public void setListener(CharsetListener charsetListener) {
        this.listener = charsetListener;
    }

    public CharsetListener getListener() {
        return this.listener;
    }

    public void handleData(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.done) {
            return;
        }
        if (n2 > 0) {
            this.gotData = true;
        }
        if (this.start) {
            this.start = false;
            if (n2 > 3) {
                n5 = byArray[n] & 0xFF;
                n4 = byArray[n + 1] & 0xFF;
                n3 = byArray[n + 2] & 0xFF;
                int n6 = byArray[n + 3] & 0xFF;
                switch (n5) {
                    case 239: {
                        if (n4 != 187 || n3 != 191) break;
                        this.detectedCharset = Constants.CHARSET_UTF_8;
                        break;
                    }
                    case 254: {
                        if (n4 == 255 && n3 == 0 && n6 == 0) {
                            this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_3412;
                            break;
                        }
                        if (n4 != 255) break;
                        this.detectedCharset = Constants.CHARSET_UTF_16BE;
                        break;
                    }
                    case 0: {
                        if (n4 == 0 && n3 == 254 && n6 == 255) {
                            this.detectedCharset = Constants.CHARSET_UTF_32BE;
                            break;
                        }
                        if (n4 != 0 || n3 != 255 || n6 != 254) break;
                        this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_2143;
                        break;
                    }
                    case 255: {
                        if (n4 == 254 && n3 == 0 && n6 == 0) {
                            this.detectedCharset = Constants.CHARSET_UTF_32LE;
                            break;
                        }
                        if (n4 != 254) break;
                        this.detectedCharset = Constants.CHARSET_UTF_16LE;
                    }
                }
                if (this.detectedCharset != null) {
                    this.done = true;
                    return;
                }
            }
        }
        n5 = n + n2;
        for (n4 = n; n4 < n5; ++n4) {
            n3 = byArray[n4] & 0xFF;
            if ((n3 & 0x80) != 0 && n3 != 160) {
                if (this.inputState == InputState.HIGHBYTE) continue;
                this.inputState = InputState.HIGHBYTE;
                if (this.escCharsetProber != null) {
                    this.escCharsetProber = null;
                }
                if (this.probers[0] == null) {
                    this.probers[0] = new MBCSGroupProber();
                }
                if (this.probers[1] == null) {
                    this.probers[1] = new SBCSGroupProber();
                }
                if (this.probers[2] != null) continue;
                this.probers[2] = new Latin1Prober();
                continue;
            }
            if (this.inputState == InputState.PURE_ASCII && (n3 == 27 || n3 == 123 && this.lastChar == 126)) {
                this.inputState = InputState.ESC_ASCII;
            }
            this.lastChar = byArray[n4];
        }
        if (this.inputState == InputState.ESC_ASCII) {
            CharsetProber.ProbingState probingState;
            if (this.escCharsetProber == null) {
                this.escCharsetProber = new EscCharsetProber();
            }
            if ((probingState = this.escCharsetProber.handleData(byArray, n, n2)) == CharsetProber.ProbingState.FOUND_IT) {
                this.done = true;
                this.detectedCharset = this.escCharsetProber.getCharSetName();
            }
        } else if (this.inputState == InputState.HIGHBYTE) {
            for (n3 = 0; n3 < this.probers.length; ++n3) {
                CharsetProber.ProbingState probingState = this.probers[n3].handleData(byArray, n, n2);
                if (probingState != CharsetProber.ProbingState.FOUND_IT) continue;
                this.done = true;
                this.detectedCharset = this.probers[n3].getCharSetName();
                return;
            }
        }
    }

    public void dataEnd() {
        if (!this.gotData) {
            return;
        }
        if (this.detectedCharset != null) {
            this.done = true;
            if (this.listener != null) {
                this.listener.report(this.detectedCharset);
            }
            return;
        }
        if (this.inputState == InputState.HIGHBYTE) {
            float f = 0.0f;
            int n = 0;
            for (int i = 0; i < this.probers.length; ++i) {
                float f2 = this.probers[i].getConfidence();
                if (!(f2 > f)) continue;
                f = f2;
                n = i;
            }
            if (f > 0.2f) {
                this.detectedCharset = this.probers[n].getCharSetName();
                if (this.listener != null) {
                    this.listener.report(this.detectedCharset);
                }
            }
        } else if (this.inputState != InputState.ESC_ASCII && this.inputState == InputState.PURE_ASCII) {
            this.detectedCharset = "ISO-8859-15";
        }
    }

    public void reset() {
        this.done = false;
        this.start = true;
        this.detectedCharset = null;
        this.gotData = false;
        this.inputState = InputState.PURE_ASCII;
        this.lastChar = 0;
        if (this.escCharsetProber != null) {
            this.escCharsetProber.reset();
        }
        for (int i = 0; i < this.probers.length; ++i) {
            if (this.probers[i] == null) continue;
            this.probers[i].reset();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length != 1) {
            System.out.println("USAGE: java UniversalDetector filename");
            return;
        }
        UniversalDetector universalDetector = new UniversalDetector(new CharsetListener(){

            @Override
            public void report(String string) {
                System.out.println("charset = " + string);
            }
        });
        byte[] byArray = new byte[4096];
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        while ((n = fileInputStream.read(byArray)) > 0 && !universalDetector.isDone()) {
            universalDetector.handleData(byArray, 0, n);
        }
        universalDetector.dataEnd();
    }

    public static enum InputState {
        PURE_ASCII,
        ESC_ASCII,
        HIGHBYTE;

    }
}

