/*
 * Decompiled with CFR 0.152.
 */
package workbench;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import workbench.AppArguments;
import workbench.RunMode;
import workbench.console.SQLConsole;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.gui.DisconnectInfo;
import workbench.gui.MainWindow;
import workbench.gui.WbKeyDispatcher;
import workbench.gui.WbSwingUtilities;
import workbench.gui.bookmarks.BookmarkManager;
import workbench.gui.components.ColumnOrderMgr;
import workbench.gui.dbobjects.DbExplorerWindow;
import workbench.gui.filter.FilterDefinitionManager;
import workbench.gui.lnf.LnFHelper;
import workbench.gui.profiles.ProfileKey;
import workbench.gui.tools.DataPumper;
import workbench.gui.tools.ObjectSourceSearchPanel;
import workbench.interfaces.FontChangedListener;
import workbench.interfaces.ToolWindow;
import workbench.interfaces.ToolWindowManager;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.BatchRunner;
import workbench.sql.CommandRegistry;
import workbench.sql.OutputPrinter;
import workbench.sql.VariablePool;
import workbench.sql.macros.MacroManager;
import workbench.sql.wbcommands.InvalidConnectionDescriptor;
import workbench.ssh.SshConfigMgr;
import workbench.util.CollectionUtil;
import workbench.util.DeadlockMonitor;
import workbench.util.FileUtil;
import workbench.util.MacOSHelper;
import workbench.util.MemoryWatcher;
import workbench.util.StringUtil;
import workbench.util.UpdateCheck;
import workbench.util.VersionNumber;
import workbench.util.WbFile;
import workbench.util.WbThread;

public final class WbManager
implements FontChangedListener,
Runnable,
Thread.UncaughtExceptionHandler,
ToolWindowManager {
    private static WbManager wb;
    private final List<MainWindow> mainWindows = Collections.synchronizedList(new ArrayList(5));
    private final List<ToolWindow> toolWindows = Collections.synchronizedList(new ArrayList(5));
    private RunMode runMode;
    private boolean inShutdown = false;
    private boolean writeSettings = true;
    private boolean overWriteGlobalSettingsFile = true;
    private boolean outOfMemoryOcurred;
    private WbThread shutdownHook;
    private DeadlockMonitor deadlockMonitor;
    private final AppArguments cmdLine = new AppArguments();
    private boolean isWindowsClassic;
    private JDialog closeMessage;
    int exitCode = 0;

    private WbManager() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public static WbManager getInstance() {
        return wb;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        throwable.printStackTrace();
        LogMgr.logError(new CallerInfo(){}, "Thread '" + thread.getName() + "' caused an exception!", throwable);
    }

    public AppArguments getCommandLine() {
        return this.cmdLine;
    }

    public boolean getSettingsShouldBeSaved() {
        return this.writeSettings;
    }

    public void setOutOfMemoryOcurred() {
        this.outOfMemoryOcurred = true;
    }

    public boolean outOfMemoryOcurred() {
        return this.outOfMemoryOcurred;
    }

    public void showOutOfMemoryError() {
        this.outOfMemoryOcurred = true;
        this.showLowMemoryError();
    }

    public void showLowMemoryError() {
        WbSwingUtilities.showErrorMessageKey(this.getCurrentWindow(), "MsgLowMemoryError");
    }

    public boolean isDevBuild() {
        VersionNumber versionNumber = ResourceMgr.getBuildNumber();
        return versionNumber.getMajorVersion() == 999 || versionNumber.getMinorVersion() != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFrame getCurrentWindow() {
        if (this.mainWindows == null) {
            return this.getCurrentToolWindow();
        }
        if (this.mainWindows.size() == 1) {
            return this.mainWindows.get(0);
        }
        List<MainWindow> list = this.mainWindows;
        synchronized (list) {
            for (MainWindow mainWindow : this.mainWindows) {
                if (mainWindow == null || !mainWindow.hasFocus() && !mainWindow.isActive()) continue;
                return mainWindow;
            }
        }
        return null;
    }

    private JFrame getCurrentToolWindow() {
        Object object;
        if (this.toolWindows == null) {
            return null;
        }
        if (this.toolWindows.size() == 1 && (object = this.toolWindows.get(0)) != null) {
            return object.getWindow();
        }
        for (ToolWindow toolWindow : this.toolWindows) {
            JFrame jFrame;
            if (toolWindow == null || !(jFrame = toolWindow.getWindow()).hasFocus()) continue;
            return jFrame;
        }
        return null;
    }

    @Override
    public void registerToolWindow(ToolWindow toolWindow) {
        this.toolWindows.add(toolWindow);
    }

    @Override
    public void unregisterToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            return;
        }
        this.toolWindows.remove(toolWindow);
        if (this.toolWindows.isEmpty() && this.mainWindows.isEmpty()) {
            this.exitWorkbench(toolWindow.getWindow(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeToolWindows() {
        List<ToolWindow> list = this.toolWindows;
        synchronized (list) {
            for (ToolWindow toolWindow : this.toolWindows) {
                toolWindow.closeWindow();
            }
            this.toolWindows.clear();
        }
    }

    @Override
    public void fontChanged(String string, Font font) {
        if (string.equals("data")) {
            UIManager.put("Table.font", font);
            UIManager.put("TableHeader.font", font);
        }
    }

    public boolean isWindowsClassic() {
        return this.isWindowsClassic;
    }

    private void initUI() {
        LnFHelper lnFHelper = new LnFHelper();
        lnFHelper.initUI();
        this.isWindowsClassic = lnFHelper.isWindowsClassic();
        Settings.getInstance().addFontChangedListener(this);
        if (GuiSettings.installFocusManager()) {
            EventQueue.invokeLater(() -> FocusManager.getCurrentManager().addKeyEventDispatcher(WbKeyDispatcher.getInstance()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeWindowSettings() {
        if (!this.writeSettings) {
            return true;
        }
        boolean bl = false;
        if (!this.checkProfiles(this.getCurrentWindow())) {
            return false;
        }
        boolean bl2 = true;
        List<MainWindow> list = this.mainWindows;
        synchronized (list) {
            for (MainWindow mainWindow : this.mainWindows) {
                if (mainWindow == null) continue;
                if (!bl && mainWindow.hasFocus()) {
                    mainWindow.saveSettings();
                    bl = true;
                }
                if (mainWindow.isBusy() && !this.checkAbort(mainWindow)) {
                    return false;
                }
                bl2 = mainWindow.saveWorkspace(true);
                if (bl2) continue;
                return false;
            }
            if (!bl && this.mainWindows.size() > 0) {
                this.mainWindows.get(this.mainWindows.size() - 1).saveSettings();
            }
        }
        return bl2;
    }

    public RunMode getRunMode() {
        assert (this.runMode != null);
        return this.runMode;
    }

    public boolean isGUIMode() {
        assert (this.runMode != null);
        return this.runMode == RunMode.GUI;
    }

    public boolean isConsoleMode() {
        assert (this.runMode != null);
        return this.runMode == RunMode.Console;
    }

    public boolean isBatchMode() {
        assert (this.runMode != null);
        return this.runMode == RunMode.Batch;
    }

    public boolean canExit() {
        if (this.storeWindowSettings()) {
            if (Settings.getInstance().wasExternallyModified()) {
                String string = ResourceMgr.getFormattedString("MsgSettingsChanged", Settings.getInstance().getConfigFile().getFullPath());
                int n = WbSwingUtilities.getYesNoCancel(this.getCurrentWindow(), string);
                LogMgr.logDebug(new CallerInfo(){}, "Config file overwrite choice: " + WbSwingUtilities.choiceToString(n));
                this.overWriteGlobalSettingsFile = n == 0;
                return n != 2;
            }
            return true;
        }
        LogMgr.logDebug(new CallerInfo(){}, "saveWindowSettings() returned false!");
        return false;
    }

    public void exitWorkbench(boolean bl) {
        JFrame jFrame = this.getCurrentWindow();
        this.exitWorkbench(jFrame, bl);
    }

    public void exitWorkbench(JFrame jFrame, final boolean bl) {
        if (!this.canExit()) {
            return;
        }
        if (jFrame == null) {
            ConnectionMgr.getInstance().disconnectAll();
            this.doShutdown(0);
            return;
        }
        WbSwingUtilities.showWaitCursor(jFrame);
        WbSwingUtilities.invoke(() -> {
            this.createCloseMessageWindow(jFrame);
            if (this.closeMessage != null) {
                this.closeMessage.setVisible(true);
            }
        });
        MacroManager.getInstance().save();
        WbThread wbThread = new WbThread("WbManager disconnect"){

            @Override
            public void run() {
                WbManager.this.disconnectWindows(bl);
                ConnectionMgr.getInstance().disconnectAll();
                WbManager.this.disconnected();
            }
        };
        wbThread.start();
    }

    private void createCloseMessageWindow(JFrame jFrame) {
        if (jFrame == null) {
            return;
        }
        ActionListener actionListener = actionEvent -> this.doShutdown(0);
        this.closeMessage = new DisconnectInfo(jFrame, actionListener, "MsgAbortImmediately");
        WbSwingUtilities.center(this.closeMessage, jFrame);
    }

    private void disconnectWindows(boolean bl) {
        ArrayList<MainWindow> arrayList = new ArrayList<MainWindow>(this.mainWindows);
        for (MainWindow mainWindow : arrayList) {
            if (mainWindow == null) continue;
            if (bl) {
                mainWindow.forceDisconnect();
                continue;
            }
            mainWindow.abortAll();
            mainWindow.disconnect(false, true, false, false);
        }
    }

    private void disconnected() {
        WbSwingUtilities.invoke(() -> {
            if (this.closeMessage != null) {
                this.closeMessage.setVisible(false);
                this.closeMessage.dispose();
                this.closeMessage = null;
            }
        });
        this.doShutdown(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllWindows() {
        if (!this.isGUIMode()) {
            return;
        }
        LogMgr.logDebug(new CallerInfo(){}, "Closing all open windows");
        List<MainWindow> list = this.mainWindows;
        synchronized (list) {
            for (MainWindow mainWindow : this.mainWindows) {
                if (mainWindow == null) continue;
                try {
                    mainWindow.setVisible(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    mainWindow.dispose();
                }
                catch (Throwable throwable) {}
            }
            this.mainWindows.clear();
        }
        this.closeToolWindows();
    }

    public void saveConfigSettings() {
        if (this.writeSettings && !this.isBatchMode()) {
            if (this.overWriteGlobalSettingsFile) {
                Settings.getInstance().saveSettings(this.outOfMemoryOcurred);
            } else {
                LogMgr.logInfo(new CallerInfo(){}, "Not overwritting global settings!");
            }
            SshConfigMgr.getDefaultInstance().saveGlobalConfig();
            FilterDefinitionManager.getDefaultInstance().saveSettings(Settings.getInstance());
            try {
                ColumnOrderMgr.getInstance().saveSettings();
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not write column order storage", exception);
            }
        } else {
            LogMgr.logDebug(new CallerInfo(){}, "Settings not saved. writeSettings=" + this.writeSettings + ", runMode=" + (Object)((Object)this.runMode));
        }
    }

    private void installShutdownHook() {
        this.shutdownHook = new WbThread(this, "ShutdownHook");
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.shutdownHook = null;
        }
        if (this.deadlockMonitor != null) {
            this.deadlockMonitor.cancel();
        }
    }

    public void doShutdown(int n) {
        this.removeShutdownHook();
        this.closeAllWindows();
        this.saveConfigSettings();
        LogMgr.logInfo(new CallerInfo(){}, "Stopping SQL Workbench/J, Build " + ResourceMgr.getString("TxtBuildNumber"));
        LogMgr.shutdown();
        if (WbManager.shouldDoSystemExit()) {
            System.exit(n);
        }
    }

    public static boolean shouldDoSystemExit() {
        return "true".equals(System.getProperty("workbench.system.doexit", "true"));
    }

    private boolean checkAbort(MainWindow mainWindow) {
        return WbSwingUtilities.getYesNo(mainWindow, ResourceMgr.getString("MsgAbortRunningSql"));
    }

    private boolean checkProfiles(JFrame jFrame) {
        if (ConnectionMgr.getInstance().profilesAreModified()) {
            int n = JOptionPane.showConfirmDialog(jFrame, ResourceMgr.getString("MsgConfirmUnsavedProfiles"), "SQL Workbench/J", 1);
            if (n == 0) {
                ConnectionMgr.getInstance().saveProfiles();
                return true;
            }
            return n == 1;
        }
        return true;
    }

    public void closeMainWindow(final MainWindow mainWindow) {
        if (this.mainWindows.size() == 1) {
            if (!this.inShutdown) {
                this.inShutdown = true;
                this.exitWorkbench(mainWindow, mainWindow.isBusy());
            } else {
                LogMgr.logWarning(new CallerInfo(){}, "Ignoring second attempt to shutdown the application", new Exception("Backtrace"));
            }
        } else if (mainWindow != null) {
            if (mainWindow.isBusy() && !this.checkAbort(mainWindow)) {
                return;
            }
            if (!mainWindow.saveWorkspace()) {
                return;
            }
            this.mainWindows.remove(mainWindow);
            BookmarkManager.getInstance().clearBookmarksForWindow(mainWindow.getWindowId());
            WbThread wbThread = new WbThread(mainWindow.getWindowId() + " Disconnect"){

                @Override
                public void run() {
                    mainWindow.disconnect(false, false, false, false);
                    mainWindow.setVisible(false);
                    mainWindow.dispose();
                    ConnectionMgr.getInstance().dumpConnections();
                }
            };
            wbThread.start();
        }
    }

    public void openNewWindow() {
        EventQueue.invokeLater(() -> this.openNewWindow(false));
    }

    private void openNewWindow(boolean bl) {
        Object object;
        Object object2;
        GraphicsConfiguration graphicsConfiguration = null;
        if (bl) {
            object2 = MainWindow.class.getName() + ".screen";
            String string = Settings.getInstance().getProperty((String)object2, null);
            if (string != null) {
                for (GraphicsDevice graphicsDevice : object = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                    if (!string.equals(graphicsDevice.getIDstring())) continue;
                    graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                    break;
                }
            }
        }
        object2 = new MainWindow(graphicsConfiguration);
        this.mainWindows.add((MainWindow)object2);
        ((MainWindow)object2).display();
        boolean bl2 = false;
        if (bl) {
            ConnectionProfile connectionProfile;
            object = this.cmdLine.getValue("profile");
            String bl4 = this.cmdLine.getValue("profilegroup");
            if (!StringUtil.isEmptyString((CharSequence)object)) {
                ProfileKey profileKey = new ProfileKey((String)object, bl4);
                connectionProfile = ConnectionMgr.getInstance().getProfile(profileKey);
            } else {
                try {
                    connectionProfile = BatchRunner.createCmdLineProfile(this.cmdLine);
                }
                catch (InvalidConnectionDescriptor invalidConnectionDescriptor) {
                    LogMgr.logError(new CallerInfo(){}, "Invalid connection descriptor specified", invalidConnectionDescriptor);
                    connectionProfile = null;
                }
            }
            if (connectionProfile != null) {
                LogMgr.logDebug(new CallerInfo(){}, "Connecting to " + connectionProfile.getName());
                ((MainWindow)object2).connectTo(connectionProfile, true, true);
                bl2 = true;
            }
        }
        boolean bl3 = Settings.getInstance().getShowConnectDialogOnStartup();
        boolean bl4 = Settings.getInstance().getExitOnFirstConnectCancel();
        if (!bl2 && bl3) {
            EventQueue.invokeLater(() -> WbManager.lambda$openNewWindow$5((MainWindow)object2, bl4));
        }
    }

    public void readParameters(String[] stringArray, RunMode runMode) {
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            Object object;
            boolean bl;
            String string6;
            Object object2;
            String string2;
            String string3;
            String string4;
            this.cmdLine.parse(stringArray);
            String string5 = this.cmdLine.getValue("language");
            if (StringUtil.isNonEmpty(string5)) {
                System.setProperty("workbench.gui.language", string5);
            }
            if (this.cmdLine.isArgPresent("logAllStatements")) {
                boolean bl2 = this.cmdLine.getBoolean("logAllStatements", false);
                System.setProperty("workbench.sql.log.statements", Boolean.toString(bl2));
            }
            if (StringUtil.isNonEmpty(string4 = this.cmdLine.getValue("configDir"))) {
                System.setProperty("workbench.configdir", string4);
            }
            if (StringUtil.isNonEmpty(string3 = this.cmdLine.getValue("libdir"))) {
                System.setProperty("workbench.libdir", string3);
            }
            if (StringUtil.isNonEmpty(string2 = this.cmdLine.getValue("logfile"))) {
                object2 = new WbFile(string2);
                System.setProperty("workbench.log.filename", ((WbFile)object2).getFullPath());
            }
            if (StringUtil.isNonEmpty((CharSequence)(object2 = this.cmdLine.getValue("logLevel")))) {
                System.setProperty("workbench.log.level", (String)object2);
            }
            if (this.cmdLine.isArgPresent("noSettings")) {
                this.writeSettings = false;
            }
            List<String> list = this.cmdLine.getList("prop");
            for (String string6 : list) {
                String[] stringArray2 = string6.split("=");
                if (stringArray2.length != 2) continue;
                System.setProperty(stringArray2[0], stringArray2[1]);
            }
            Settings.getInstance().initialize();
            String string7 = this.cmdLine.getValue("script");
            string6 = this.cmdLine.getValue("command");
            if (StringUtil.isEmptyString(string6) && this.cmdLine.isArgPresent("command")) {
                string6 = FileUtil.getSystemIn();
                this.cmdLine.setCommandString(string6);
            }
            boolean bl3 = true;
            boolean bl4 = this.cmdLine.isArgPresent("help");
            boolean bl5 = bl = StringUtil.isNonBlank(string7) || StringUtil.isNonBlank(string6);
            this.runMode = runMode == null ? (bl || bl4 ? RunMode.Batch : RunMode.GUI) : runMode;
            if (BatchRunner.hasConnectionArgument(this.cmdLine) || this.runMode != RunMode.GUI) {
                bl3 = false;
            }
            this.readVariablesFromCommandline();
            List<String> list2 = this.cmdLine.getListValue("profileStorage");
            ArrayList<WbFile> arrayList = new ArrayList<WbFile>(list2.size());
            Object object3 = list2.iterator();
            while (object3.hasNext()) {
                object = object3.next();
                File file = Settings.getInstance().getConfigDir();
                if (!StringUtil.isNonEmpty((CharSequence)object)) continue;
                WbFile wbFile = new WbFile((String)(object = StringUtil.replaceProperties((String)object)));
                if (wbFile.getParentFile() == null) {
                    wbFile = new WbFile(file, (String)object);
                }
                arrayList.add(wbFile);
            }
            Settings.getInstance().setProfileStorage(arrayList);
            if (this.cmdLine.isArgPresent("noTemplates")) {
                bl3 = false;
            }
            if (!bl3) {
                System.setProperty("workbench.jdbc.read.drivertemplates", "false");
            }
            if (StringUtil.isNonEmpty((CharSequence)(object3 = this.cmdLine.getValue("macroStorage"))) && ((File)(object = new WbFile((String)object3))).exists()) {
                object3 = ((WbFile)object).getFullPath();
            }
            Settings.getInstance().setMacroStorage((String)object3);
            LogMgr.logInfo(callerInfo, "Starting SQL Workbench/J, " + ResourceMgr.getBuildInfo());
            LogMgr.logInfo(callerInfo, ResourceMgr.getFullJavaInfo());
            LogMgr.logInfo(callerInfo, ResourceMgr.getOSInfo());
            long l = MemoryWatcher.MAX_MEMORY / 0x100000L;
            LogMgr.logInfo(callerInfo, "Available memory: " + l + "MB");
            LogMgr.logInfo(callerInfo, "Classpath: " + System.getProperty("java.class.path"));
            if (this.cmdLine.isArgPresent("noSettings")) {
                LogMgr.logInfo(callerInfo, "The 'noSettings' option was specified on the commandline. Global settings will not be saved.");
            }
        }
        catch (Exception exception) {
            LogMgr.logError(callerInfo, "Error initializing command line arguments!", exception);
        }
    }

    private void readVariablesFromCommandline() {
        if (this.cmdLine.isArgPresent("varDef")) {
            String string = "Using -varDef is deprecated. Please use -variable or -varFile instead";
            LogMgr.logWarning(new CallerInfo(){}, string);
        }
        boolean bl = Settings.getInstance().getCommandLineVarsAreGlobal();
        List<String> list = this.cmdLine.getList("varDef");
        for (String iterator : list) {
            try {
                VariablePool.getInstance().readDefinition(StringUtil.trimQuotes(iterator), bl);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error reading variable definition from file: " + iterator, exception);
            }
        }
        List<String> list2 = this.cmdLine.getListValue("varFile");
        if (CollectionUtil.isNonEmpty(list2)) {
            for (String string : list2) {
                try {
                    VariablePool.getInstance().readFromFile(StringUtil.trimQuotes(string), null, true);
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error reading variable definition from file: " + string, exception);
                }
            }
        }
        list = this.cmdLine.getList("variable");
        for (String string : list) {
            try {
                VariablePool.getInstance().parseSingleDefinition(string, bl);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error parsing variable definition: " + string, exception);
            }
        }
    }

    public void startApplication() {
        if (this.isBatchMode()) {
            CommandRegistry.getInstance().scanForExtensions();
            this.runBatch();
        } else {
            this.initRegistry();
            boolean bl = Settings.getInstance().getBoolProperty("workbench.gui.warmup", false);
            boolean bl2 = bl = bl || !Settings.getInstance().getShowConnectDialogOnStartup();
            if (bl) {
                this.warmUp();
            }
            MacOSHelper macOSHelper = new MacOSHelper();
            macOSHelper.installApplicationHandler();
            EventQueue.invokeLater(this::runGui);
        }
    }

    private void initRegistry() {
        WbThread wbThread = new WbThread("ExtensionScannerThread"){

            @Override
            public void run() {
                CommandRegistry commandRegistry = CommandRegistry.getInstance();
                commandRegistry.scanForExtensions();
            }
        };
        wbThread.start();
    }

    private void warmUp() {
        WbThread wbThread = new WbThread("BackgroundProfilesLoader"){

            @Override
            public void run() {
                ConnectionMgr.getInstance().getProfiles();
            }
        };
        wbThread.start();
        WbThread wbThread2 = new WbThread("BackgroundMacrosLoader"){

            @Override
            public void run() {
                MacroManager.getInstance();
            }
        };
        wbThread2.start();
    }

    public void runGui() {
        Object object;
        this.initUI();
        boolean bl = this.cmdLine.isArgPresent("dataPumper");
        boolean bl2 = this.cmdLine.isArgPresent("dbExplorer");
        boolean bl3 = this.cmdLine.isArgPresent("objectSearcher");
        String string = this.cmdLine.getValue("extension");
        if (bl) {
            new DataPumper().showWindow();
        } else if (bl2) {
            DbExplorerWindow.showWindow();
        } else if (bl3) {
            new ObjectSourceSearchPanel().showWindow();
        } else if (string != null) {
            object = CommandRegistry.getInstance();
            ((CommandRegistry)object).scanForGuiExtensions();
            ToolWindow toolWindow = ((CommandRegistry)object).getGuiExtension(string);
            if (toolWindow != null) {
                toolWindow.getWindow();
            } else {
                LogMgr.logWarning(new CallerInfo(){}, "could not find extension " + string);
                this.openNewWindow(true);
            }
        } else {
            this.openNewWindow(true);
        }
        if (Settings.getInstance().getBoolProperty("workbench.gui.debug.deadlockmonitor.enabled", false)) {
            LogMgr.logInfo(new CallerInfo(){}, "Starting DeadlockMonitor");
            this.deadlockMonitor = new DeadlockMonitor();
            this.deadlockMonitor.start();
        }
        object = new UpdateCheck();
        ((UpdateCheck)object).startUpdateCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runBatch() {
        this.exitCode = 0;
        var1_1 = Settings.getInstance().getBoolProperty("workbench.batch.objectcache.save", false);
        var2_2 = BatchRunner.createBatchRunner(this.cmdLine);
        if (var2_2 != null) {
            try {
                var2_2.connect();
            }
            catch (Exception var3_3) {
                this.exitCode = 1;
            }
            var2_2.setTraceOutput((OutputPrinter)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)System.out));
            try {
                if (!var2_2.isSuccess()) ** GOTO lbl34
                var2_2.execute();
                if (var2_2.isSuccess()) ** GOTO lbl34
                this.exitCode = 2;
            }
            catch (OutOfMemoryError var3_5) {
                LogMgr.logError(new CallerInfo(){}, "Not enough memory to finish the operation. Aborting execution!", null);
                System.err.println("Not enough memory to finish the operation. Aborting execution!");
                this.exitCode = 10;
            }
            catch (Exception var3_7) {
                this.exitCode = 2;
            }
            finally {
                var3_6 = ConnectionMgr.getInstance();
                if (var3_6 != null) {
                    var3_6.disconnectAll(var1_1);
                }
            }
        } else {
            this.exitCode = 3;
        }
lbl34:
        // 6 sources

        this.doShutdown(this.exitCode);
    }

    public static void initConsoleMode() {
        System.setProperty("workbench.log.console", "false");
        wb = new WbManager();
        WbManager.wb.cmdLine.removeArgument("dataPumper");
        WbManager.wb.cmdLine.removeArgument("dbExplorer");
        WbManager.wb.cmdLine.removeArgument("objectSearcher");
        WbManager.wb.cmdLine.removeArgument("separateConnection");
        WbManager.wb.cmdLine.removeArgument("workspace");
        WbManager.wb.runMode = RunMode.Console;
        WbManager.wb.writeSettings = false;
    }

    public static void prepareForEmbedded() {
        WbManager.runEmbedded(null, false);
    }

    public static void runEmbedded(String[] stringArray) {
        WbManager.runEmbedded(stringArray, true);
    }

    private static void runEmbedded(String[] stringArray, boolean bl) {
        wb = new WbManager();
        String[] stringArray2 = null;
        String string = "-notemplates -nosettings";
        if (stringArray == null) {
            stringArray2 = new String[]{string};
        } else {
            stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
        }
        System.setProperty("workbench.system.doexit", "false");
        System.setProperty("workbench.gui.testmode", "true");
        wb.readParameters(stringArray2, null);
        if (bl) {
            wb.startApplication();
        }
    }

    public static boolean isTest() {
        return "true".equals(System.getProperty("workbench.gui.testmode", "false"));
    }

    public static void prepareForTest(String[] stringArray) {
        wb = new WbManager();
        System.setProperty("workbench.gui.testmode", "true");
        System.setProperty("workbench.log.console", "false");
        System.setProperty("workbench.log.log4j", "false");
        System.setProperty("workbench.gui.language", "en");
        wb.readParameters(stringArray, null);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = StringUtil.stringToBool(System.getProperty("workbench.gui.checkheadless", "true"));
        if (bl2 && GraphicsEnvironment.isHeadless()) {
            WbManager.initConsoleMode();
            bl = true;
        } else {
            wb = new WbManager();
        }
        wb.readParameters(stringArray, null);
        if (bl) {
            LogMgr.logInfo(new CallerInfo(){}, "Forcing console mode because the Java runtime claims this is a headless system. Use -Dworkbench.gui.checkheadless=false to disable the check");
        }
        boolean bl3 = WbManager.wb.cmdLine.isArgPresent("script") || WbManager.wb.cmdLine.isArgPresent("command");
        boolean bl4 = WbManager.wb.cmdLine.isArgPresent("help");
        boolean bl5 = WbManager.wb.cmdLine.isArgPresent("version");
        if (bl4 || bl5) {
            if (bl4) {
                System.out.println(WbManager.wb.cmdLine.getHelp());
            }
            if (bl5) {
                System.out.println("SQL Workbench/J " + ResourceMgr.getBuildInfo());
            }
            System.exit(0);
        }
        if (bl && !bl3) {
            SQLConsole.runConsole();
        } else {
            wb.installShutdownHook();
            wb.startApplication();
        }
    }

    @Override
    public void run() {
        LogMgr.logWarning(new CallerInfo(){}, "SQL Workbench/J process has been interrupted.");
        this.saveConfigSettings();
        boolean bl = Settings.getInstance().getBoolProperty("workbench.exitonbreak", true);
        if (bl) {
            LogMgr.logWarning(new CallerInfo(){}, "Aborting process...");
            LogMgr.shutdown();
            Runtime.getRuntime().halt(15);
        } else {
            ConnectionMgr.getInstance().disconnectAll();
            LogMgr.shutdown();
        }
    }

    private static /* synthetic */ void lambda$openNewWindow$5(MainWindow mainWindow, boolean bl) {
        mainWindow.selectConnection(bl, GuiSettings.checkExtDir());
    }
}

