/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import workbench.console.ConsoleSettings;
import workbench.console.TextPrinter;
import workbench.db.exporter.TextRowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.RowData;
import workbench.util.CharacterRange;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public abstract class ConsolePrinter {
    protected Map<Integer, Integer> columnWidths;
    protected TextRowDataConverter converter = new TextRowDataConverter();
    protected boolean doFormat = true;
    protected boolean showRowCount = true;
    protected boolean printRowAsLine = true;
    protected Set<String> includedColumns;
    protected String nullString;
    protected boolean showResultName = true;

    protected abstract String getResultName();

    protected abstract Map<Integer, Integer> getColumnSizes();

    protected abstract int getColumnCount();

    protected abstract String getColumnName(int var1);

    protected abstract int getColumnType(int var1);

    public ConsolePrinter() {
        this.converter.setNullString(ConsoleSettings.getNullString());
        this.converter.setDefaultNumberFormatter(Settings.getInstance().createDefaultDecimalFormatter());
        this.converter.setDefaultIntegerFormatter(Settings.getInstance().createDefaultIntegerFormatter());
        this.nullString = ConsoleSettings.getNullString();
    }

    public void setShowResultName(boolean bl) {
        this.showResultName = bl;
    }

    public void setNullString(String string) {
        this.nullString = string;
    }

    public void setPrintRowsAsLine(boolean bl) {
        this.printRowAsLine = bl;
    }

    public void setFormatColumns(boolean bl) {
        this.doFormat = bl;
    }

    public void setPrintRowCount(boolean bl) {
        this.showRowCount = bl;
    }

    protected void printHeader(TextPrinter textPrinter) {
        int n;
        if (!this.printRowAsLine) {
            return;
        }
        if (this.columnWidths == null && this.doFormat) {
            this.columnWidths = this.getColumnSizes();
        }
        String string = this.getResultName();
        if (this.showResultName && StringUtil.isNonBlank(string)) {
            textPrinter.println("---- " + string);
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.getColumnCount(); ++n) {
            String string2 = this.getColumnName(n);
            if (!this.isColumnIncluded(string2)) continue;
            if (n3 > 0) {
                textPrinter.print(" | ");
            }
            if (this.doFormat) {
                int n4 = this.columnWidths.get(n);
                this.writePadded(textPrinter, string2, n4, false);
                n2 += n4;
            } else {
                textPrinter.print(string2);
            }
            ++n3;
        }
        textPrinter.println();
        if (n2 > 0 && this.doFormat) {
            n3 = 0;
            for (n = 0; n < this.getColumnCount(); ++n) {
                if (!this.isColumnIncluded(n)) continue;
                if (n3 > 0) {
                    if (Settings.getInstance().useMarkDownForConsolePrint()) {
                        textPrinter.print("-|-");
                    } else {
                        textPrinter.print("-+-");
                    }
                }
                textPrinter.print(StringUtil.padRight("-", this.columnWidths.get(n), '-'));
                ++n3;
            }
            textPrinter.println();
        }
    }

    public void setColumnsToPrint(Collection<String> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            this.includedColumns = null;
        }
        this.includedColumns = CollectionUtil.caseInsensitiveSet();
        this.includedColumns.addAll(collection);
    }

    protected void printRow(TextPrinter textPrinter, RowData rowData, int n) {
        if (this.printRowAsLine) {
            this.printAsLine(textPrinter, rowData);
        } else {
            this.printAsRecord(textPrinter, rowData, n);
        }
    }

    protected boolean isColumnIncluded(String string) {
        if (this.includedColumns == null) {
            return true;
        }
        return this.includedColumns.contains(string);
    }

    protected boolean isColumnIncluded(int n) {
        return this.isColumnIncluded(this.getColumnName(n));
    }

    public void printAsRecord(TextPrinter textPrinter, RowData rowData, int n) {
        String string;
        int n2;
        int n3 = rowData.getColumnCount();
        int n4 = 0;
        textPrinter.println("---- [" + ResourceMgr.getString("TxtRow") + " " + (n + 1) + "] -------------------------------");
        for (n2 = 0; n2 < n3; ++n2) {
            string = this.getColumnName(n2);
            if (string.length() <= n4) continue;
            n4 = string.length();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            string = this.getColumnName(n2);
            if (!this.isColumnIncluded(string)) continue;
            String string2 = this.getDisplayValue(rowData, n2);
            this.writePadded(textPrinter, string, n4 + 1, false);
            textPrinter.print(": ");
            if (this.doFormat) {
                String[] stringArray = string2.split("((\r\n)|(\n\r)|\r|\n)");
                textPrinter.println(stringArray[0]);
                if (stringArray.length <= 1) continue;
                for (int i = 1; i < stringArray.length; ++i) {
                    this.writePadded(textPrinter, " ", n4 + 3, false);
                    textPrinter.println(stringArray[i]);
                }
                continue;
            }
            textPrinter.println(string2);
        }
    }

    protected String getDisplayValue(RowData rowData, int n) {
        int n2 = this.getColumnType(n);
        String string = null;
        if (SqlUtil.isBlobType(n2)) {
            Object object = rowData.getValue(n);
            if (object instanceof String) {
                string = (String)rowData.getValue(n);
            } else if (object != null) {
                string = "(BLOB)";
            }
        } else {
            string = this.converter.getValueAsFormattedString(rowData, n);
        }
        if (string == null) {
            string = this.nullString;
        }
        return string;
    }

    protected void printAsLine(TextPrinter textPrinter, RowData rowData) {
        int n = rowData.getColumnCount();
        try {
            HashMap<Integer, String[]> hashMap = new HashMap<Integer, String[]>(n);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!this.isColumnIncluded(i)) continue;
                if (n2 > 0) {
                    textPrinter.print(" | ");
                }
                String string = this.getDisplayValue(rowData, i);
                if (this.doFormat) {
                    int n3 = this.columnWidths.get(i);
                    String[] stringArray = string.split("((\r\n)|(\n\r)|\r|\n)");
                    if (stringArray.length == 0) {
                        this.writePadded(textPrinter, string.trim(), n3, this.alignRight(i));
                    } else {
                        this.writePadded(textPrinter, stringArray[0], n3, this.alignRight(i));
                        if (stringArray.length > 1) {
                            hashMap.put(i, stringArray);
                        }
                    }
                } else {
                    textPrinter.print(StringUtil.escapeText(string, CharacterRange.RANGE_CONTROL));
                }
                ++n2;
            }
            textPrinter.println();
            this.printContinuationLines(textPrinter, hashMap);
            textPrinter.flush();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when printing DataStore contents", exception);
        }
    }

    private boolean alignRight(int n) {
        if (GuiSettings.getNumberDataAlignment() == 2) {
            return false;
        }
        int n2 = this.getColumnType(n);
        return SqlUtil.isNumberType(n2);
    }

    private int getColStartColumn(int n) {
        if (this.columnWidths == null) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.columnWidths.get(i).intValue();
            if (i <= 0) continue;
            n2 += 3;
        }
        return n2;
    }

    private void printContinuationLines(TextPrinter textPrinter, Map<Integer, String[]> map) {
        boolean bl = true;
        int n = this.getColumnCount();
        int n2 = 1;
        int n3 = 0;
        while (bl) {
            bl = false;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                if (!this.isColumnIncluded(i)) continue;
                String[] stringArray = map.get(i);
                ++n3;
                if (stringArray == null || stringArray.length <= n2) continue;
                int n5 = this.getColStartColumn(i) - n4;
                this.writePadded(textPrinter, "", n5, false);
                if (n3 > 1) {
                    textPrinter.print(" : ");
                }
                textPrinter.print(stringArray[n2]);
                n4 = n5 + stringArray[n2].length() + i * 3;
                bl = true;
            }
            ++n2;
            if (!bl) continue;
            textPrinter.println();
        }
    }

    private int writePadded(TextPrinter textPrinter, String string, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(n);
        if (string != null) {
            stringBuilder.append(string);
        }
        if (n > 0 && stringBuilder.length() < n) {
            int n2 = n - stringBuilder.length();
            StringBuilder stringBuilder2 = new StringBuilder(n2);
            for (int i = 0; i < n2; ++i) {
                stringBuilder2.append(' ');
            }
            if (bl) {
                stringBuilder.insert(0, stringBuilder2);
            } else {
                stringBuilder.append((CharSequence)stringBuilder2);
            }
        }
        textPrinter.print(stringBuilder.toString());
        return stringBuilder.length();
    }
}

