/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.util.List;
import workbench.console.ConsoleSettings;
import workbench.console.HandlerState;
import workbench.console.WbConsole;
import workbench.console.WbConsoleFactory;
import workbench.gui.sql.AutomaticRefreshMgr;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.BatchRunner;
import workbench.sql.ExecutionStatus;
import workbench.sql.StatementHistory;
import workbench.sql.annotations.RefreshAnnotation;
import workbench.sql.annotations.WbAnnotation;
import workbench.util.DurationFormat;
import workbench.util.DurationFormatter;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ConsoleRefresh {
    private boolean doRefresh;
    private WbThread refreshThread;
    private WbThread inputThread;

    public HandlerState handleRefresh(BatchRunner batchRunner, String string, StatementHistory statementHistory) {
        if (string == null) {
            return HandlerState.notHandled;
        }
        if (this.refreshThread != null) {
            return HandlerState.notHandled;
        }
        String string2 = SqlUtil.getSqlVerb(string);
        String string3 = null;
        boolean bl = false;
        if ("WbRefresh".equalsIgnoreCase(string2)) {
            if (statementHistory.isEmpty()) {
                return HandlerState.notHandled;
            }
            string3 = SqlUtil.stripVerb(SqlUtil.makeCleanSql(string, false, false));
            if (StringUtil.isBlank(string3)) {
                string3 = ConsoleSettings.getDefaultRefreshInterval();
            }
            string = (String)statementHistory.get(statementHistory.size() - 1);
            bl = true;
        } else {
            List<WbAnnotation> list = WbAnnotation.readAllAnnotations(string, new RefreshAnnotation());
            if (list.size() != 1) {
                return HandlerState.notHandled;
            }
            string3 = list.get(0).getValue();
        }
        int n = AutomaticRefreshMgr.parseInterval(string3);
        if (n <= 5) {
            return bl ? HandlerState.handled : HandlerState.notHandled;
        }
        this.startRefresh(batchRunner, string, n);
        return HandlerState.handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRefresh(final BatchRunner batchRunner, final String string, final int n) {
        this.doRefresh = true;
        this.inputThread = new WbThread("Console Refresh Input"){

            @Override
            public void run() {
                WbConsole wbConsole = WbConsoleFactory.getConsole();
                while (ConsoleRefresh.this.doRefresh) {
                    char c = wbConsole.readCharacter();
                    if (Character.toLowerCase(c) != 'q' && Character.toLowerCase(c) != 'x') continue;
                    WbConsoleFactory.getConsole().reset();
                    ConsoleRefresh.this.doRefresh = false;
                    break;
                }
                ConsoleRefresh.this.inputThread = null;
            }
        };
        this.inputThread.start();
        this.refreshThread = new WbThread("Console Refresh"){

            @Override
            public void run() {
                ConsoleRefresh.this.doRefresh(batchRunner, string, n);
            }
        };
        try {
            this.refreshThread.start();
            this.refreshThread.join();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.inputThread != null) {
                this.inputThread.interrupt();
                this.inputThread = null;
            }
            this.refreshThread = null;
            this.doRefresh = false;
        }
    }

    private void doRefresh(BatchRunner batchRunner, String string, int n) {
        DurationFormatter durationFormatter = new DurationFormatter();
        String string2 = durationFormatter.formatDuration(n, DurationFormat.dynamic, false, false).trim();
        boolean bl = ConsoleSettings.getClearScreenForRefresh();
        String string3 = ResourceMgr.getString("MsgRefreshQuit");
        while (this.doRefresh) {
            try {
                ExecutionStatus executionStatus;
                if (bl) {
                    WbConsoleFactory.getConsole().clearScreen();
                }
                if ((executionStatus = batchRunner.runScript(string)) == ExecutionStatus.Error) break;
                String string4 = "*** " + ResourceMgr.getFormattedString("MsgRefreshing", string2, StringUtil.getCurrentTimestamp()) + " - " + string3;
                System.out.println(string4);
                this.inputThread.join(n);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error refreshing last statement", exception);
                break;
            }
        }
        this.refreshThread = null;
        this.doRefresh = false;
    }
}

