/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import workbench.console.RowDisplay;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;

public class ConsoleSettings
implements PropertyChangeListener {
    public static final String PROP_MAX_DISPLAY_SIZE = "workbench.console.dataprinter.max.colwidth";
    public static final String PROP_CLEAR_SCREEN = "workbench.console.refresh.clear.screen";
    public static final String PROP_NULL_STRING = "workbench.console.nullstring";
    public static final String EVT_PROPERTY_ROW_DISPLAY = "display";
    private RowDisplay rowDisplay = RowDisplay.SingleLine;
    private RowDisplay nextRowDisplay;
    private List<PropertyChangeListener> listener = new ArrayList<PropertyChangeListener>();

    private ConsoleSettings() {
        Settings.getInstance().addPropertyChangeListener(this, PROP_NULL_STRING, new String[0]);
    }

    public static ConsoleSettings getInstance() {
        return LazyInstanceHolder.instance;
    }

    public RowDisplay getRowDisplay() {
        return this.rowDisplay;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.listener.isEmpty()) {
            return;
        }
        for (PropertyChangeListener propertyChangeListener : this.listener) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public void addChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener.add(propertyChangeListener);
    }

    public void removeChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener.remove(propertyChangeListener);
    }

    protected void firePropertyChange(RowDisplay rowDisplay, RowDisplay rowDisplay2) {
        if (this.listener.isEmpty()) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, EVT_PROPERTY_ROW_DISPLAY, (Object)rowDisplay, (Object)rowDisplay2);
        for (PropertyChangeListener propertyChangeListener : this.listener) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public synchronized void setRowDisplay(RowDisplay rowDisplay) {
        RowDisplay rowDisplay2 = this.rowDisplay;
        if (rowDisplay != null) {
            this.rowDisplay = rowDisplay;
        }
        this.firePropertyChange(rowDisplay2, this.rowDisplay);
    }

    public synchronized void setNextRowDisplay(RowDisplay rowDisplay) {
        this.nextRowDisplay = rowDisplay;
    }

    public synchronized RowDisplay getNextRowDisplay() {
        if (this.nextRowDisplay != null) {
            RowDisplay rowDisplay = this.nextRowDisplay;
            this.nextRowDisplay = null;
            return rowDisplay;
        }
        return this.rowDisplay;
    }

    public static String getNullString() {
        String string = Settings.getInstance().getProperty(PROP_NULL_STRING, GuiSettings.getDisplayNullString());
        if (string == null) {
            return "";
        }
        return string;
    }

    public static boolean showProfileInPrompt() {
        return Settings.getInstance().getBoolProperty("workbench.console.prompt.useprofilename", false);
    }

    public static boolean showScriptFinishTime() {
        return Settings.getInstance().getBoolProperty("workbench.console.script.showtime", false);
    }

    public static boolean changeTerminalTitle() {
        return Settings.getInstance().getBoolProperty("workbench.console.terminal.title.change", true);
    }

    public static boolean termTitleAppNameAtEnd() {
        return Settings.getInstance().getBoolProperty("workbench.console.terminal.title.appname.end", true);
    }

    public static boolean termTitleIncludeUrl() {
        return Settings.getInstance().getBoolProperty("workbench.console.terminal.title.show.url", false);
    }

    public static boolean useHistoryPerProfile() {
        return Settings.getInstance().getBoolProperty("workbench.console.history.per_profile", true);
    }

    public static String getDefaultRefreshInterval() {
        return Settings.getInstance().getProperty("workbench.console.refresh.interval.default", "5s");
    }

    public static boolean getClearScreenForRefresh() {
        return Settings.getInstance().getBoolProperty(PROP_CLEAR_SCREEN, false);
    }

    public static int getMaxColumnDataWidth() {
        return Settings.getInstance().getIntProperty(PROP_MAX_DISPLAY_SIZE, 150);
    }

    public static boolean useDisplayNameForColumns() {
        return Settings.getInstance().getBoolProperty("workbench.console.data.print.column.display.name", true);
    }

    private static class LazyInstanceHolder {
        protected static ConsoleSettings instance = new ConsoleSettings();

        private LazyInstanceHolder() {
        }
    }
}

