/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import workbench.console.ConsolePrinter;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.console.TextPrinter;
import workbench.interfaces.ResultSetConsumer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.StatementRunnerResult;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.reader.ResultSetHolder;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.RowDataReaderFactory;

public class ResultSetPrinter
extends ConsolePrinter
implements ResultSetConsumer,
PropertyChangeListener {
    private static final int MAX_WIDTH = 80;
    private TextPrinter pw;
    private ResultInfo info;

    public ResultSetPrinter(TextPrinter textPrinter) {
        this.pw = textPrinter;
    }

    public ResultSetPrinter(PrintStream printStream) throws SQLException {
        this.pw = TextPrinter.createPrinter(new PrintWriter(printStream));
    }

    @Override
    public boolean ignoreMaxRows() {
        return false;
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void done() {
    }

    @Override
    protected String getResultName() {
        return null;
    }

    @Override
    protected int getColumnType(int n) {
        return this.info == null ? 1111 : this.info.getColumnType(n);
    }

    @Override
    protected int getColumnCount() {
        return this.info == null ? 0 : this.info.getColumnCount();
    }

    @Override
    protected String getColumnName(int n) {
        if (this.info == null) {
            return "";
        }
        if (ConsoleSettings.useDisplayNameForColumns()) {
            return this.info.getColumnDisplayName(n);
        }
        return this.info.getColumnName(n);
    }

    @Override
    protected Map<Integer, Integer> getColumnSizes() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.info.getColumnCount(); ++i) {
            int n = this.getColumnName(i).length();
            int n2 = this.info.getColumn(i).getDisplaySize();
            int n3 = Math.max(n, n2);
            n3 = Math.min(n3, 80);
            hashMap.put(i, n3);
        }
        return hashMap;
    }

    @Override
    public void consumeResult(StatementRunnerResult statementRunnerResult) {
        for (ResultSet resultSet : statementRunnerResult.getResultSets()) {
            this.printResultSet(resultSet, statementRunnerResult.getShowRowCount());
        }
    }

    public void printResultSet(ResultSet resultSet) {
        this.printResultSet(resultSet, this.showRowCount);
    }

    public void printResultSet(ResultSet resultSet, boolean bl) {
        try {
            this.info = new ResultInfo(resultSet.getMetaData(), null);
            this.printHeader(this.pw);
            RowDataReader rowDataReader = RowDataReaderFactory.createReader(this.info, null);
            int n = 0;
            ResultSetHolder resultSetHolder = new ResultSetHolder(resultSet);
            while (resultSet.next()) {
                RowData rowData = rowDataReader.read(resultSetHolder, false);
                this.printRow(this.pw, rowData, n);
                rowDataReader.closeStreams();
                ++n;
            }
            if (bl) {
                this.pw.println();
                this.pw.println(ResourceMgr.getFormattedString("MsgRows", n));
            }
            this.pw.flush();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when printing ResultSet", exception);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() != ConsoleSettings.getInstance()) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("display")) {
            RowDisplay rowDisplay = ConsoleSettings.getInstance().getNextRowDisplay();
            this.setPrintRowsAsLine(rowDisplay == RowDisplay.SingleLine);
        } else if (propertyChangeEvent.getPropertyName().equals("workbench.console.nullstring")) {
            this.nullString = ConsoleSettings.getNullString();
        }
    }
}

