/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.ColumnIdentifier;
import workbench.db.ConstraintReader;
import workbench.db.JdbcUtils;
import workbench.db.TableConstraint;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.ConstraintNameTester;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public abstract class AbstractConstraintReader
implements ConstraintReader {
    private ConstraintNameTester nameTester;

    public AbstractConstraintReader(String string) {
        this.nameTester = new ConstraintNameTester(string);
    }

    public abstract String getColumnConstraintSql();

    public abstract String getTableConstraintSql();

    public int getIndexForSchemaParameter() {
        return -1;
    }

    public int getIndexForCatalogParameter() {
        return -1;
    }

    public int getIndexForTableNameParameter() {
        return 1;
    }

    public boolean isSystemConstraintName(String string) {
        if (this.nameTester == null) {
            return false;
        }
        return this.nameTester.isSystemConstraintName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieveColumnConstraints(WbConnection wbConnection, TableDefinition tableDefinition) {
        String string = this.getColumnConstraintSql();
        if (string == null) {
            return;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "column constraints", string, new Object[0]);
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        Savepoint savepoint = null;
        TableIdentifier tableIdentifier = tableDefinition.getTable();
        try {
            if (wbConnection.getDbSettings().useSavePointForDML()) {
                savepoint = wbConnection.setSavepoint();
            }
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string, 1003, 1007);
            int n = this.getIndexForSchemaParameter();
            if (n > 0) {
                preparedStatement.setString(n, tableIdentifier.getSchema());
            }
            if ((n = this.getIndexForCatalogParameter()) > 0) {
                preparedStatement.setString(n, tableIdentifier.getCatalog());
            }
            if ((n = this.getIndexForTableNameParameter()) > 0) {
                preparedStatement.setString(n, tableIdentifier.getTableName());
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(tableDefinition.getColumns(), string2);
                if (columnIdentifier == null || !StringUtil.isNonEmpty(string3)) continue;
                columnIdentifier.setConstraint(string3.trim());
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "column constraints", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    @Override
    public String getConstraintSource(List<TableConstraint> list, String string) {
        if (CollectionUtil.isEmpty(list)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 10);
        int n = 0;
        for (TableConstraint tableConstraint : list) {
            if (tableConstraint == null || StringUtil.isBlank(tableConstraint.getExpression())) continue;
            if (n > 0) {
                stringBuilder.append(",\n");
                stringBuilder.append(string);
            }
            stringBuilder.append(tableConstraint.getSql());
            ++n;
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableConstraint> getTableConstraints(WbConnection wbConnection, TableDefinition tableDefinition) {
        String string = this.getTableConstraintSql();
        if (string == null) {
            return null;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "table constraints", string, new Object[0]);
        List<TableConstraint> list = CollectionUtil.arrayList();
        PreparedStatement preparedStatement = null;
        Savepoint savepoint = null;
        TableIdentifier tableIdentifier = tableDefinition.getTable();
        ResultSet resultSet = null;
        try {
            boolean bl;
            Object object;
            if (wbConnection.getDbSettings().useSavePointForDML()) {
                savepoint = wbConnection.setSavepoint();
            }
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string, 1003, 1007);
            int n = this.getIndexForSchemaParameter();
            if (n > 0) {
                object = tableIdentifier.getRawSchema();
                if (StringUtil.isBlank((CharSequence)object)) {
                    object = wbConnection.getCurrentSchema();
                }
                preparedStatement.setString(n, (String)object);
            }
            if ((n = this.getIndexForCatalogParameter()) > 0) {
                preparedStatement.setString(n, tableIdentifier.getRawCatalog());
            }
            if ((n = this.getIndexForTableNameParameter()) > 0) {
                preparedStatement.setString(n, tableIdentifier.getRawTableName());
            }
            object = Pattern.compile("^check\\s+.*", 2);
            resultSet = preparedStatement.executeQuery();
            boolean bl2 = bl = resultSet.getMetaData().getColumnCount() > 2;
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = StringUtil.trim(resultSet.getString(2));
                String string4 = null;
                if (bl) {
                    string4 = resultSet.getString(3);
                }
                if (!this.shouldIncludeTableConstraint(string2, string3, tableDefinition)) continue;
                Matcher matcher = ((Pattern)object).matcher(string3);
                if (string3.charAt(0) != '(' && !matcher.matches() && !string3.startsWith("EXCLUDE")) {
                    string3 = "(" + string3 + ")";
                }
                TableConstraint tableConstraint = new TableConstraint(string2, string3);
                tableConstraint.setIsSystemName(this.isSystemConstraintName(string2));
                tableConstraint.setComment(string4);
                list.add(tableConstraint);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table constraints", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return list;
    }

    protected boolean shouldIncludeTableConstraint(String string, String string2, TableDefinition tableDefinition) {
        return StringUtil.isNonEmpty(string2);
    }
}

