/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.sql.Statement;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class CatalogChanger {
    private boolean fireEvents = true;
    private final String quotedPlaceholder = "'%catalog%'";

    public void setFireEvents(boolean bl) {
        this.fireEvents = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean setCurrentCatalog(WbConnection wbConnection, String string) throws SQLException {
        Object object;
        boolean bl;
        boolean bl2;
        String string2;
        DbMetadata dbMetadata;
        block11: {
            if (wbConnection == null) {
                return false;
            }
            if (StringUtil.isEmptyString(string)) {
                return false;
            }
            dbMetadata = wbConnection.getMetadata();
            string2 = dbMetadata.getCurrentCatalog();
            boolean bl3 = wbConnection.getDbSettings().useSetCatalog();
            bl2 = wbConnection.getDbSettings().getBoolProperty("setcatalog.clearwarnings", true);
            dbMetadata.clearCachedCatalog();
            String string3 = wbConnection.getDbSettings().getSwitchCatalogStatement();
            String string4 = wbConnection.getMetadata().removeQuotes(string.trim());
            bl = true;
            if (bl3 || StringUtil.isBlank(string3)) {
                wbConnection.getSqlConnection().setCatalog(string4);
            } else {
                block10: {
                    object = null;
                    string3 = string3.contains("'%catalog%'") ? string3.replace("%catalog%", string4) : string3.replace("%catalog%", dbMetadata.quoteObjectname(string4));
                    LogMgr.logDebug(new CallerInfo(){}, "Changing catalog using: " + string3);
                    object = wbConnection.createStatement();
                    object.execute(string3);
                    if (!bl2) break block10;
                    JdbcUtils.clearWarnings((Statement)object);
                }
                JdbcUtils.closeStatement((Statement)object);
            }
            break block11;
            catch (Exception exception) {
                try {
                    LogMgr.logWarning(new CallerInfo(){}, "Could not change catalog using: " + string3, exception);
                    bl = false;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeStatement(object);
                    throw throwable;
                }
                JdbcUtils.closeStatement((Statement)object);
            }
        }
        if (bl2) {
            JdbcUtils.clearWarnings(wbConnection);
        }
        object = dbMetadata.getCurrentCatalog();
        if (bl && this.fireEvents && StringUtil.stringsAreNotEqual(string2, (String)object)) {
            wbConnection.catalogChanged(string2, string);
        }
        LogMgr.logDebug(new CallerInfo(){}, "Catalog changed to " + (String)object);
        return bl;
    }
}

