/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import workbench.db.ComparableDbObject;
import workbench.db.DbObject;
import workbench.db.QuoteHandler;
import workbench.db.WbConnection;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ColumnIdentifier
implements ComparableDbObject,
Comparable<ColumnIdentifier>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NO_TYPE_INFO = Integer.MIN_VALUE;
    private String name;
    private String alias;
    private int type = 1111;
    private boolean isPk;
    private boolean isExpression;
    private Boolean isGenerated;
    private boolean isNullable = true;
    private boolean isUpdateable = true;
    private boolean readOnly;
    private String dbmsType;
    private String comment;
    private String defaultValue;
    private String columnClassName;
    private Class columnClass;
    private String columnTypeName;
    private String sourceTable;
    private boolean autoincrement;
    private boolean identity;
    private String collation;
    private String collationExpression;
    private String generatorExpression;
    private String columnConstraint;
    private String argumentMode;
    private String defaultClause;
    private String expression;
    private int pgStorage;
    private boolean inherited;
    private int displaySize = -1;
    private int position;
    private int size;
    private int digits;
    private int hashCode;
    private String sqlOption;

    public ColumnIdentifier() {
    }

    public ColumnIdentifier(String string) {
        this(string, 1111, false);
    }

    public ColumnIdentifier(String string, int n) {
        this(string, n, false);
    }

    public ColumnIdentifier(String string, int n, int n2) {
        this(string, n, false);
        this.setColumnSize(n2);
    }

    public ColumnIdentifier(String string, int n, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Column name may not be null!");
        }
        this.setColumnName(string.trim());
        this.type = n;
        this.isPk = bl;
    }

    public void setPgStorage(int n) {
        this.pgStorage = n;
    }

    public int getPgStorage() {
        return this.pgStorage;
    }

    public void setSQLOption(String string) {
        this.sqlOption = string;
    }

    public String getSQLOption() {
        return this.sqlOption;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean bl) {
        this.inherited = bl;
    }

    public String getConstraint() {
        return this.columnConstraint;
    }

    public void setConstraint(String string) {
        this.columnConstraint = string;
    }

    public Boolean isGenerated() {
        return this.isGenerated;
    }

    public void setIsGenerated(Boolean bl) {
        this.isGenerated = bl;
    }

    public String getDefaultClause() {
        if (this.defaultClause == null) {
            return "DEFAULT";
        }
        return this.defaultClause;
    }

    public void setArgumentMode(String string) {
        this.argumentMode = string;
    }

    public String getArgumentMode() {
        return this.argumentMode;
    }

    public void setDefaultClause(String string) {
        this.defaultClause = StringUtil.trimToNull(string);
    }

    public String getCollationExpression() {
        return this.collationExpression;
    }

    public void setCollationExpression(String string) {
        this.collationExpression = string;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String string) {
        this.collation = string;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setIsAutoincrement(boolean bl) {
        this.autoincrement = bl;
    }

    public void setSourceTableName(String string) {
        this.sourceTable = StringUtil.trimToNull(string);
    }

    public String getSourceTableName() {
        return this.sourceTable;
    }

    public String getColumnAlias() {
        return this.alias;
    }

    public void setColumnAlias(String string) {
        this.alias = StringUtil.trimToNull(string);
    }

    public String getComputedColumnExpression() {
        return this.expression;
    }

    public void setComputedColumnExpression(String string) {
        this.expression = string;
    }

    public String getGeneratorExpression() {
        return this.generatorExpression;
    }

    public void setGeneratorExpression(String string) {
        this.generatorExpression = string;
    }

    public String getDisplayName() {
        if (this.alias == null) {
            return this.name;
        }
        return this.alias;
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        if (wbConnection == null) {
            return SqlUtil.quoteObjectname(this.name);
        }
        return wbConnection.getMetadata().quoteObjectname(this.name);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.getObjectName(wbConnection);
    }

    @Override
    public String getObjectType() {
        return "COLUMN";
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getObjectName() {
        return this.getColumnName();
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) {
        return this.name + " " + this.dbmsType;
    }

    public void setColumnSize(int n) {
        this.size = n;
    }

    public int getColumnSize() {
        return this.size;
    }

    public void setDisplaySize(int n) {
        this.displaySize = n;
    }

    public int getDisplaySize() {
        if (SqlUtil.isIntegerType(this.type)) {
            return 10;
        }
        if (SqlUtil.isDecimalType(this.type, this.size, this.digits)) {
            return 15;
        }
        if (SqlUtil.isCharacterType(this.type)) {
            return this.size;
        }
        if (SqlUtil.isBlobType(this.type)) {
            return 5;
        }
        if (this.displaySize < 0) {
            return this.size;
        }
        return this.displaySize;
    }

    public void setDecimalDigits(int n) {
        this.digits = n < 0 ? -1 : n;
    }

    public int getDecimalDigits() {
        return this.digits;
    }

    public String getDigitsDisplay() {
        if (this.digits < 0) {
            return "";
        }
        return NumberStringCache.getNumberString(this.digits);
    }

    public void setIsPkColumn(boolean bl) {
        this.isPk = bl;
    }

    public boolean isPkColumn() {
        return this.isPk;
    }

    public void setIsNullable(boolean bl) {
        this.isNullable = bl;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setDbmsType(String string) {
        this.dbmsType = string;
    }

    public String getDbmsType() {
        return this.dbmsType;
    }

    public boolean isAutoGenerated() {
        return this.isAutoincrement() || this.isIdentityColumn();
    }

    public void setIsIdentity(boolean bl) {
        this.identity = bl;
    }

    public boolean isIdentityColumn() {
        if (!SqlUtil.isNumberType(this.type)) {
            return false;
        }
        return this.identity;
    }

    public void setExpression(String string) {
        this.name = string;
        this.isExpression = true;
        this.isPk = false;
        this.type = 1111;
    }

    public ColumnIdentifier createCopy() {
        ColumnIdentifier columnIdentifier = new ColumnIdentifier();
        columnIdentifier.name = this.name;
        columnIdentifier.hashCode = this.hashCode;
        columnIdentifier.digits = this.digits;
        columnIdentifier.isExpression = this.isExpression;
        columnIdentifier.isNullable = this.isNullable;
        columnIdentifier.isPk = this.isPk;
        columnIdentifier.size = this.size;
        columnIdentifier.type = this.type;
        columnIdentifier.dbmsType = this.dbmsType;
        columnIdentifier.isUpdateable = this.isUpdateable;
        columnIdentifier.comment = this.comment;
        columnIdentifier.defaultValue = this.defaultValue;
        columnIdentifier.columnClassName = this.columnClassName;
        columnIdentifier.columnClass = this.columnClass;
        columnIdentifier.columnTypeName = this.columnTypeName;
        columnIdentifier.position = this.position;
        columnIdentifier.displaySize = this.displaySize;
        columnIdentifier.expression = this.expression;
        columnIdentifier.alias = this.alias;
        columnIdentifier.defaultClause = this.defaultClause;
        columnIdentifier.readOnly = this.readOnly;
        columnIdentifier.argumentMode = this.argumentMode;
        columnIdentifier.columnConstraint = this.columnConstraint;
        columnIdentifier.collation = this.collation;
        columnIdentifier.collationExpression = this.collationExpression;
        columnIdentifier.generatorExpression = this.generatorExpression;
        columnIdentifier.isGenerated = this.isGenerated;
        columnIdentifier.sqlOption = this.sqlOption;
        return columnIdentifier;
    }

    public String getColumnName(WbConnection wbConnection) {
        QuoteHandler quoteHandler = wbConnection == null ? QuoteHandler.STANDARD_HANDLER : wbConnection.getMetadata();
        return quoteHandler.quoteObjectname(this.name);
    }

    public String getColumnName() {
        return this.name;
    }

    public void setColumnName(String string) {
        this.name = string;
        this.isExpression = false;
        this.isPk = false;
        this.isNullable = true;
        this.hashCode = this.name == null ? -1 : SqlUtil.removeObjectQuotes(this.name).toLowerCase().hashCode();
    }

    public void setDataType(int n) {
        this.type = n;
    }

    public int getDataType() {
        return this.type;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            ColumnIdentifier columnIdentifier = (ColumnIdentifier)object;
            return StringUtil.equalStringIgnoreCase(SqlUtil.removeObjectQuotes(this.name), SqlUtil.removeObjectQuotes(columnIdentifier.name));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
        if (this.defaultValue != null && this.defaultValue.toLowerCase().contains("identity")) {
            this.identity = true;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public String getColumnClassName() {
        return this.columnClassName;
    }

    public void setColumnClassName(String string) {
        if (string != null && string.endsWith("[]")) {
            if (string.startsWith("long")) {
                this.columnClassName = "[J";
            } else if (Character.isLowerCase(string.charAt(0))) {
                this.columnClassName = "[" + string.toUpperCase().charAt(0);
            }
        } else {
            this.columnClassName = string;
        }
        this.columnClass = null;
        if (this.columnClassName == null) {
            return;
        }
        try {
            this.columnClass = Class.forName(this.columnClassName);
        }
        catch (Exception exception) {
            this.columnClass = null;
        }
    }

    public Class getColumnClass() {
        if (this.columnClass != null) {
            return this.columnClass;
        }
        switch (this.type) {
            case -5: 
            case 4: {
                return Long.class;
            }
            case 5: {
                return Integer.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 8: {
                return Double.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 91: {
                return Date.class;
            }
            case 93: {
                return Timestamp.class;
            }
        }
        return Object.class;
    }

    public String getColumnTypeName() {
        if (this.columnTypeName == null) {
            return SqlUtil.getTypeName(this.type);
        }
        return this.columnTypeName;
    }

    public void setColumnTypeName(String string) {
        this.columnTypeName = string;
    }

    public boolean isReadonly() {
        return this.readOnly;
    }

    public void setReadonly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isUpdateable() {
        return this.isUpdateable;
    }

    public void setUpdateable(boolean bl) {
        this.isUpdateable = bl;
    }

    public void adjustQuotes(QuoteHandler quoteHandler, QuoteHandler quoteHandler2) {
        if (quoteHandler.isQuoted(this.name)) {
            String string = quoteHandler.removeQuotes(this.name);
            this.name = quoteHandler2.quoteObjectname(string);
        }
    }

    @Override
    public int compareTo(ColumnIdentifier columnIdentifier) {
        if (columnIdentifier == null) {
            return 1;
        }
        if (this.name == null) {
            return -1;
        }
        return SqlUtil.removeObjectQuotes(this.name).compareToIgnoreCase(SqlUtil.removeObjectQuotes(columnIdentifier.name));
    }

    public static boolean containsColumn(List<ColumnIdentifier> list, ColumnIdentifier columnIdentifier) {
        if (list == null) {
            return false;
        }
        if (columnIdentifier == null) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        for (ColumnIdentifier columnIdentifier2 : list) {
            if (!(columnIdentifier2.getPosition() > 0 && columnIdentifier.getPosition() > 0 ? columnIdentifier2.getPosition() == columnIdentifier.getPosition() && columnIdentifier2.equals(columnIdentifier) : columnIdentifier2.equals(columnIdentifier))) continue;
            return true;
        }
        return false;
    }

    public static int getMaxNameLength(List<ColumnIdentifier> list) {
        int n = 0;
        for (ColumnIdentifier columnIdentifier : list) {
            if (columnIdentifier.getColumnName().length() <= n) continue;
            n = columnIdentifier.getColumnName().length();
        }
        return n;
    }

    @Override
    public boolean isComparableWith(DbObject dbObject) {
        return dbObject instanceof ColumnIdentifier;
    }

    @Override
    public boolean isEqualTo(DbObject dbObject) {
        if (dbObject instanceof ColumnIdentifier) {
            ColumnIdentifier columnIdentifier = (ColumnIdentifier)dbObject;
            if (!StringUtil.equalStringOrEmpty(this.dbmsType, columnIdentifier.dbmsType, true)) {
                return false;
            }
            if (this.isNullable != columnIdentifier.isNullable) {
                return false;
            }
            if (this.isExpression != columnIdentifier.isExpression) {
                return false;
            }
            if (this.isPk != columnIdentifier.isPk) {
                return false;
            }
            return StringUtil.equalStringOrEmpty(this.defaultValue, columnIdentifier.defaultValue);
        }
        return false;
    }

    public static ColumnIdentifier findColumnInList(List<ColumnIdentifier> list, String string) {
        if (list == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        String string2 = SqlUtil.removeObjectQuotes(string);
        for (ColumnIdentifier columnIdentifier : list) {
            String string3 = SqlUtil.removeObjectQuotes(columnIdentifier.getColumnName());
            if (!string3.equalsIgnoreCase(string2)) continue;
            return columnIdentifier;
        }
        return null;
    }

    public static List<ColumnIdentifier> sortPksFirst(List<ColumnIdentifier> list) {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(list.size());
        for (ColumnIdentifier columnIdentifier : list) {
            if (!columnIdentifier.isPkColumn()) continue;
            arrayList.add(columnIdentifier);
        }
        for (ColumnIdentifier columnIdentifier : list) {
            if (columnIdentifier.isPkColumn()) continue;
            arrayList.add(columnIdentifier);
        }
        return arrayList;
    }

    public static void sortByPosition(List<ColumnIdentifier> list) {
        Comparator comparator = (columnIdentifier, columnIdentifier2) -> {
            int n = columnIdentifier.getPosition();
            int n2 = columnIdentifier2.getPosition();
            return n - n2;
        };
        Collections.sort(list, comparator);
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

