/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import workbench.db.DbMetadata;
import workbench.db.WbConnection;
import workbench.db.report.TagWriter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.ssh.SshConfig;
import workbench.util.StringUtil;

public class ConnectionInfoBuilder {
    public String getHtmlDisplay(WbConnection wbConnection) {
        if (wbConnection == null) {
            return "";
        }
        if (wbConnection.isClosed()) {
            return "";
        }
        return this.getDisplay(wbConnection, true, 0);
    }

    public String getPlainTextDisplay(WbConnection wbConnection, int n) {
        if (wbConnection == null) {
            return "";
        }
        if (wbConnection.isClosed()) {
            return "";
        }
        return this.getDisplay(wbConnection, false, n);
    }

    private String getDisplay(WbConnection wbConnection, boolean bl, int n) {
        try {
            String string;
            String string2;
            String string3;
            String string4;
            StringBuilder stringBuilder = new StringBuilder(500);
            if (bl) {
                stringBuilder.append("<html>");
            }
            String string5 = StringUtil.padRight("", n);
            String string6 = bl ? "<div style=\"white-space:nowrap;\">" : string5;
            String string7 = bl ? "</div>\n" : "\n";
            String string8 = bl ? "<b>" : "";
            String string9 = bl ? "</b> " : " ";
            String string10 = bl ? "<br>\n" : "\n";
            boolean bl2 = wbConnection.isBusy();
            DbMetadata dbMetadata = wbConnection.getMetadata();
            if (bl2) {
                string4 = wbConnection.getDisplayUser();
                string3 = "n/a";
                string2 = "n/a";
                string = "n/a";
            } else {
                string4 = wbConnection.getCurrentUser();
                string3 = wbConnection.getIsolationLevelName();
                string2 = wbConnection.getDatabaseProductVersion();
                string = wbConnection.getSqlConnection().getMetaData().getDriverName();
            }
            String string11 = wbConnection.getDatabaseVersion().toString();
            stringBuilder.append(string6 + string8 + ResourceMgr.getString("LblDbProductName") + ":" + string9 + dbMetadata.getProductName() + string7);
            stringBuilder.append(string6 + string8 + ResourceMgr.getString("LblDbProductVersion") + ":" + string9 + string11 + string7);
            stringBuilder.append(string6 + string8 + ResourceMgr.getString("LblDbProductInfo") + ":" + string9 + string2 + string7);
            stringBuilder.append(string6 + string8 + ResourceMgr.getString("LblDriverInfoName") + ":" + string9 + string + string7);
            stringBuilder.append(string6 + string8 + ResourceMgr.getString("LblDriverInfoClass") + ":" + string9 + wbConnection.getProfile().getDriverclass() + string7);
            stringBuilder.append(string6 + string8 + ResourceMgr.getString("LblDriverInfoVersion") + ":" + string9 + wbConnection.getDriverVersion() + string7);
            stringBuilder.append(string6 + string8 + ResourceMgr.getString("LblDbURL") + ":" + string9 + wbConnection.getUrl() + string7);
            SshConfig sshConfig = wbConnection.getProfile().getSshConfig();
            if (sshConfig != null) {
                stringBuilder.append(string6 + string8 + "SSH:" + string9 + sshConfig.getInfoString() + string7);
            }
            stringBuilder.append(string5 + string8 + "Isolation Level:" + string9 + string3 + string10);
            stringBuilder.append(string5 + string8 + ResourceMgr.getString("LblUsername") + ":" + string9 + string4 + string10);
            String string12 = dbMetadata.getSchemaTerm();
            String string13 = StringUtil.capitalize(string12);
            if (!"schema".equalsIgnoreCase(string12)) {
                string13 = string13 + " (" + ResourceMgr.getString("LblSchema") + ")";
            }
            stringBuilder.append(string5 + string8 + string13 + ":" + string9 + this.nvl(bl2 ? "n/a" : wbConnection.getCurrentSchema()) + string10);
            string12 = dbMetadata.getCatalogTerm();
            string13 = StringUtil.capitalize(string12);
            if (!"catalog".equalsIgnoreCase(string12)) {
                string13 = string13 + " (" + ResourceMgr.getString("LblCatalog") + ")";
            }
            stringBuilder.append(string5 + string8 + string13 + ":" + string9 + this.nvl(bl2 ? "n/a" : wbConnection.getCurrentCatalog()) + string10);
            stringBuilder.append(string5 + string8 + "Workbench DBID:" + string9 + dbMetadata.getDbId() + string10);
            stringBuilder.append(string5 + string8 + "Connection ID:" + string9 + wbConnection.getId());
            if (bl) {
                stringBuilder.append("</html>");
            }
            return stringBuilder.toString();
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve display", sQLException);
            return sQLException.getMessage();
        }
    }

    private String nvl(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public StringBuilder getDatabaseInfoAsXml(WbConnection wbConnection, StringBuilder stringBuilder) {
        String string;
        DatabaseMetaData databaseMetaData;
        StringBuilder stringBuilder2 = new StringBuilder(200);
        try {
            databaseMetaData = wbConnection.getSqlConnection().getMetaData();
        }
        catch (Exception exception) {
            return StringUtil.emptyBuilder();
        }
        TagWriter tagWriter = new TagWriter();
        try {
            string = databaseMetaData.getDriverName();
        }
        catch (Throwable throwable) {
            string = "n/a";
        }
        tagWriter.appendTag(stringBuilder2, stringBuilder, "jdbc-driver", this.cleanValue(string));
        try {
            string = databaseMetaData.getDriverVersion();
        }
        catch (Throwable throwable) {
            string = "n/a";
        }
        tagWriter.appendTag(stringBuilder2, stringBuilder, "jdbc-driver-version", this.cleanValue(string));
        tagWriter.appendTag(stringBuilder2, stringBuilder, "jdbc-url", wbConnection.getUrl());
        tagWriter.appendTag(stringBuilder2, stringBuilder, "database-user", wbConnection.getDisplayUser());
        try {
            string = databaseMetaData.getDatabaseProductName();
        }
        catch (Throwable throwable) {
            string = "n/a";
        }
        tagWriter.appendTag(stringBuilder2, stringBuilder, "database-product-name", this.cleanValue(string));
        try {
            string = databaseMetaData.getDatabaseProductVersion();
        }
        catch (Throwable throwable) {
            string = "n/a";
        }
        tagWriter.appendTag(stringBuilder2, stringBuilder, "database-product-version", this.cleanValue(string));
        return stringBuilder2;
    }

    private String cleanValue(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > ' ' && c != '\u007f' || c == '\t' || c == '\n' || c == '\r') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }
}

