/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import workbench.WbManager;
import workbench.db.ConnectionProfile;
import workbench.db.DbDriver;
import workbench.db.NoConnectionException;
import workbench.db.ProfileManager;
import workbench.db.WbConnection;
import workbench.db.objectcache.DbObjectCacheFactory;
import workbench.db.shutdown.DbShutdownFactory;
import workbench.db.shutdown.DbShutdownHook;
import workbench.gui.profiles.ProfileKey;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.VariablePool;
import workbench.ssh.SshConfig;
import workbench.ssh.SshException;
import workbench.ssh.SshManager;
import workbench.util.ClasspathUtil;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.PropertiesCopier;
import workbench.util.VersionNumber;
import workbench.util.WbFile;
import workbench.util.WbPersistence;

public class ConnectionMgr {
    private final Map<String, WbConnection> activeConnections = Collections.synchronizedMap(new HashMap());
    private final ProfileManager profileMgr;
    private List<DbDriver> drivers;
    private boolean templatesImported;
    private List<PropertyChangeListener> driverChangeListener;
    private static final ConnectionMgr INSTANCE = new ConnectionMgr();
    private final Object driverLock = new Object();
    private SshManager sshManager = new SshManager();

    private ConnectionMgr() {
        this.profileMgr = new ProfileManager(Settings.getInstance().getProfileStorage());
        WbPersistence.makeTransient(ConnectionProfile.class, "inputPassword");
        WbPersistence.makeTransient(ConnectionProfile.class, "alternateDelimiterString");
    }

    public static ConnectionMgr getInstance() {
        return INSTANCE;
    }

    public WbConnection getConnection(ProfileKey profileKey, String string) throws ClassNotFoundException, SQLException, Exception {
        ConnectionProfile connectionProfile = this.getProfile(profileKey);
        if (connectionProfile == null) {
            return null;
        }
        return this.getConnection(connectionProfile, string);
    }

    public WbConnection findConnection(String string) {
        return this.activeConnections.get(string);
    }

    public int getOpenCount() {
        return this.activeConnections.size();
    }

    public String getProfilesPath() {
        return this.profileMgr.getProfilesPath();
    }

    public WbFile getProfilesFile() {
        return this.profileMgr.getFile();
    }

    public List<WbFile> getProfileSources() {
        return this.profileMgr.getSourceFiles();
    }

    public void setProfileSource(ConnectionProfile connectionProfile, WbFile wbFile) {
        this.profileMgr.setSourceFile(connectionProfile, wbFile);
    }

    public SshManager getSshManager() {
        return this.sshManager;
    }

    public WbConnection getConnection(ConnectionProfile connectionProfile, String string) throws ClassNotFoundException, SQLException, UnsupportedClassVersionError, NoConnectionException, SshException {
        String string2;
        CallerInfo callerInfo = new CallerInfo(){};
        if (this.activeConnections.containsKey(string)) {
            int n = this.getPrefixCount(string) + 1;
            string2 = string + "/" + Integer.toString(n);
            LogMgr.logWarning(callerInfo, "A new connection for ID " + string + " was requested, but there is already an active one with that ID! Using ID=" + string2 + " instead.");
            string = string2;
        }
        LogMgr.logInfo(callerInfo, "Creating new connection for " + connectionProfile.debugString());
        WbConnection wbConnection = this.connect(connectionProfile, string);
        wbConnection.runPostConnectScript();
        string2 = wbConnection.getDriverVersion();
        String string3 = wbConnection.getJDBCVersion();
        String string4 = wbConnection.getDatabaseProductVersion();
        VersionNumber versionNumber = wbConnection.getDatabaseVersion();
        LogMgr.logInfo(callerInfo, "Connected to: [" + wbConnection.getMetadata().getProductName() + "], Database version info: [" + string4 + "], Database version number: [" + versionNumber.toString() + "], Driver version: [" + string2 + "], JDBC version: [" + string3 + "], ID: [" + string + "]");
        this.activeConnections.put(string, wbConnection);
        return wbConnection;
    }

    private int getPrefixCount(String string) {
        int n = 0;
        for (String string2 : this.activeConnections.keySet()) {
            if (!string2.startsWith(string)) continue;
            ++n;
        }
        return n;
    }

    public Class loadClassFromDriverLib(ConnectionProfile connectionProfile, String string) throws ClassNotFoundException, UnsupportedClassVersionError {
        String string2;
        String string3 = connectionProfile.getDriverclass();
        DbDriver dbDriver = this.findDriverByName(string3, string2 = connectionProfile.getDriverName());
        if (dbDriver == null) {
            return null;
        }
        return dbDriver.loadClassFromDriverLib(string);
    }

    private Properties getConnectionProperties(ConnectionProfile connectionProfile) {
        Properties properties = new Properties(connectionProfile.getConnectionProperties());
        if (connectionProfile.getOracleSysDBA()) {
            properties.put("internal_logon", "sysdba");
        }
        return properties;
    }

    public Connection switchURL(WbConnection wbConnection, String string) throws SQLException, NoConnectionException, SshException {
        try {
            Connection connection = this.doConnect(wbConnection.getProfile(), string, wbConnection.getId());
            this.closeConnection(wbConnection, false);
            return connection;
        }
        catch (ClassNotFoundException | UnsupportedClassVersionError throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not switch to new URL", throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection doConnect(ConnectionProfile connectionProfile, String string, String string2) throws ClassNotFoundException, SQLException, UnsupportedClassVersionError, NoConnectionException, SshException {
        String string3 = connectionProfile.getDriverclass();
        String string4 = connectionProfile.getDriverName();
        if (string3 == null) {
            throw new SQLException("No driver class configured");
        }
        DbDriver dbDriver = this.findDriverByName(string3, string4);
        if (dbDriver == null) {
            throw new SQLException("Driver class not registered");
        }
        this.copyPropsToSystem(connectionProfile);
        this.applyProfileVariables(connectionProfile);
        int n = DriverManager.getLoginTimeout();
        Connection connection = null;
        try {
            int n2 = connectionProfile.getConnectionTimeoutValue();
            if (n2 > 0) {
                DriverManager.setLoginTimeout(n2);
            }
            String string5 = this.initSSH(connectionProfile.getSshConfig(), string, connectionProfile.getKey());
            connection = dbDriver.connect(string5, connectionProfile.getLoginUser(), connectionProfile.getLoginPassword(), string2, this.getConnectionProperties(connectionProfile));
        }
        finally {
            DriverManager.setLoginTimeout(n);
        }
        if (connection == null) {
            throw new NoConnectionException("Could not connect to url: " + string);
        }
        try {
            connection.setAutoCommit(connectionProfile.getAutocommit());
        }
        catch (Throwable throwable) {
            LogMgr.logInfo(new CallerInfo(){}, "Driver (" + dbDriver.getDriverClass() + ") does not support the autocommit property: " + ExceptionUtil.getDisplay(throwable));
        }
        return connection;
    }

    WbConnection connect(ConnectionProfile connectionProfile, String string) throws ClassNotFoundException, SQLException, UnsupportedClassVersionError, NoConnectionException, SshException {
        Connection connection = this.doConnect(connectionProfile, connectionProfile.getActiveUrl(), string);
        WbConnection wbConnection = new WbConnection(string, connection, connectionProfile);
        if (connectionProfile.isReadOnly()) {
            wbConnection.syncReadOnlyState();
        }
        return wbConnection;
    }

    private String initSSH(SshConfig sshConfig, String string, ProfileKey profileKey) throws SshException {
        if (sshConfig == null) {
            return string;
        }
        return this.sshManager.initializeSSHSession(sshConfig, string, profileKey);
    }

    private void copyPropsToSystem(ConnectionProfile connectionProfile) {
        if (connectionProfile != null && connectionProfile.getCopyExtendedPropsToSystem()) {
            PropertiesCopier propertiesCopier = new PropertiesCopier();
            propertiesCopier.copyToSystem(connectionProfile.getConnectionProperties());
        }
    }

    private void removePropsFromSystem(ConnectionProfile connectionProfile) {
        if (connectionProfile != null && connectionProfile.getCopyExtendedPropsToSystem()) {
            for (WbConnection wbConnection : this.activeConnections.values()) {
                if (!wbConnection.getProfile().equals(connectionProfile)) continue;
                return;
            }
            PropertiesCopier propertiesCopier = new PropertiesCopier();
            propertiesCopier.removeFromSystem(connectionProfile.getConnectionProperties());
        }
    }

    public DbDriver findDriverByName(String string, String string2) {
        DbDriver dbDriver = null;
        if (this.drivers == null) {
            this.readDrivers();
        }
        if (string2 == null || string2.length() == 0) {
            return this.findDriver(string);
        }
        for (DbDriver dbDriver2 : this.drivers) {
            if (dbDriver2 == null) continue;
            if (dbDriver2.getDriverClass() == null) {
                LogMgr.logWarning(new CallerInfo(){}, "Got driver without a driver class: " + dbDriver2.getName() + ", classpath=" + dbDriver2.getLibraryList());
                continue;
            }
            if (!dbDriver2.getDriverClass().equals(string)) continue;
            if (string2.equals(dbDriver2.getName())) {
                return dbDriver2;
            }
            if (dbDriver != null) continue;
            dbDriver = dbDriver2;
        }
        if (dbDriver == null && WbManager.getInstance().isBatchMode()) {
            return new DbDriver(string2, string, null);
        }
        LogMgr.logDebug(new CallerInfo(){}, "Did not find driver with name=" + string2 + ", using " + (dbDriver == null ? "(n/a)" : dbDriver.getName()));
        return dbDriver;
    }

    public DbDriver findDriverByClass(String string) {
        if (this.drivers == null) {
            this.readDrivers();
        }
        for (DbDriver dbDriver : this.drivers) {
            if (dbDriver.getDriverClass() == null || !string.equals(dbDriver.getDriverClass())) continue;
            return dbDriver;
        }
        return null;
    }

    public DbDriver findRegisteredDriver(String string) {
        if (this.drivers == null) {
            this.readDrivers();
        }
        for (DbDriver dbDriver : this.drivers) {
            if (dbDriver.getDriverClass() == null) {
                LogMgr.logWarning(new CallerInfo(){}, "Got driver without a driver class: " + dbDriver.getName() + ", classpath=" + dbDriver.getLibraryList());
                continue;
            }
            if (!string.equals(dbDriver.getDriverClass()) || !dbDriver.canReadLibrary()) continue;
            return dbDriver;
        }
        return null;
    }

    public DbDriver findDriver(String string) {
        if (string == null) {
            LogMgr.logDebug(new CallerInfo(){}, "Called with a null classname!", new Exception("Backtrace"));
            return null;
        }
        DbDriver dbDriver = this.findRegisteredDriver(string);
        if (dbDriver == null) {
            LogMgr.logWarning(new CallerInfo(){}, "Did not find a registered driver with classname = [" + string + "]");
            try {
                Class<?> clazz = Class.forName(string);
                Driver driver = (Driver)clazz.newInstance();
                dbDriver = new DbDriver(driver);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error creating instance for driver class [" + string + "] ", exception);
                dbDriver = null;
            }
        }
        return dbDriver;
    }

    public DbDriver registerDriver(String string, String string2) {
        if (this.drivers == null) {
            this.readDrivers();
        }
        DbDriver dbDriver = new DbDriver("$JdbcDriver$-" + Integer.toString(this.drivers.size() + 1), string, string2);
        dbDriver.setTemporary();
        this.drivers.add(0, dbDriver);
        return dbDriver;
    }

    public List<DbDriver> getDrivers() {
        if (this.drivers == null) {
            this.readDrivers();
        }
        return this.drivers;
    }

    public void setDrivers(List<DbDriver> list) {
        this.drivers = new ArrayList<DbDriver>(list);
        if (this.driverChangeListener != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "drivers", null, null);
            for (PropertyChangeListener propertyChangeListener : this.driverChangeListener) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public void addDriverChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.driverChangeListener == null) {
            this.driverChangeListener = new ArrayList<PropertyChangeListener>();
        }
        this.driverChangeListener.add(propertyChangeListener);
    }

    public void removeDriverChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.driverChangeListener == null) {
            return;
        }
        this.driverChangeListener.remove(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getProfileKeys() {
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            this.profileMgr.ensureLoaded();
            return this.profileMgr.getProfileKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionProfile> getProfiles() {
        LogMgr.logTrace(new CallerInfo(){}, "getProfiles() called at " + System.currentTimeMillis() + " from " + Thread.currentThread().getName());
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            this.profileMgr.ensureLoaded();
            return this.profileMgr.getProfiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadProfiles() {
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            this.profileMgr.load();
        }
    }

    public void disconnectAll() {
        this.disconnectAll(false);
    }

    public void disconnectAll(boolean bl) {
        for (WbConnection wbConnection : this.activeConnections.values()) {
            if (bl) {
                DbObjectCacheFactory.getInstance().saveCache(wbConnection);
            }
            this.closeConnection(wbConnection);
        }
        this.activeConnections.clear();
        this.sshManager.disconnectAll();
        DbObjectCacheFactory.getInstance().clear();
    }

    public void abortAll(List<WbConnection> list) {
        LogMgr.logWarning(new CallerInfo(){}, "Aborting all connections");
        for (WbConnection wbConnection : list) {
            this.activeConnections.remove(wbConnection.getId());
        }
        for (WbConnection wbConnection : list) {
            wbConnection.shutdownInBackround();
        }
    }

    public String listActiveConnections() {
        StringBuilder stringBuilder = new StringBuilder(this.activeConnections.size() * 20);
        for (WbConnection wbConnection : this.activeConnections.values()) {
            stringBuilder.append("Active connection: ");
            stringBuilder.append(wbConnection == null ? "(null)" : wbConnection.toString() + ", busy: " + wbConnection.isBusy());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString().trim();
    }

    public void dumpConnections() {
        if (LogMgr.isDebugEnabled()) {
            String string = this.listActiveConnections();
            if (string.length() > 0) {
                LogMgr.logDebug(new CallerInfo(){}, string);
            } else {
                LogMgr.logDebug(new CallerInfo(){}, "No more active connections.");
            }
        }
    }

    public void disconnect(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        this.activeConnections.remove(wbConnection.getId());
        LogMgr.logDebug(new CallerInfo(){}, "Trying to physically close the connection with id=" + wbConnection.getId());
        this.closeConnection(wbConnection);
    }

    private void closeConnection(WbConnection wbConnection) {
        this.closeConnection(wbConnection, true);
    }

    private void closeConnection(WbConnection wbConnection, boolean bl) {
        if (wbConnection == null) {
            return;
        }
        if (wbConnection.isClosed()) {
            return;
        }
        try {
            long l = System.currentTimeMillis();
            if (wbConnection.getProfile() != null) {
                LogMgr.logInfo(new CallerInfo(){}, "Disconnecting: [" + wbConnection.getProfile().getName() + "], ID=" + wbConnection.getId());
            } else {
                LogMgr.logInfo(new CallerInfo(){}, "Disconnecting connection with ID=" + wbConnection.toString());
            }
            wbConnection.runPreDisconnectScript();
            this.removePropsFromSystem(wbConnection.getProfile());
            this.removeProfileVariables(wbConnection.getProfile());
            DbShutdownHook dbShutdownHook = DbShutdownFactory.getShutdownHook(wbConnection);
            if (dbShutdownHook != null) {
                dbShutdownHook.shutdown(wbConnection);
            } else {
                wbConnection.shutdown();
            }
            if (bl) {
                ConnectionProfile connectionProfile = wbConnection.getProfile();
                this.sshManager.decrementUsage(connectionProfile.getSshConfig());
            }
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, "Disconnecting connection with ID=" + wbConnection.toString() + " took " + l2 + "ms");
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, ResourceMgr.getString("ErrOnDisconnect"), exception);
        }
    }

    private void applyProfileVariables(ConnectionProfile connectionProfile) {
        Properties properties;
        if (connectionProfile != null && CollectionUtil.isNonEmpty(properties = connectionProfile.getConnectionVariables())) {
            LogMgr.logInfo(new CallerInfo(){}, "Applying variables defined in the connection profile: " + properties);
            VariablePool.getInstance().readFromProperties(properties, "connection profile " + connectionProfile.getKey());
        }
    }

    private void removeProfileVariables(ConnectionProfile connectionProfile) {
        Properties properties;
        if (connectionProfile != null && CollectionUtil.isNonEmpty(properties = connectionProfile.getConnectionVariables())) {
            LogMgr.logInfo(new CallerInfo(){}, "Removing variables defined in the connection profile.");
            VariablePool.getInstance().removeVariables(properties);
        }
    }

    public boolean isActive(WbConnection wbConnection) {
        String string = wbConnection.getUrl();
        String string2 = wbConnection.getId();
        for (WbConnection wbConnection2 : this.activeConnections.values()) {
            String string3;
            if (wbConnection2 == null || wbConnection2.getId().equals(string2) || (string3 = wbConnection2.getUrl()) == null || !string3.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void saveDrivers() {
        Object object;
        if (Settings.getInstance().getCreateDriverBackup()) {
            object = new WbFile(Settings.getInstance().getDriverConfigFilename());
            FileUtil.createBackup((WbFile)object);
        }
        object = new WbPersistence(Settings.getInstance().getDriverConfigFilename());
        List list = this.drivers.stream().filter(dbDriver -> !dbDriver.isTemporaryDriver()).collect(Collectors.toList());
        try {
            ((WbPersistence)object).writeObject(list);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not save drivers", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDrivers() {
        Object object = this.driverLock;
        synchronized (object) {
            try {
                WbPersistence wbPersistence = new WbPersistence(Settings.getInstance().getDriverConfigFilename());
                Object object2 = wbPersistence.readObject();
                if (object2 == null) {
                    this.drivers = Collections.synchronizedList(new ArrayList());
                } else if (object2 instanceof ArrayList) {
                    this.drivers = Collections.synchronizedList((List)object2);
                    this.fixOracleSampleURL();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogMgr.logDebug(new CallerInfo(){}, "WbDrivers.xml not found. Using defaults.");
                this.drivers = null;
            }
            catch (Exception exception) {
                LogMgr.logDebug(new CallerInfo(){}, "Could not load driver definitions. Creating new one...", exception);
                this.drivers = null;
            }
            if (this.drivers == null) {
                this.drivers = Collections.synchronizedList(new ArrayList());
            }
        }
        if (this.readDriverTemplates()) {
            this.importTemplateDrivers();
        }
    }

    private void fixOracleSampleURL() {
        if (this.drivers == null) {
            return;
        }
        for (DbDriver dbDriver : this.drivers) {
            if (!dbDriver.getDriverClass().equals("oracle.jdbc.OracleDriver") || dbDriver.getSampleUrl() == null || !dbDriver.getSampleUrl().contains("thin://@")) continue;
            String string = dbDriver.getSampleUrl();
            String string2 = string.replace("thin://@", "thin:@//");
            dbDriver.setSampleUrl(string2);
            LogMgr.logInfo(new CallerInfo(){}, "Changed invalid sample URL in driver \"" + dbDriver.getName() + "\" from: " + string + " to: " + string2);
        }
    }

    private boolean readDriverTemplates() {
        return Settings.getInstance().getBoolProperty("workbench.jdbc.read.drivertemplates", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importTemplateDrivers() {
        if (this.templatesImported) {
            return;
        }
        Object object = this.driverLock;
        synchronized (object) {
            if (this.drivers == null) {
                this.readDrivers();
            }
            List<DbDriver> list = this.getDriverTemplates();
            for (DbDriver dbDriver : list) {
                if (this.isDriverNameUsed(dbDriver.getName())) continue;
                this.drivers.add(dbDriver);
            }
        }
        this.templatesImported = true;
    }

    private boolean isDriverNameUsed(String string) {
        for (DbDriver dbDriver : this.drivers) {
            if (!dbDriver.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DbDriver> getDriverTemplates() {
        if (WbManager.getInstance() == null) {
            return new ArrayList<DbDriver>();
        }
        ArrayList<DbDriver> arrayList = null;
        InputStream inputStream = null;
        try {
            inputStream = this.openDriverTemplatesFile();
            WbPersistence wbPersistence = new WbPersistence();
            arrayList = (ArrayList<DbDriver>)wbPersistence.readObject(inputStream);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not read driver templates!", throwable);
            arrayList = new ArrayList<DbDriver>();
        }
        finally {
            FileUtil.closeQuietely(inputStream);
        }
        return arrayList;
    }

    private InputStream openDriverTemplatesFile() throws IOException {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        WbFile wbFile = new WbFile(classpathUtil.getJarPath(), "DriverTemplates.xml");
        if (wbFile.exists()) {
            LogMgr.logInfo(new CallerInfo(){}, "Reading external DriverTemplates from " + wbFile.getFullPath());
            return new FileInputStream(wbFile);
        }
        return this.getClass().getResourceAsStream("DriverTemplates.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionProfile getProfile(ProfileKey profileKey) {
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            this.profileMgr.ensureLoaded();
            return this.profileMgr.getProfile(profileKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProfiles() {
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            if (this.profileMgr.isLoaded()) {
                this.profileMgr.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean profilesAreModified() {
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            this.profileMgr.ensureLoaded();
            return this.profileMgr.profilesAreModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyProfiles(List<ConnectionProfile> list) {
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            this.profileMgr.ensureLoaded();
            this.profileMgr.applyProfiles(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProfile(ConnectionProfile connectionProfile) {
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            this.profileMgr.ensureLoaded();
            this.profileMgr.removeProfile(connectionProfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProfile(ConnectionProfile connectionProfile) {
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            this.profileMgr.ensureLoaded();
            this.profileMgr.addProfile(connectionProfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProfiles() {
        ProfileManager profileManager = this.profileMgr;
        synchronized (profileManager) {
            this.profileMgr.reset();
        }
    }
}

