/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.Map;
import workbench.db.DbSettings;
import workbench.util.ArgumentValue;

public class CreateTableTypeDefinition
implements Comparable<CreateTableTypeDefinition>,
ArgumentValue {
    private String dbmsName;
    private String dbid;
    private String type;

    public CreateTableTypeDefinition(String string) {
        String string2 = string.substring("workbench.db.".length());
        int n = string2.indexOf(46);
        this.dbid = string2.substring(0, n);
        this.type = string2.substring(n + 1).replace("create.table.", "");
        Map<String, String> map = DbSettings.getDBMSNames();
        this.dbmsName = map.get(this.dbid);
        if (this.dbmsName == null) {
            this.dbmsName = CreateTableTypeDefinition.makeWords(this.dbid);
        }
    }

    public String toString() {
        return this.type + " (" + this.dbmsName + ")";
    }

    public String getDbId() {
        return this.dbid;
    }

    public String getDatabase() {
        return this.dbmsName;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public int compareTo(CreateTableTypeDefinition createTableTypeDefinition) {
        String string = this.dbmsName + "_" + this.type;
        String string2 = createTableTypeDefinition.dbmsName + "_" + createTableTypeDefinition.type;
        return string.compareToIgnoreCase(string2);
    }

    private static String makeWords(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
                stringBuilder.append(' ');
            }
            if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) continue;
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDisplay() {
        return this.toString();
    }

    @Override
    public String getValue() {
        return this.getType();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CreateTableTypeDefinition createTableTypeDefinition = (CreateTableTypeDefinition)object;
        if (this.dbid == null ? createTableTypeDefinition.dbid != null : !this.dbid.equals(createTableTypeDefinition.dbid)) {
            return false;
        }
        return !(this.type == null ? createTableTypeDefinition.type != null : !this.type.equals(createTableTypeDefinition.type));
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + (this.dbid != null ? this.dbid.hashCode() : 0);
        n = 59 * n + (this.type != null ? this.type.hashCode() : 0);
        return n;
    }
}

