/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.CommentSqlManager;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DbObjectChanger {
    public static final String PARAM_OLD_OBJECT_NAME = "%object_name%";
    public static final String PARAM_OLD_SIMPLE_NAME = "%old_simple_name%";
    public static final String PARAM_OLD_FQ_OBJECT_NAME = "%fq_object_name%";
    public static final String PARAM_NEW_FQ_OBJECT_NAME = "%new_fq_object_name%";
    public static final String PARAM_NEW_OBJECT_NAME = "%new_object_name%";
    public static final String PARAM_NEW_SIMPLE_NAME = "%new_simple_name%";
    public static final String PARAM_OLD_SCHEMA_NAME = "%schema_name%";
    public static final String PARAM_NEW_SCHEMA_NAME = "%new_schema_name%";
    public static final String PARAM_OLD_CATALOG_NAME = "%catalog_name%";
    public static final String PARAM_NEW_CATALOG_NAME = "%new_catalog_name%";
    private WbConnection dbConnection;
    private DbSettings settings;
    private CommentSqlManager commentMgr;

    public DbObjectChanger(WbConnection wbConnection) {
        if (wbConnection != null) {
            this.settings = wbConnection.getDbSettings();
            this.commentMgr = new CommentSqlManager(this.settings.getDbId());
        }
        this.dbConnection = wbConnection;
    }

    DbObjectChanger(DbSettings dbSettings) {
        this.settings = dbSettings;
        this.commentMgr = new CommentSqlManager(this.settings.getDbId());
        this.dbConnection = null;
    }

    public String getAlterScript(Map<DbObject, DbObject> map) {
        StringBuilder stringBuilder = new StringBuilder(map.size() * 50);
        for (Map.Entry<DbObject, DbObject> entry : map.entrySet()) {
            String string;
            String string2;
            String string3;
            String string4 = this.getCommentSql(entry.getKey(), entry.getValue());
            if (string4 != null) {
                stringBuilder.append(string4);
                stringBuilder.append(";\n");
            }
            if ((string3 = this.getSchemaChange(entry.getKey(), entry.getValue())) != null) {
                stringBuilder.append(string3);
                stringBuilder.append(";\n");
            }
            if ((string2 = this.getCatalogChange(entry.getKey(), entry.getValue())) != null) {
                stringBuilder.append(string2);
                stringBuilder.append(";\n");
            }
            if ((string = this.getRename(entry.getKey(), entry.getValue())) == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(";\n");
        }
        if (this.needsCommit() && stringBuilder.length() > 0) {
            stringBuilder.append("\nCOMMIT;\n");
        }
        return stringBuilder.toString();
    }

    public String getSchemaChange(DbObject dbObject, DbObject dbObject2) {
        if (dbObject2 == null || dbObject == null) {
            return null;
        }
        String string = dbObject.getObjectType();
        String string2 = this.getChangeSchemaSql(string);
        if (string2 == null) {
            return null;
        }
        String string3 = dbObject.getSchema();
        String string4 = dbObject2.getSchema();
        if (string3 == null || string4 == null) {
            return null;
        }
        if (StringUtil.equalStringOrEmpty(string3.trim(), string4.trim(), true)) {
            return null;
        }
        string2 = string2.replace(PARAM_OLD_SCHEMA_NAME, string3.trim());
        string2 = string2.replace(PARAM_NEW_SCHEMA_NAME, string4.trim());
        string2 = TemplateHandler.replaceTablePlaceholder(string2, dbObject, this.dbConnection);
        string2 = string2.replace(PARAM_OLD_OBJECT_NAME, dbObject.getObjectName(this.dbConnection));
        return string2;
    }

    public String getCatalogChange(DbObject dbObject, DbObject dbObject2) {
        if (dbObject2 == null || dbObject == null) {
            return null;
        }
        String string = dbObject.getObjectType();
        String string2 = this.getChangeCatalogSql(string);
        if (string2 == null) {
            return null;
        }
        String string3 = dbObject.getCatalog();
        String string4 = dbObject2.getCatalog();
        if (string3 == null || string4 == null) {
            return null;
        }
        if (StringUtil.equalStringOrEmpty(string3.trim(), string4.trim(), true)) {
            return null;
        }
        string2 = string2.replace(PARAM_OLD_CATALOG_NAME, string3.trim());
        string2 = string2.replace(PARAM_NEW_CATALOG_NAME, string4.trim());
        string2 = TemplateHandler.replaceTablePlaceholder(string2, dbObject, this.dbConnection);
        return string2;
    }

    public String getRename(DbObject dbObject, DbObject dbObject2) {
        String string;
        if (dbObject2 == null || dbObject == null) {
            return null;
        }
        String string2 = dbObject.getObjectType();
        String string3 = this.getRenameObjectSql(string2);
        if (string3 == null) {
            return null;
        }
        String string4 = dbObject.getObjectName(this.dbConnection);
        String string5 = dbObject2.getObjectName(this.dbConnection);
        if (StringUtil.equalStringOrEmpty(string4.trim(), string5.trim(), true)) {
            return null;
        }
        String string6 = SqlUtil.fullyQualifiedName(this.dbConnection, dbObject);
        String string7 = SqlUtil.fullyQualifiedName(this.dbConnection, dbObject2);
        string3 = string3.replace(PARAM_OLD_SIMPLE_NAME, this.getSimpleName(dbObject.getObjectName()));
        String string8 = this.getSimpleName(dbObject.getSchema());
        if (string8 != null) {
            string3 = string3.replace(PARAM_OLD_SCHEMA_NAME, string8);
        }
        if ((string = this.getSimpleName(dbObject.getCatalog())) != null) {
            string3 = string3.replace(PARAM_OLD_CATALOG_NAME, string);
        }
        string3 = string3.replace(PARAM_OLD_OBJECT_NAME, dbObject.getObjectExpression(this.dbConnection));
        string3 = string3.replace(PARAM_OLD_FQ_OBJECT_NAME, string6);
        string8 = this.getSimpleName(dbObject2.getSchema());
        if (string8 != null) {
            string3 = string3.replace(PARAM_NEW_SCHEMA_NAME, string8);
        }
        if ((string = this.getSimpleName(dbObject2.getCatalog())) != null) {
            string3 = string3.replace(PARAM_NEW_CATALOG_NAME, string);
        }
        string3 = string3.replace(PARAM_NEW_SIMPLE_NAME, this.getSimpleName(dbObject2.getObjectName()));
        string3 = string3.replace(PARAM_NEW_OBJECT_NAME, dbObject2.getObjectExpression(this.dbConnection));
        string3 = string3.replace(PARAM_NEW_FQ_OBJECT_NAME, string7);
        string3 = string3.replace("%fq_table_name%", string6);
        return string3;
    }

    private String getSimpleName(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        int n = string.indexOf(40);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getCommentSql(DbObject dbObject, DbObject dbObject2) {
        String string;
        if (this.commentMgr == null || dbObject2 == null || dbObject == null) {
            return null;
        }
        String string2 = dbObject.getObjectType();
        String string3 = dbObject.getComment();
        String string4 = dbObject2.getComment();
        String string5 = dbObject.getSchema();
        if (string5 == null) {
            string5 = "";
        }
        if (StringUtil.equalStringOrEmpty(string3, string4, false)) {
            return null;
        }
        String string6 = CommentSqlManager.getAction(string3, string4);
        String string7 = this.getCommentSql(string2, string6);
        if (string7 == null) {
            return null;
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if ((string = dbObject.getObjectName(this.dbConnection)) == null) {
            string = "";
        }
        string7 = string7.replace(PARAM_OLD_OBJECT_NAME, string);
        String string8 = dbObject.getObjectNameForDrop(this.dbConnection);
        string7 = string7.replace(PARAM_OLD_FQ_OBJECT_NAME, string8);
        string7 = string7.replace("%table_name%", dbObject.getObjectName());
        string7 = string7.replace("%schema%", string5);
        string7 = string7.replace("%comment%", string4.replace("'", "''"));
        return string7;
    }

    public String getRenameObjectSql(String string) {
        if (this.settings == null || string == null) {
            return null;
        }
        return this.settings.getRenameObjectSql(string);
    }

    public String getChangeSchemaSql(String string) {
        if (this.settings == null || string == null) {
            return null;
        }
        return this.settings.getChangeSchemaSql(string);
    }

    public String getChangeCatalogSql(String string) {
        if (this.settings == null || string == null) {
            return null;
        }
        return this.settings.getChangeCatalogSql(string);
    }

    public String getCommentSql(String string, String string2) {
        if (this.commentMgr == null || string == null) {
            return null;
        }
        return this.commentMgr.getCommentSqlTemplate(string, string2);
    }

    public String getDropPKScript(TableIdentifier tableIdentifier) {
        String string = this.getDropPK(tableIdentifier);
        if (StringUtil.isBlank(string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(";\n");
        if (this.needsCommit()) {
            stringBuilder.append("\nCOMMIT;\n");
        }
        return stringBuilder.toString();
    }

    public String getDropPK(TableIdentifier tableIdentifier) {
        String string = tableIdentifier.getObjectType();
        if (StringUtil.isBlank(string)) {
            return null;
        }
        String string2 = this.settings.getDropPrimaryKeySql(string);
        String string3 = tableIdentifier.getPrimaryKeyName();
        if (StringUtil.isBlank(string2)) {
            if (StringUtil.isBlank(string3) && this.dbConnection != null) {
                try {
                    TableDefinition tableDefinition = this.dbConnection.getMetadata().getTableDefinition(tableIdentifier);
                    string3 = tableDefinition.getTable().getPrimaryKeyName();
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Error retrieving table definition", sQLException);
                    return null;
                }
            }
            string2 = this.settings.getDropConstraint(string);
        }
        if (string2 == null) {
            return null;
        }
        string2 = TemplateHandler.replaceTablePlaceholder(string2, tableIdentifier, this.dbConnection, false);
        if (string3 != null) {
            string2 = string2.replace("%constraint_name%", string3);
        }
        return string2;
    }

    public String getAddPKScript(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        String string = this.getAddPK(tableIdentifier, list);
        if (StringUtil.isBlank(string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(";\n");
        if (this.needsCommit()) {
            stringBuilder.append("\nCOMMIT;\n");
        }
        return stringBuilder.toString();
    }

    private boolean needsCommit() {
        return this.dbConnection == null ? false : this.dbConnection.generateCommitForDDL();
    }

    public String getAddPK(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        String string = tableIdentifier.getObjectType();
        if (StringUtil.isBlank(string)) {
            return null;
        }
        String string2 = this.settings.getAddPK(string);
        if (StringUtil.isBlank(string2)) {
            return null;
        }
        String string3 = "PK_" + tableIdentifier.getTableName().toUpperCase();
        if (this.dbConnection != null && this.dbConnection.getMetadata().storesLowerCaseIdentifiers()) {
            string3 = string3.toLowerCase();
        }
        string2 = TemplateHandler.replaceTablePlaceholder(string2, tableIdentifier, this.dbConnection, false);
        string2 = TemplateHandler.removePlaceholder(string2, "%clustered_attribute%", true);
        string2 = TemplateHandler.removePlaceholder(string2, "%pk_index_usage%", true);
        if (string3 != null) {
            string2 = string2.replace("%constraint_name%", string3);
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 5);
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(list.get(i).getColumnName(this.dbConnection));
        }
        string2 = string2.replace("%columnlist%", stringBuilder);
        return string2;
    }

    public String getDropFK(TableIdentifier tableIdentifier, String string) {
        String string2 = tableIdentifier.getObjectType();
        if (StringUtil.isBlank(string2)) {
            return null;
        }
        if (StringUtil.isBlank(string)) {
            return null;
        }
        String string3 = this.settings.getDropConstraint(string2);
        if (string3 == null) {
            return null;
        }
        string3 = TemplateHandler.replaceTablePlaceholder(string3, tableIdentifier, this.dbConnection, false);
        string3 = string3.replace("%constraint_name%", string);
        return string3;
    }

    public String getDropFKScript(Map<TableIdentifier, String> map) {
        if (CollectionUtil.isEmpty(map)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        for (Map.Entry<TableIdentifier, String> entry : map.entrySet()) {
            String string = this.getDropFK(entry.getKey(), entry.getValue());
            if (string == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(";\n");
        }
        if (this.needsCommit()) {
            stringBuilder.append("\nCOMMIT;\n");
        }
        return stringBuilder.toString();
    }
}

