/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import workbench.db.DbMetadata;
import workbench.db.DbSearchPath;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.storage.filter.AndExpression;
import workbench.storage.filter.StringEqualsComparator;
import workbench.util.StringUtil;

public class DbObjectFinder {
    private final DbMetadata meta;

    public DbObjectFinder(DbMetadata dbMetadata) {
        Objects.requireNonNull(dbMetadata, "Can't work without a metadata instance");
        this.meta = dbMetadata;
    }

    public DbObjectFinder(WbConnection wbConnection) {
        this(wbConnection.getMetadata());
    }

    public TableIdentifier findObject(TableIdentifier tableIdentifier) {
        return this.findObject(tableIdentifier, true, false);
    }

    public TableIdentifier findObject(TableIdentifier tableIdentifier, boolean bl, boolean bl2) {
        if (tableIdentifier == null) {
            return null;
        }
        TableIdentifier tableIdentifier2 = null;
        TableIdentifier tableIdentifier3 = tableIdentifier.createCopy();
        if (bl) {
            tableIdentifier3.adjustCase(this.meta.getWbConnection());
        }
        try {
            boolean bl3 = false;
            String string = tableIdentifier3.getSchema();
            if (string == null) {
                bl3 = true;
                string = this.meta.getCurrentSchema();
            } else {
                bl2 = false;
            }
            String string2 = tableIdentifier3.getCatalog();
            if (string2 == null) {
                string2 = this.meta.getCurrentCatalog();
            }
            String string3 = tableIdentifier3.getRawTableName();
            String[] stringArray = tableIdentifier3.getType() == null ? null : new String[]{tableIdentifier3.getType()};
            DataStore dataStore = this.meta.getObjects(string2, string, string3, stringArray);
            String[] stringArray2 = this.meta.getTableListColumns();
            if (dataStore.getRowCount() == 0 && this.meta.isOracle()) {
                dataStore = this.meta.getObjects(null, "PUBLIC", string3, null);
            }
            if (dataStore.getRowCount() == 0 && bl3 && bl2) {
                dataStore = this.meta.getObjects(null, null, string3, null);
            }
            if (dataStore.getRowCount() == 1) {
                tableIdentifier2 = this.meta.buildTableIdentifierFromDs(dataStore, 0);
            } else if (dataStore.getRowCount() > 1) {
                AndExpression andExpression = new AndExpression();
                StringEqualsComparator stringEqualsComparator = new StringEqualsComparator();
                andExpression.addColumnExpression(stringArray2[0], stringEqualsComparator, tableIdentifier3.getRawTableName(), true);
                if (StringUtil.isNonBlank(string)) {
                    andExpression.addColumnExpression(stringArray2[3], stringEqualsComparator, string, true);
                }
                if (StringUtil.isNonBlank(string2)) {
                    andExpression.addColumnExpression(stringArray2[2], stringEqualsComparator, string2, true);
                }
                dataStore.applyFilter(andExpression);
                if (dataStore.getRowCount() == 1) {
                    tableIdentifier2 = this.meta.buildTableIdentifierFromDs(dataStore, 0);
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, this.meta.getConnId() + ": Error checking table existence", exception);
        }
        return tableIdentifier2;
    }

    public boolean tableExists(TableIdentifier tableIdentifier) {
        return this.objectExists(tableIdentifier, this.meta.getTableTypesArray());
    }

    public boolean objectExists(TableIdentifier tableIdentifier, String string) {
        String[] stringArray = null;
        if (string != null) {
            stringArray = new String[]{string};
        }
        return this.objectExists(tableIdentifier, stringArray);
    }

    public boolean objectExists(TableIdentifier tableIdentifier, String[] stringArray) {
        return this.findTable(tableIdentifier, stringArray, false) != null;
    }

    public TableIdentifier findSelectableObject(TableIdentifier tableIdentifier) {
        return this.findTable(tableIdentifier, this.meta.getSelectableTypes(), false);
    }

    public TableIdentifier searchSelectableObjectOnPath(TableIdentifier tableIdentifier) {
        return this.searchObjectOnPath(tableIdentifier, this.meta.getSelectableTypes());
    }

    public TableIdentifier searchTableOnPath(TableIdentifier tableIdentifier) {
        return this.searchObjectOnPath(tableIdentifier, this.meta.getTableTypesArray());
    }

    public TableIdentifier searchObjectOnPath(TableIdentifier tableIdentifier, String[] stringArray) {
        if (tableIdentifier.getSchema() != null) {
            return this.findTable(tableIdentifier, stringArray, false);
        }
        List<String> list = DbSearchPath.Factory.getSearchPathHandler(this.meta.getWbConnection()).getSearchPath(this.meta.getWbConnection(), null);
        if (list.isEmpty()) {
            return this.findTable(tableIdentifier, stringArray, false);
        }
        LogMgr.logDebug(new CallerInfo(){}, this.meta.getConnId() + ": Looking for table " + tableIdentifier.getRawTableName() + " in schemas: " + list);
        for (String string : list) {
            TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
            tableIdentifier2.setSchema(string);
            TableIdentifier tableIdentifier3 = this.findTable(tableIdentifier2, stringArray, false);
            if (tableIdentifier3 == null) continue;
            LogMgr.logDebug(new CallerInfo(){}, this.meta.getConnId() + ": Found table " + tableIdentifier3.getTableExpression());
            return tableIdentifier3;
        }
        return null;
    }

    public TableDefinition findTableDefinition(TableIdentifier tableIdentifier) {
        TableIdentifier tableIdentifier2 = this.findTable(tableIdentifier, this.meta.getTableTypesArray(), false);
        if (tableIdentifier2 == null) {
            return null;
        }
        try {
            return this.meta.getTableDefinition(tableIdentifier2, true);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public TableIdentifier findTable(TableIdentifier tableIdentifier, boolean bl) {
        return this.findTable(tableIdentifier, this.meta.getTableTypesArray(), bl);
    }

    public TableIdentifier findTable(TableIdentifier tableIdentifier) {
        return this.findTable(tableIdentifier, this.meta.getTableTypesArray(), false);
    }

    public TableIdentifier findTable(TableIdentifier tableIdentifier, String[] stringArray) {
        return this.findTable(tableIdentifier, stringArray == null || stringArray.length == 0 ? this.meta.getTableTypesArray() : stringArray, false);
    }

    private TableIdentifier findTable(TableIdentifier tableIdentifier, String[] stringArray, boolean bl) {
        if (tableIdentifier == null) {
            return null;
        }
        TableIdentifier tableIdentifier2 = null;
        TableIdentifier tableIdentifier3 = tableIdentifier.createCopy();
        tableIdentifier3.adjustCase(this.meta.getWbConnection());
        try {
            String string;
            DataStore dataStore;
            String string2;
            String string3 = tableIdentifier3.getSchema();
            if (string3 == null && !bl) {
                string3 = this.meta.getCurrentSchema();
            }
            if ((string2 = tableIdentifier3.getCatalog()) == null) {
                string2 = this.meta.getCurrentCatalog();
            }
            if ((dataStore = this.meta.getObjects(string2, string3, string = tableIdentifier3.getRawTableName(), stringArray)).getRowCount() == 1) {
                tableIdentifier2 = this.meta.buildTableIdentifierFromDs(dataStore, 0);
                return tableIdentifier2;
            }
            dataStore = this.meta.getObjects(tableIdentifier3.getRawCatalog(), tableIdentifier3.getRawSchema(), tableIdentifier3.getRawTableName(), stringArray);
            if (dataStore.getRowCount() == 0) {
                return null;
            }
            if (dataStore.getRowCount() == 1) {
                tableIdentifier2 = this.meta.buildTableIdentifierFromDs(dataStore, 0);
                return tableIdentifier2;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, this.meta.getConnId() + ": Error checking table existence", exception);
        }
        return tableIdentifier2;
    }
}

