/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import workbench.db.JdbcUtils;
import workbench.db.TransactionChecker;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class DefaultTransactionChecker
implements TransactionChecker {
    private final String query;

    public DefaultTransactionChecker(String string) {
        this.query = StringUtil.trimToNull(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean hasUncommittedChanges(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (wbConnection.isClosed()) {
            return false;
        }
        if (wbConnection.getAutoCommit()) {
            return false;
        }
        if (this.query == null) {
            return false;
        }
        Savepoint savepoint = null;
        ResultSet resultSet = null;
        Statement statement = null;
        int n = 0;
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            long l = System.currentTimeMillis();
            if (wbConnection.getDbSettings().useSavePointForTransactionCheck()) {
                savepoint = wbConnection.setSavepoint(callerInfo);
            }
            if ((resultSet = (statement = wbConnection.createStatementForQuery()).executeQuery(this.query)).next()) {
                n = resultSet.getInt(1);
            }
            wbConnection.releaseSavepoint(savepoint, callerInfo);
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(callerInfo, "Checking for pending transactions took " + l2 + "ms");
        }
        catch (SQLException sQLException) {
            LogMgr.logWarning(callerInfo, "Could not retrieve transaction state", sQLException);
            wbConnection.rollback(savepoint);
            JdbcUtils.closeAll(resultSet, statement);
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(callerInfo, "Error when retrieving transaction state", throwable);
            {
                catch (Throwable throwable2) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable2;
                }
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return n > 0;
    }
}

