/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.CommentSqlManager;
import workbench.db.DbMetadata;
import workbench.db.GetMetaDataSql;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.TriggerLevel;
import workbench.db.TriggerReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DefaultTriggerReader
implements TriggerReader {
    protected WbConnection dbConnection;
    protected DbMetadata dbMeta;

    public DefaultTriggerReader(WbConnection wbConnection) {
        this.dbMeta = wbConnection.getMetadata();
        this.dbConnection = wbConnection;
    }

    @Override
    public DataStore getTriggers(String string, String string2) throws SQLException {
        return this.getTriggers(string, string2, null);
    }

    @Override
    public List<TriggerDefinition> getTriggerList(String string, String string2, String string3) throws SQLException {
        DataStore dataStore = this.getTriggers(string, string2, string3);
        ArrayList<TriggerDefinition> arrayList = new ArrayList<TriggerDefinition>(dataStore.getRowCount());
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            TriggerDefinition triggerDefinition = (TriggerDefinition)dataStore.getRow(i).getUserObject();
            arrayList.add(triggerDefinition);
        }
        return arrayList;
    }

    public TriggerDefinition createTriggerDefinition(DataStore dataStore, int n, String string, String string2) {
        String string3 = dataStore.getValueAsString(n, 0);
        String string4 = dataStore.getValueAsString(n, 1);
        String string5 = dataStore.getValueAsString(n, 2);
        String string6 = dataStore.getValueAsString(n, 3);
        String string7 = dataStore.getValueAsString(n, 4);
        String string8 = dataStore.getValueAsString(n, 5);
        String string9 = dataStore.getValueAsString(n, 6);
        TriggerDefinition triggerDefinition = new TriggerDefinition(string, string2, string3);
        triggerDefinition.setTriggerType(string4);
        triggerDefinition.setTriggerEvent(string5);
        triggerDefinition.setComment(string7);
        triggerDefinition.setStatus(string8);
        triggerDefinition.setLevel(TriggerLevel.parseLevel(string9));
        if (string6 != null) {
            TableIdentifier tableIdentifier = new TableIdentifier(string6);
            triggerDefinition.setRelatedTable(tableIdentifier);
        }
        return triggerDefinition;
    }

    @Override
    public DataStore getTableTriggers(TableIdentifier tableIdentifier) throws SQLException {
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        tableIdentifier2.adjustCase(this.dbConnection);
        return this.getTriggers(tableIdentifier2.getCatalog(), tableIdentifier2.getSchema(), tableIdentifier2.getTableName());
    }

    protected DataStore createResultDataStore() {
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12, 12};
        int[] nArray2 = new int[]{30, 30, 20, 20, 20, 10, 10};
        DataStore dataStore = new DataStore(LIST_COLUMNS, nArray, nArray2);
        return dataStore;
    }

    protected String getListTriggerSQL(String string, String string2, String string3) {
        GetMetaDataSql getMetaDataSql = this.dbMeta.getMetaDataSQLMgr().getListTriggerSql();
        if (getMetaDataSql == null) {
            LogMgr.logInfo(new CallerInfo(){}, "No SQL query configured to list triggers.");
            return null;
        }
        if ("*".equals(string2)) {
            string2 = null;
        }
        if ("*".equals(string)) {
            string = null;
        }
        getMetaDataSql.setSchema(string2);
        getMetaDataSql.setCatalog(string);
        getMetaDataSql.setObjectName(string3);
        return getMetaDataSql.getSql();
    }

    protected DataStore getTriggers(String string, String string2, String string3) throws SQLException {
        DataStore dataStore = this.createResultDataStore();
        String string4 = this.getListTriggerSQL(string, string2, string3);
        Statement statement = this.dbConnection.createStatementForQuery();
        LogMgr.logMetadataSql(new CallerInfo(){}, "table triggers", string4, new Object[0]);
        boolean bl = this.dbMeta.getDbSettings().trimObjectNames("trigger");
        boolean bl2 = this.dbConnection.getDbSettings().useSavePointForDML();
        Savepoint savepoint = null;
        ResultSet resultSet = null;
        try {
            boolean bl3;
            int n;
            if (bl2) {
                savepoint = this.dbConnection.setSavepoint();
            }
            boolean bl4 = (n = (resultSet = statement.executeQuery(string4)).getMetaData().getColumnCount()) >= 4;
            boolean bl5 = n >= 5;
            boolean bl6 = n >= 6;
            boolean bl7 = bl3 = n >= 7;
            while (resultSet.next()) {
                int n2 = dataStore.addRow();
                String string5 = resultSet.getString(1);
                if (bl) {
                    string5 = StringUtil.trim(string5);
                }
                dataStore.setValue(n2, 0, (Object)string5);
                string5 = resultSet.getString(2);
                if (bl) {
                    string5 = StringUtil.trim(string5);
                }
                dataStore.setValue(n2, 1, (Object)string5);
                string5 = resultSet.getString(3);
                if (bl) {
                    string5 = StringUtil.trim(string5);
                }
                dataStore.setValue(n2, 2, (Object)string5);
                if (bl4) {
                    string5 = resultSet.getString(4);
                    if (bl) {
                        string5 = StringUtil.trim(string5);
                    }
                    dataStore.setValue(n2, 3, (Object)string5);
                }
                if (bl5) {
                    string5 = resultSet.getString(5);
                    dataStore.setValue(n2, 4, (Object)StringUtil.trim(string5));
                }
                if (bl6) {
                    string5 = resultSet.getString(6);
                    dataStore.setValue(n2, 5, (Object)StringUtil.trim(string5));
                }
                if (bl3) {
                    string5 = resultSet.getString(7);
                    dataStore.setValue(n2, 6, (Object)StringUtil.trim(string5));
                }
                TriggerDefinition triggerDefinition = this.createTriggerDefinition(dataStore, n2, string, string2);
                dataStore.getRow(n2).setUserObject(triggerDefinition);
            }
            dataStore.resetStatus();
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table triggers", string4, new Object[0]);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public TriggerDefinition findTrigger(String string, String string2, String string3) throws SQLException {
        List<TriggerDefinition> list = this.getTriggerList(string, string2, null);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        for (TriggerDefinition triggerDefinition : list) {
            if (!triggerDefinition.getObjectName().equalsIgnoreCase(string3)) continue;
            return triggerDefinition;
        }
        return null;
    }

    @Override
    public String getTriggerSource(TriggerDefinition triggerDefinition, boolean bl) throws SQLException {
        return this.getTriggerSource(triggerDefinition.getCatalog(), triggerDefinition.getSchema(), triggerDefinition.getObjectName(), triggerDefinition.getRelatedTable(), triggerDefinition.getComment(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTriggerSource(String string, String string2, String string3, TableIdentifier tableIdentifier, String string4, boolean bl) throws SQLException {
        GetMetaDataSql getMetaDataSql;
        StringBuilder stringBuilder = new StringBuilder(500);
        if ("*".equals(string)) {
            string = null;
        }
        if ("*".equals(string2)) {
            string2 = null;
        }
        if ((getMetaDataSql = this.dbMeta.getMetaDataSQLMgr().getTriggerSourceSql()) == null) {
            return "";
        }
        getMetaDataSql.setSchema(string2);
        getMetaDataSql.setCatalog(string);
        getMetaDataSql.setObjectName(string3);
        if (tableIdentifier != null) {
            getMetaDataSql.setBaseObjectName(tableIdentifier.getTableName());
        }
        Statement statement = this.dbConnection.createStatementForQuery();
        String string5 = null;
        ResultSet resultSet = null;
        String string6 = Settings.getInstance().getInternalEditorLineEnding();
        boolean bl2 = this.dbConnection.getDbSettings().useSavePointForDML();
        Savepoint savepoint = null;
        try {
            CharSequence charSequence;
            String string7;
            if (bl2) {
                savepoint = this.dbConnection.setSavepoint();
            }
            if (getMetaDataSql.isPreparedStatement()) {
                string5 = getMetaDataSql.getBaseSql();
                LogMgr.logMetadataSql(new CallerInfo(){}, "trigger source", string5, new Object[0]);
                PreparedStatement preparedStatement = getMetaDataSql.prepareStatement(this.dbConnection, string, string2, string3);
                statement = preparedStatement;
                resultSet = preparedStatement.executeQuery();
            } else {
                string5 = getMetaDataSql.getSql();
                LogMgr.logMetadataSql(new CallerInfo(){}, "trigger source", string5, new Object[0]);
                statement.execute(string5);
                resultSet = statement.getResultSet();
            }
            boolean bl3 = Settings.getInstance().getBoolProperty("workbench.db." + this.dbMeta.getDbId() + ".replacenl.triggersource", false);
            boolean bl4 = Settings.getInstance().getBoolProperty("workbench.db." + this.dbMeta.getDbId() + ".triggersource.addnl", false);
            if (resultSet != null) {
                int n = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    for (int i = 1; i <= n; ++i) {
                        string7 = resultSet.getString(i);
                        if (string7 == null) continue;
                        if (bl3) {
                            string7 = StringUtil.replace(string7, "\\n", string6);
                        }
                        stringBuilder.append(string7);
                    }
                    if (!bl4) continue;
                    stringBuilder.append(string6);
                }
            }
            if ((charSequence = SqlUtil.getWarnings(this.dbConnection, statement)) != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string6);
                    stringBuilder.append(string6);
                }
                stringBuilder.append(charSequence);
            }
            if (bl) {
                CharSequence charSequence2;
                if (this.dbConnection.getDbSettings().createTriggerNeedsAlternateDelimiter()) {
                    DelimiterDefinition delimiterDefinition = this.dbConnection.getAlternateDelimiter();
                    if (stringBuilder.length() > 0 && delimiterDefinition != null && !delimiterDefinition.isStandard()) {
                        stringBuilder.append(string6);
                        stringBuilder.append(delimiterDefinition.getDelimiter());
                    }
                }
                CommentSqlManager commentSqlManager = new CommentSqlManager(this.dbConnection.getMetadata().getDbId());
                string7 = commentSqlManager.getCommentSqlTemplate("trigger", "set");
                if (stringBuilder.length() > 0 && StringUtil.isNonBlank(string7) && StringUtil.isNonBlank(string4)) {
                    stringBuilder.append(string6);
                    charSequence2 = string7.replace("%trigger_name%", string3);
                    charSequence2 = ((String)charSequence2).replace("%trigger_schema%", string2);
                    if (tableIdentifier != null) {
                        charSequence2 = ((String)charSequence2).replace("%trigger_table%", tableIdentifier.getTableExpression(this.dbConnection));
                    }
                    charSequence2 = ((String)charSequence2).replace("%comment%", SqlUtil.escapeQuotes(string4));
                    stringBuilder.append(string6);
                    stringBuilder.append((String)charSequence2);
                    stringBuilder.append(';');
                    stringBuilder.append(string6);
                }
                if ((charSequence2 = this.getDependentSource(string, string2, string3, tableIdentifier)) != null) {
                    stringBuilder.append(string6);
                    stringBuilder.append(charSequence2);
                }
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            String string8;
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "trigger source", string5, new Object[0]);
                if (this.dbMeta.isPostgres()) {
                    try {
                        this.dbConnection.rollback();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                stringBuilder.append(ExceptionUtil.getDisplay(sQLException));
                JdbcUtils.closeAll(resultSet, statement);
                string8 = stringBuilder.toString();
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
            return string8;
        }
        JdbcUtils.closeAll(resultSet, statement);
        return stringBuilder.toString();
    }

    @Override
    public CharSequence getDependentSource(String string, String string2, String string3, TableIdentifier tableIdentifier) throws SQLException {
        return null;
    }

    @Override
    public boolean supportsTriggersOnViews() {
        if (this.dbConnection == null) {
            return false;
        }
        return this.dbConnection.getDbSettings().supportsTriggersOnViews();
    }
}

