/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.WbManager;
import workbench.db.ColumnIdentifier;
import workbench.db.CommitType;
import workbench.db.DbMetadata;
import workbench.db.DbObjectFinder;
import workbench.db.DependencyNode;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.TableDependencySorter;
import workbench.gui.components.WbTable;
import workbench.gui.dbobjects.ExplorerUtils;
import workbench.gui.dbobjects.ObjectScripterUI;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.interfaces.Scripter;
import workbench.interfaces.TextOutput;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.formatter.FormatterUtil;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.storage.ColumnData;
import workbench.storage.DataStore;
import workbench.storage.SqlLiteralFormatter;
import workbench.util.AggregatingMap;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;

public class DeleteScriptGenerator
implements Scripter {
    private final WbConnection connection;
    private List<ColumnData> columnValues;
    private TableDependency dependency;
    private TableDependencySorter sorter;
    private final DbMetadata meta;
    private TableIdentifier rootTable;
    private WbTable sourceTable;
    private ScriptGenerationMonitor monitor;
    private final List<String> statements = new ArrayList<String>();
    private final SqlLiteralFormatter formatter;
    private boolean formatSql = true;
    private boolean showFkNames;
    private List<TableIdentifier> excludeTables = new ArrayList<TableIdentifier>();
    private TextOutput output;
    private boolean endTransaction;
    private final Comparator<Integer> descComparator = (n, n2) -> {
        int n3;
        int n4 = n;
        return n4 < (n3 = n2.intValue()) ? 1 : (n4 == n3 ? 0 : -1);
    };

    public DeleteScriptGenerator(WbConnection wbConnection) throws SQLException {
        this.connection = wbConnection;
        this.meta = this.connection.getMetadata();
        this.formatter = new SqlLiteralFormatter(this.connection);
    }

    @Override
    public void setEndTransaction(boolean bl) {
        this.endTransaction = bl;
    }

    @Override
    public void setTextOutput(TextOutput textOutput) {
        this.output = textOutput;
    }

    @Override
    public WbConnection getCurrentConnection() {
        return this.connection;
    }

    public void setExcludedTables(List<TableIdentifier> list) {
        if (CollectionUtil.isEmpty(list)) {
            this.excludeTables.clear();
        } else {
            this.excludeTables = new ArrayList<TableIdentifier>(list);
        }
    }

    public void setShowConstraintNames(boolean bl) {
        this.showFkNames = bl;
    }

    public void setFormatSql(boolean bl) {
        this.formatSql = bl;
    }

    public void setSource(WbTable wbTable) {
        this.sourceTable = wbTable;
    }

    public void setTable(TableIdentifier tableIdentifier) throws SQLException {
        if (tableIdentifier == null) {
            throw new IllegalArgumentException("The table name may not be empty");
        }
        this.rootTable = new DbObjectFinder(this.meta).findTable(tableIdentifier, false);
        this.dependency = new TableDependency(this.connection, this.rootTable);
    }

    public void setValues(List<ColumnData> list) {
        this.columnValues = list == null ? null : new ArrayList<ColumnData>(list);
    }

    @Override
    public boolean isCancelled() {
        if (this.dependency == null) {
            return false;
        }
        if (this.dependency.isCancelled()) {
            return true;
        }
        if (this.sorter == null) {
            return false;
        }
        return this.sorter.isCancelled();
    }

    @Override
    public void cancel() {
        if (this.dependency != null) {
            this.dependency.cancel();
        }
        if (this.sorter != null) {
            this.sorter.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDeleteAll(boolean bl) {
        if (this.isCancelled()) {
            return;
        }
        try {
            this.sorter = new TableDependencySorter(this.connection);
            this.sorter.setProgressMonitor(this.monitor);
            List<TableIdentifier> list = this.sorter.sortForDelete(Collections.singletonList(this.rootTable), true);
            for (int i = 0; i < list.size(); ++i) {
                if (!bl && i == list.size() - 1) {
                    break;
                }
                TableIdentifier tableIdentifier = list.get(i);
                String string = "DELETE FROM " + tableIdentifier.getTableExpression(this.connection);
                this.addStatement(this.formatSql(string));
            }
        }
        finally {
            this.sorter = null;
        }
    }

    private void createStatements(boolean bl) {
        int n;
        if (CollectionUtil.isEmpty(this.columnValues)) {
            this.createDeleteAll(bl);
            return;
        }
        this.dependency.setScriptMonitor(this.monitor);
        long l = System.currentTimeMillis();
        this.dependency.setExcludedTables(this.excludeTables);
        this.dependency.readDependencyTree(true);
        if (this.isCancelled()) {
            return;
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving dependency hierarchy for " + this.dependency.getRootNode().getTable() + " took: " + l2 + "ms");
        Map<Integer, Set<DependencyNode>> map = this.buildLevelsTopDown(this.dependency.getRootNode(), 1);
        if (this.monitor != null) {
            this.monitor.setCurrentObject(ResourceMgr.getFormattedString("MsgCalcDelDeps", new Object[0]), -1, -1);
        }
        long l3 = System.currentTimeMillis();
        int n2 = this.adjustLevels(map);
        for (n = 1; n2 > 0 && n <= map.size(); ++n) {
            n2 = this.adjustLevels(map);
        }
        l2 = System.currentTimeMillis() - l3;
        LogMgr.logDebug(new CallerInfo(){}, "Adjusting level hierarchy in " + n + " iterations took: " + l2 + "ms");
        block1: for (Map.Entry<Integer, Set<DependencyNode>> entry : map.entrySet()) {
            Object object2;
            if (entry.getValue().size() <= 0) continue;
            if (this.isCancelled()) {
                return;
            }
            AggregatingMap<TableIdentifier, DependencyNode> aggregatingMap = new AggregatingMap<TableIdentifier, DependencyNode>(false);
            for (Object object2 : (Set)entry.getValue()) {
                aggregatingMap.addValue(((DependencyNode)object2).getTable(), (DependencyNode)object2);
            }
            List<TableIdentifier> list = this.sortTables(aggregatingMap.getMap());
            object2 = list.iterator();
            while (object2.hasNext()) {
                TableIdentifier tableIdentifier = (TableIdentifier)object2.next();
                if (this.excludeTables.contains(tableIdentifier)) continue;
                if (this.isCancelled()) continue block1;
                this.addStatement(this.createDeleteStatement(tableIdentifier, aggregatingMap.get(tableIdentifier)));
            }
        }
        if (bl) {
            Map.Entry<Integer, Set<DependencyNode>> entry;
            DependencyNode dependencyNode = this.dependency.getRootNode();
            entry = new StringBuilder(100);
            ((StringBuilder)((Object)entry)).append("DELETE FROM ");
            ((StringBuilder)((Object)entry)).append(dependencyNode.getTable().getTableExpression(this.connection));
            ((StringBuilder)((Object)entry)).append("\nWHERE ");
            this.addRootTableWhere((StringBuilder)((Object)entry));
            this.addStatement(this.formatSql((CharSequence)((Object)entry)));
        }
    }

    private void addStatement(String string) {
        if (this.output != null) {
            this.output.append(string.trim() + ";\n\n");
        } else {
            this.statements.add(string);
        }
    }

    private List<TableIdentifier> sortTables(Map<TableIdentifier, Set<DependencyNode>> map) {
        HashSet<DependencyNode> hashSet = new HashSet<DependencyNode>();
        for (Set<DependencyNode> set : map.values()) {
            hashSet.addAll(set);
        }
        List<TableIdentifier> list = TableDependencySorter.sortTables(hashSet, map.keySet(), true);
        return list;
    }

    private String formatSql(CharSequence charSequence) {
        if (!this.formatSql) {
            return charSequence.toString();
        }
        try {
            WbSqlFormatter wbSqlFormatter = new WbSqlFormatter(charSequence, Settings.getInstance().getFormatterMaxSubselectLength(), this.connection.getDbId());
            String string = wbSqlFormatter.getFormattedSql() + "\n";
            return string;
        }
        catch (Exception exception) {
            return charSequence.toString();
        }
    }

    private String createDeleteStatement(TableIdentifier tableIdentifier, Set<DependencyNode> set) {
        if (tableIdentifier == null) {
            return "";
        }
        if (CollectionUtil.isEmpty(set)) {
            return "";
        }
        HashSet<DependencyNode> hashSet = new HashSet<DependencyNode>(set.size());
        StringBuilder stringBuilder = new StringBuilder(set.size() * 200);
        if (this.showFkNames) {
            for (DependencyNode object : set) {
                stringBuilder.append("-- ").append(object.getFkName()).append('\n');
            }
        }
        stringBuilder.append("DELETE FROM ");
        stringBuilder.append(tableIdentifier.getTableExpression(this.connection));
        stringBuilder.append(" \nWHERE");
        boolean bl = true;
        for (DependencyNode dependencyNode : set) {
            if (hashSet.contains(dependencyNode)) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("\n   OR");
            }
            this.addParentWhere(stringBuilder, dependencyNode);
            hashSet.add(dependencyNode);
        }
        return this.formatSql(stringBuilder);
    }

    private void addParentWhere(StringBuilder stringBuilder, DependencyNode dependencyNode) {
        try {
            DependencyNode dependencyNode2 = dependencyNode.getParent();
            Map<String, String> map = dependencyNode.getColumns();
            int n = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                boolean bl = this.rootTable.equals(dependencyNode2.getTable());
                if (n > 0) {
                    stringBuilder.append(" AND ");
                }
                if (!bl) {
                    stringBuilder.append(" (");
                    stringBuilder.append(string);
                    stringBuilder.append(" IN ( SELECT ");
                    stringBuilder.append(string2);
                    stringBuilder.append(" FROM ");
                    stringBuilder.append(dependencyNode2.getTable().getTableExpression(this.connection));
                    stringBuilder.append(" WHERE ");
                    this.addParentWhere(stringBuilder, dependencyNode2);
                    stringBuilder.append("))");
                } else {
                    stringBuilder.append(' ');
                    this.addRootTableWhere(stringBuilder, string2, string);
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error during script generation", throwable);
        }
    }

    private void addRootTableWhere(StringBuilder stringBuilder) {
        boolean bl = true;
        for (ColumnData columnData : this.columnValues) {
            if (!bl) {
                stringBuilder.append(" AND ");
            } else {
                bl = false;
            }
            ColumnIdentifier columnIdentifier = columnData.getIdentifier();
            String string = columnIdentifier.getDataType() == Integer.MIN_VALUE ? SqlUtil.quoteObjectname(columnIdentifier.getColumnName(), false) : this.connection.getMetadata().quoteObjectname(columnIdentifier.getColumnName());
            this.appendColumnData(stringBuilder, string, columnData);
        }
    }

    private ColumnData findColData(String string) {
        for (ColumnData columnData : this.columnValues) {
            if (!columnData.getIdentifier().getColumnName().equalsIgnoreCase(string)) continue;
            return columnData;
        }
        return null;
    }

    private void addRootTableWhere(StringBuilder stringBuilder, String string, String string2) {
        ColumnData columnData = this.findColData(string);
        string2 = this.connection.getMetadata().quoteObjectname(string2);
        this.appendColumnData(stringBuilder, string2, columnData);
    }

    private boolean isExpression(ColumnData columnData) {
        if (columnData == null) {
            return false;
        }
        if (columnData.getIdentifier() == null) {
            return false;
        }
        Object object = columnData.getValue();
        if (object == null) {
            return false;
        }
        ColumnIdentifier columnIdentifier = columnData.getIdentifier();
        if (columnIdentifier != null && columnIdentifier.getDataType() != 1111 && columnIdentifier.getDataType() != Integer.MIN_VALUE && columnIdentifier.getDbmsType() != null) {
            return false;
        }
        if (object instanceof String) {
            String string = (String)object;
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.connection, string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            return sQLToken.isReservedWord() || sQLToken.isOperator();
        }
        return false;
    }

    private void appendColumnData(StringBuilder stringBuilder, String string, ColumnData columnData) {
        stringBuilder.append(string);
        if (columnData == null || columnData.isNull()) {
            stringBuilder.append(" IS NULL");
        } else if (this.isExpression(columnData)) {
            stringBuilder.append(' ');
            stringBuilder.append(columnData.getValue());
        } else {
            stringBuilder.append(" = ");
            stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
        }
    }

    public void startGenerate() {
        ObjectScripterUI objectScripterUI = new ObjectScripterUI(this);
        objectScripterUI.show(WbManager.getInstance().getCurrentWindow());
    }

    @Override
    public void setProgressMonitor(ScriptGenerationMonitor scriptGenerationMonitor) {
        this.monitor = scriptGenerationMonitor;
    }

    public String getScript(CommitType commitType) {
        if (this.statements.isEmpty()) {
            this.generateScript();
        }
        StringBuilder stringBuilder = new StringBuilder(this.statements.size() * 100);
        String string = ";\n";
        boolean bl = CollectionUtil.isNonEmpty(this.columnValues);
        String string2 = "\n" + FormatterUtil.getKeyword("commit") + ";\n";
        for (String string3 : this.statements) {
            stringBuilder.append(string3);
            stringBuilder.append(string);
            if (commitType == CommitType.each) {
                stringBuilder.append(string2);
            }
            if (!bl) continue;
            stringBuilder.append("\n");
        }
        if (commitType == CommitType.once) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public String getScriptForValues(List<ColumnData> list, CommitType commitType) throws SQLException {
        this.statements.clear();
        this.setValues(list);
        this.createStatements(true);
        return this.getScript(commitType);
    }

    public List<String> getStatementsForValues(List<ColumnData> list, boolean bl) {
        this.statements.clear();
        this.setValues(list);
        this.createStatements(bl);
        return Collections.unmodifiableList(this.statements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateScript() {
        Serializable serializable;
        if (this.sourceTable == null) {
            return;
        }
        DataStore dataStore = this.sourceTable.getDataStore();
        if (dataStore == null) {
            return;
        }
        int[] nArray = this.sourceTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        if (this.connection.isBusy()) {
            serializable = new Exception("Connection is busy");
            LogMgr.logError(new CallerInfo(){}, "Connection is busy!", serializable);
        }
        dataStore.checkUpdateTable();
        serializable = dataStore.getUpdateTable();
        int n = nArray.length;
        try {
            this.connection.setBusy(true);
            this.setTable((TableIdentifier)serializable);
            for (int i = 0; i < n; ++i) {
                List<ColumnData> list = dataStore.getPkValues(nArray[i]);
                this.setValues(list);
                if (this.monitor != null) {
                    this.monitor.setCurrentObject(ResourceMgr.getString("MsgGeneratingScriptForRow"), i + 1, n);
                }
                this.createStatements(true);
                if (this.dependency == null || !this.dependency.isCancelled()) continue;
                break;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error generating delete script", exception);
        }
        finally {
            if (this.monitor != null) {
                this.monitor.setCurrentObject(null, -1, -1);
            }
            this.connection.setBusy(false);
            if (this.endTransaction) {
                ExplorerUtils.endTransaction(this.connection);
            }
        }
    }

    private int adjustLevels(Map<Integer, Set<DependencyNode>> map) {
        Set<DependencyNode> set;
        HashMap<DependencyNode, Integer> hashMap = new HashMap<DependencyNode, Integer>();
        for (Map.Entry<Integer, Set<DependencyNode>> entry : map.entrySet()) {
            set = entry.getValue().iterator();
            while (set.hasNext()) {
                DependencyNode dependencyNode = set.next();
                int n = this.findTableDependentLevel(map, dependencyNode.getTable(), entry.getKey());
                if (n <= 0) continue;
                if (n == entry.getKey() && n > 1) {
                    LogMgr.logTrace(new CallerInfo(){}, "Entry for table: " + dependencyNode.getTable() + " (" + dependencyNode.getFkName() + ") should be moved to the same level (" + entry.getKey() + "). Moving to " + --n);
                }
                if (n == entry.getKey()) continue;
                LogMgr.logTrace(new CallerInfo(){}, "Moving entry for table: " + dependencyNode.getTable() + " (" + dependencyNode.getFkName() + ") from level " + entry.getKey() + " to level " + n);
                hashMap.put(dependencyNode, n);
                set.remove();
            }
        }
        for (Map.Entry<Integer, Set<DependencyNode>> entry : hashMap.entrySet()) {
            set = map.get(entry.getValue());
            if (set == null) continue;
            set.add((DependencyNode)((Object)entry.getKey()));
        }
        return hashMap.size();
    }

    private int findTableDependentLevel(Map<Integer, Set<DependencyNode>> map, TableIdentifier tableIdentifier, int n) {
        for (Map.Entry<Integer, Set<DependencyNode>> entry : map.entrySet()) {
            if (n < entry.getKey()) continue;
            for (DependencyNode dependencyNode : entry.getValue()) {
                for (DependencyNode dependencyNode2 = dependencyNode.getParent(); dependencyNode2 != null; dependencyNode2 = dependencyNode2.getParent()) {
                    if (!dependencyNode2.getTable().equals(tableIdentifier)) continue;
                    return entry.getKey();
                }
            }
        }
        return -1;
    }

    private Map<Integer, Set<DependencyNode>> buildLevelsTopDown(DependencyNode dependencyNode, int n) {
        AggregatingMap<Integer, DependencyNode> aggregatingMap = new AggregatingMap<Integer, DependencyNode>(new TreeMap(this.descComparator));
        List<DependencyNode> list = dependencyNode.getChildren();
        if (list.isEmpty()) {
            return aggregatingMap.getMap();
        }
        Integer n2 = n;
        for (DependencyNode dependencyNode2 : list) {
            aggregatingMap.addValue(n2, dependencyNode2);
        }
        for (DependencyNode dependencyNode2 : list) {
            if (dependencyNode2.getChildren().size() <= 0) continue;
            aggregatingMap.addAllValues(this.buildLevelsTopDown(dependencyNode2, n + 1));
        }
        return aggregatingMap.getMap();
    }
}

