/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.db.DependencyNode;
import workbench.db.TableIdentifier;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

class DependencyDuplicateFinder {
    private final DependencyNode root;
    private final Map<TableIdentifier, Integer> tableLevels = new HashMap<TableIdentifier, Integer>();

    DependencyDuplicateFinder(DependencyNode dependencyNode) {
        this.root = dependencyNode;
    }

    Set<String> getDuplicates() {
        HashSet<String> hashSet = new HashSet<String>();
        List<NodeInformation> list = this.buildTree(this.root, 0);
        for (NodeInformation nodeInformation : list) {
            if (nodeInformation.level <= this.getHighestLevel(nodeInformation.node.getTable())) continue;
            String string = DependencyDuplicateFinder.getNodePath(nodeInformation.node);
            if (LogMgr.isTraceEnabled()) {
                LogMgr.logTrace(new CallerInfo(){}, "Node " + string + " is redundant");
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    static String getNodePath(DependencyNode dependencyNode) {
        StringBuilder stringBuilder = new StringBuilder(10);
        stringBuilder.append('/');
        stringBuilder.append(dependencyNode.getTable().getTableExpression());
        for (DependencyNode dependencyNode2 = dependencyNode.getParent(); dependencyNode2 != null; dependencyNode2 = dependencyNode2.getParent()) {
            stringBuilder.insert(0, "/" + dependencyNode2.getTable().getTableExpression());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void dumpTree(List<NodeInformation> list, String string) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(new File("c:/temp", string));
            fileWriter.append(this.root.getTable().toString() + "\n");
            for (NodeInformation nodeInformation : list) {
                String string2 = StringUtil.padRight("", (nodeInformation.level + 1) * 4);
                fileWriter.append(string2);
                fileWriter.append(nodeInformation.node.getTable().toString());
                String string3 = StringUtil.listToString(nodeInformation.node.getColumns().keySet(), ',');
                fileWriter.append(" (").append(string3).append(')');
                fileWriter.append('\n');
            }
        }
        catch (IOException iOException) {
            FileUtil.closeQuietely(fileWriter);
            catch (Throwable throwable) {
                FileUtil.closeQuietely(fileWriter);
                throw throwable;
            }
        }
        FileUtil.closeQuietely(fileWriter);
    }

    private int getHighestLevel(TableIdentifier tableIdentifier) {
        Integer n = this.tableLevels.get(tableIdentifier);
        if (n == null) {
            return 0;
        }
        return n;
    }

    List<NodeInformation> buildTree(DependencyNode dependencyNode, int n) {
        ArrayList<NodeInformation> arrayList = new ArrayList<NodeInformation>();
        List<DependencyNode> list = dependencyNode.getChildren();
        if (list.isEmpty()) {
            return arrayList;
        }
        for (DependencyNode dependencyNode2 : list) {
            NodeInformation nodeInformation = new NodeInformation();
            nodeInformation.node = dependencyNode2;
            nodeInformation.level = n;
            if (!this.tableLevels.containsKey(dependencyNode2.getTable())) {
                this.tableLevels.put(dependencyNode2.getTable(), n);
            }
            arrayList.add(nodeInformation);
            arrayList.addAll(this.buildTree(dependencyNode2, n + 1));
        }
        return arrayList;
    }

    class NodeInformation {
        DependencyNode node;
        int level;

        NodeInformation() {
        }
    }
}

