/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import workbench.db.FKMatchType;
import workbench.db.TableIdentifier;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class DependencyNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DependencyNode parentNode;
    private final TableIdentifier table;
    private String updateAction = "";
    private String deleteAction = "";
    private String fkName;
    private String deferrable;
    private String remarks;
    private FKMatchType matchType;
    private int updateActionValue;
    private int deleteActionValue;
    private int deferrableValue;
    private boolean enabled = true;
    private boolean validated = true;
    private final Map<String, String> columns = new LinkedHashMap<String, String>();
    private final List<DependencyNode> childTables = new ArrayList<DependencyNode>();

    public DependencyNode(TableIdentifier tableIdentifier) {
        this.table = tableIdentifier.createCopy();
        this.parentNode = null;
    }

    public void addColumnDefinition(String string, String string2) {
        String string3 = this.columns.get(string);
        if (string3 == null) {
            this.columns.put(string, string2);
        }
    }

    public FKMatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(FKMatchType fKMatchType) {
        this.matchType = fKMatchType;
    }

    public String getComment() {
        return this.remarks;
    }

    public void setComment(String string) {
        this.remarks = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean bl) {
        this.validated = bl;
    }

    public String getDeferrableType() {
        return this.deferrable;
    }

    public void setDeferrableType(String string) {
        this.deferrable = string;
    }

    public int getLevel() {
        if (this.parentNode == null) {
            return 0;
        }
        if (this.parentNode == this) {
            return -1;
        }
        return 1 + this.parentNode.getLevel();
    }

    public void setParent(DependencyNode dependencyNode, String string) {
        if (string == null) {
            throw new NullPointerException("FK Name may not be null");
        }
        this.parentNode = dependencyNode;
        this.fkName = string;
    }

    public String toString() {
        String string = this.table.getTableName();
        if (this.fkName != null) {
            string = string + " (" + this.fkName + ")";
        }
        return string;
    }

    public String debugString() {
        if (this.parentNode == null) {
            return "root node for table " + this.table.getTableName();
        }
        StringBuilder stringBuilder = new StringBuilder(20);
        if (this.fkName != null) {
            stringBuilder.append("foreign key " + this.fkName + ", ");
        }
        stringBuilder.append(this.table.getTableName());
        if (this.columns.size() > 0) {
            String string = StringUtil.listToString(this.columns.keySet(), ',');
            stringBuilder.append('(');
            stringBuilder.append(string);
            stringBuilder.append(')');
        }
        if (this.parentNode != null) {
            stringBuilder.append(" references ");
            stringBuilder.append(this.parentNode.table.getTableName());
            stringBuilder.append('(');
        } else if (this.columns.size() > 0) {
            stringBuilder.append(" --> (");
        }
        boolean bl = true;
        for (String string : this.columns.keySet()) {
            if (!bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.columns.get(string));
            bl = false;
        }
        if (this.columns.size() > 0) {
            stringBuilder.append(')');
        }
        stringBuilder.append(", level:");
        stringBuilder.append(this.getLevel());
        return stringBuilder.toString();
    }

    public List<String> getSourceColumns() {
        return new ArrayList<String>(this.columns.keySet());
    }

    public String getSourceColumnsList() {
        if (CollectionUtil.isEmpty(this.columns)) {
            return "";
        }
        return StringUtil.listToString(this.columns.keySet(), ',');
    }

    public List<String> getTargetColumns() {
        ArrayList<String> arrayList = new ArrayList<String>(this.columns.size());
        for (String string : this.columns.keySet()) {
            arrayList.add(this.columns.get(string));
        }
        return arrayList;
    }

    public String getTargetColumnsList() {
        if (CollectionUtil.isEmpty(this.columns)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.columns.size() * 15);
        boolean bl = true;
        for (String string : this.columns.keySet()) {
            if (!bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.columns.get(string));
            bl = false;
        }
        return stringBuilder.toString();
    }

    public String getFkName() {
        return this.fkName;
    }

    public TableIdentifier getParentTable() {
        if (this.parentNode == null) {
            return null;
        }
        return this.parentNode.getTable();
    }

    public TableIdentifier getTable() {
        return this.table;
    }

    public Map<String, String> getColumns() {
        if (this.columns == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.columns);
    }

    public boolean isDefinitionFor(TableIdentifier tableIdentifier, String string) {
        if (string == null) {
            return false;
        }
        return this.table.equals(tableIdentifier) && string.equals(this.fkName);
    }

    public boolean equals(Object object) {
        if (object instanceof DependencyNode) {
            DependencyNode dependencyNode = (DependencyNode)object;
            return this.isDefinitionFor(dependencyNode.getTable(), dependencyNode.getFkName());
        }
        return false;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append(this.table.getTableExpression() + "-" + this.fkName);
        return StringUtil.hashCode(stringBuilder);
    }

    public boolean isRoot() {
        return this.parentNode == null;
    }

    public DependencyNode getParent() {
        return this.parentNode;
    }

    public List<DependencyNode> getChildren() {
        return this.childTables;
    }

    public DependencyNode findNode(DependencyNode dependencyNode) {
        if (dependencyNode == null) {
            return null;
        }
        if (dependencyNode.equals(this)) {
            return this;
        }
        for (DependencyNode dependencyNode2 : this.childTables) {
            if (dependencyNode.equals(dependencyNode2)) {
                return dependencyNode2;
            }
            DependencyNode dependencyNode3 = dependencyNode2.findNode(dependencyNode);
            if (dependencyNode3 == null) continue;
            return dependencyNode3;
        }
        return null;
    }

    public DependencyNode addChild(TableIdentifier tableIdentifier, String string) {
        if (string == null) {
            throw new NullPointerException("FK Name may not be null");
        }
        for (DependencyNode dependencyNode : this.childTables) {
            if (!dependencyNode.isDefinitionFor(tableIdentifier, string)) continue;
            return dependencyNode;
        }
        DependencyNode dependencyNode = new DependencyNode(tableIdentifier);
        dependencyNode.setParent(this, string);
        this.childTables.add(dependencyNode);
        return dependencyNode;
    }

    public DependencyNode findChildTree(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return null;
        }
        if (this.table.equals(tableIdentifier)) {
            return this;
        }
        for (DependencyNode dependencyNode : this.childTables) {
            DependencyNode dependencyNode2 = dependencyNode.findChildTree(tableIdentifier);
            if (dependencyNode2 == null) continue;
            return dependencyNode2;
        }
        return null;
    }

    public boolean containsParentTable(TableIdentifier tableIdentifier) {
        if (this.parentNode == null) {
            return false;
        }
        DependencyNode dependencyNode = this.parentNode;
        while (dependencyNode != null) {
            if (dependencyNode.table.equals(tableIdentifier)) {
                return true;
            }
            dependencyNode = dependencyNode.parentNode;
        }
        return false;
    }

    public boolean containsChildTable(TableIdentifier tableIdentifier) {
        for (DependencyNode dependencyNode : this.childTables) {
            if (!dependencyNode.getTable().equals(tableIdentifier)) continue;
            return true;
        }
        return false;
    }

    public boolean containsChild(DependencyNode dependencyNode) {
        if (dependencyNode == null) {
            return false;
        }
        return this.childTables.contains(dependencyNode);
    }

    public boolean addChild(DependencyNode dependencyNode) {
        if (this.containsChild(dependencyNode)) {
            return false;
        }
        this.childTables.add(dependencyNode);
        return true;
    }

    public String getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(String string) {
        this.deleteAction = string;
    }

    public String getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(String string) {
        this.updateAction = string;
    }

    public void setUpdateActionValue(int n) {
        this.updateActionValue = n;
    }

    public int getUpdateActionValue() {
        return this.updateActionValue;
    }

    public int getDeleteActionValue() {
        return this.deleteActionValue;
    }

    public void setDeleteActionValue(int n) {
        this.deleteActionValue = n;
    }

    public int getDeferrableValue() {
        return this.deferrableValue;
    }

    public void setDeferrableValue(int n) {
        this.deferrableValue = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAll(File file) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            this.printAll(printWriter);
        }
        catch (IOException iOException) {
            FileUtil.closeQuietely(printWriter);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietely(printWriter);
            throw throwable;
        }
        FileUtil.closeQuietely(printWriter);
    }

    public void printAll(PrintWriter printWriter) {
        int n = this.getLevel();
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        printWriter.println(stringBuilder + this.debugString());
        for (DependencyNode dependencyNode : this.childTables) {
            dependencyNode.printAll(printWriter);
        }
    }

    public void printParents(PrintWriter printWriter) {
        int n = this.getLevel();
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        printWriter.println(stringBuilder + this.debugString());
        DependencyNode dependencyNode = this.parentNode;
        while (dependencyNode != null) {
            printWriter.print(stringBuilder + dependencyNode.debugString());
            dependencyNode = dependencyNode.parentNode;
        }
    }
}

