/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import workbench.db.DependencyNode;
import workbench.db.TableIdentifier;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class DependencyTreeDumper {
    private final Set<TableIdentifier> dumpedNodes = new HashSet<TableIdentifier>();

    public void dumpNodes(Collection<DependencyNode> collection) {
        for (DependencyNode dependencyNode : collection) {
            this.dumpNode(dependencyNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpNode(DependencyNode dependencyNode) {
        if (dependencyNode == null) {
            return;
        }
        if (CollectionUtil.isEmpty(dependencyNode.getChildren())) {
            return;
        }
        if (this.dumpedNodes.contains(dependencyNode.getTable())) {
            return;
        }
        this.dumpedNodes.add(dependencyNode.getTable());
        PrintWriter printWriter = null;
        try {
            File file = Settings.getInstance().getConfigDir();
            String string = dependencyNode.getTable().getTableName();
            File file2 = File.createTempFile("deptree_" + StringUtil.makeFilename(string) + "_", ".txt", file);
            printWriter = new PrintWriter(new FileWriter(file2));
            String string2 = "Root: " + dependencyNode.getTable().getTableExpression();
            printWriter.println(string2);
            printWriter.println(StringUtil.padRight("=", string2.length(), '='));
            this.dumpNode(dependencyNode, 0, printWriter);
            FileUtil.closeQuietely(printWriter);
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not dump dependency node: " + dependencyNode.debugString(), exception);
        }
        finally {
            FileUtil.closeQuietely(printWriter);
        }
    }

    private void dumpNode(DependencyNode dependencyNode, int n, PrintWriter printWriter) {
        List<DependencyNode> list = dependencyNode.getChildren();
        for (DependencyNode dependencyNode2 : list) {
            printWriter.println(StringUtil.padRight("", n * 4) + dependencyNode2.debugString());
            this.dumpNode(dependencyNode2, n + 1, printWriter);
        }
    }
}

