/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.sql.SQLException;
import workbench.db.ComparableDbObject;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DomainIdentifier
implements ComparableDbObject,
Serializable {
    private String catalog;
    private String schema;
    private String domainName;
    private String objectType = "DOMAIN";
    private String remarks;
    private String dataType;
    private boolean nullable;
    private String constraintDefinition;
    private String constraintName;
    private String defaultValue;
    private String source;

    public DomainIdentifier(String string, String string2, String string3) {
        this.catalog = string;
        this.schema = string2;
        this.domainName = string3;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setCheckConstraint(String string) {
        this.constraintDefinition = string;
    }

    public String getCheckConstraint() {
        return this.constraintDefinition;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public String getObjectName() {
        return this.domainName;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.domainName;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, this);
    }

    public String toString() {
        return this.getSummary();
    }

    public String getSummary() {
        StringBuilder stringBuilder = new StringBuilder(25);
        stringBuilder.append(this.dataType);
        if (!this.nullable) {
            stringBuilder.append(" NOT NULL");
        }
        if (StringUtil.isNonBlank(this.defaultValue)) {
            stringBuilder.append(" DEFAULT " + this.defaultValue);
        }
        if (StringUtil.isNonBlank(this.constraintDefinition)) {
            stringBuilder.append(' ');
            stringBuilder.append(this.constraintDefinition);
        }
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        if (StringUtil.isBlank(this.source)) {
            this.source = wbConnection.getMetadata().getObjectSource(this);
        }
        return this.source;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return this.remarks;
    }

    @Override
    public void setComment(String string) {
        this.remarks = string;
    }

    @Override
    public boolean isComparableWith(DbObject dbObject) {
        return dbObject instanceof DomainIdentifier;
    }

    @Override
    public boolean isEqualTo(DbObject dbObject) {
        if (dbObject instanceof DomainIdentifier) {
            DomainIdentifier domainIdentifier = (DomainIdentifier)dbObject;
            if (!StringUtil.equalStringOrEmpty(this.dataType, domainIdentifier.dataType)) {
                return false;
            }
            if (this.nullable != domainIdentifier.nullable) {
                return false;
            }
            if (!StringUtil.equalStringOrEmpty(this.defaultValue, domainIdentifier.defaultValue)) {
                return false;
            }
            if (!StringUtil.equalStringOrEmpty(this.constraintDefinition, domainIdentifier.constraintDefinition)) {
                return false;
            }
            if (!StringUtil.equalStringOrEmpty(this.constraintName, domainIdentifier.constraintName)) {
                return false;
            }
            return StringUtil.equalStringOrEmpty(this.remarks, domainIdentifier.remarks);
        }
        return false;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

