/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import workbench.db.DbObjectFinder;
import workbench.db.DependencyNode;
import workbench.db.GenericObjectDropper;
import workbench.db.PkDefinition;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.gui.dbobjects.ExplorerUtils;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.interfaces.Scripter;
import workbench.interfaces.TextOutput;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptParser;
import workbench.storage.RowActionMonitor;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;

public class DropScriptGenerator
implements Scripter {
    private final WbConnection connection;
    private final DbObjectFinder finder;
    private List<TableIdentifier> tables;
    private ScriptGenerationMonitor scriptMonitor;
    private RowActionMonitor rowMonitor;
    private Map<TableIdentifier, List<String>> dropConstraints = new HashMap<TableIdentifier, List<String>>();
    private Map<TableIdentifier, List<String>> restoreConstraints = new HashMap<TableIdentifier, List<String>>();
    private Map<TableIdentifier, String> dropTableStatements = new HashMap<TableIdentifier, String>();
    private String dropTemplate;
    private boolean includeCreate = true;
    private boolean includeDropTable = true;
    private boolean sortByType;
    private boolean includeTableMarkers = true;
    private TextOutput display;
    private boolean endTransaction;

    public DropScriptGenerator(WbConnection wbConnection) {
        this.connection = wbConnection;
        this.dropTemplate = this.connection.getDbSettings().getDropFKConstraint("table");
        this.finder = new DbObjectFinder(this.connection);
    }

    @Override
    public void setEndTransaction(boolean bl) {
        this.endTransaction = bl;
    }

    @Override
    public void setTextOutput(TextOutput textOutput) {
        this.display = textOutput;
    }

    @Override
    public WbConnection getCurrentConnection() {
        return this.connection;
    }

    public void setIncludeComments(boolean bl) {
        this.includeTableMarkers = bl;
    }

    public void setSortByType(boolean bl) {
        this.sortByType = bl;
    }

    public void setIncludeRecreateStatements(boolean bl) {
        this.includeCreate = bl;
    }

    public void setIncludeDropTable(boolean bl) {
        this.includeDropTable = bl;
    }

    public void setTable(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            throw new IllegalArgumentException("The table name may not be empty");
        }
        this.tables = Collections.singletonList(this.finder.findTable(tableIdentifier, false));
        this.reset();
    }

    public void setTables(List<TableIdentifier> list) {
        this.tables = new ArrayList<TableIdentifier>(list.size());
        for (TableIdentifier tableIdentifier : list) {
            TableIdentifier tableIdentifier2 = this.finder.findTable(tableIdentifier, false);
            if (tableIdentifier2 == null) continue;
            this.tables.add(tableIdentifier2);
        }
        this.reset();
    }

    private void reset() {
        this.dropConstraints.clear();
        this.restoreConstraints.clear();
        this.dropTableStatements.clear();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void cancel() {
    }

    private void createStatementsForTable(TableIdentifier tableIdentifier) {
        Serializable serializable2;
        Object object;
        CharSequence charSequence;
        ArrayList<DependencyNode> arrayList = new ArrayList<DependencyNode>();
        TableDependency tableDependency = new TableDependency(this.connection, tableIdentifier);
        tableDependency.readDependencyTree(true);
        tableDependency.setRetrieveDirectChildrenOnly(true);
        List<DependencyNode> list = tableDependency.getRootNode().getChildren();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (this.includeDropTable && (charSequence = ((TableSourceBuilder)(object = TableSourceBuilderFactory.getBuilder(this.connection))).getPkSource(tableIdentifier, (PkDefinition)(serializable2 = this.connection.getMetadata().getIndexReader().getPrimaryKey(tableIdentifier)), false, false)) != null) {
            arrayList3.add(charSequence.toString().trim());
        }
        for (Serializable serializable2 : list) {
            if (arrayList.contains(serializable2)) continue;
            arrayList2.add(this.createDropFKStatement((DependencyNode)serializable2));
            this.createRestoreStatements((List<String>)arrayList3, (DependencyNode)serializable2);
            arrayList.add((DependencyNode)serializable2);
        }
        this.createRootRestoreStatements(arrayList3, tableIdentifier);
        this.dropConstraints.put(tableIdentifier, arrayList2);
        this.restoreConstraints.put(tableIdentifier, arrayList3);
        object = new GenericObjectDropper();
        ((GenericObjectDropper)object).setConnection(this.connection);
        ((GenericObjectDropper)object).setCascade(false);
        ((GenericObjectDropper)object).setUseTransaction(false);
        ((GenericObjectDropper)object).setObjects(Collections.singletonList(tableIdentifier));
        this.dropTableStatements.put(tableIdentifier, ((GenericObjectDropper)object).getScript().toString().trim());
    }

    private void createRootRestoreStatements(List<String> list, TableIdentifier tableIdentifier) {
        TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(this.connection);
        ScriptParser scriptParser = new ScriptParser(ParserType.getTypeFromConnection(this.connection));
        StringBuilder stringBuilder = tableSourceBuilder.getFkSource(tableIdentifier);
        if (stringBuilder.length() > 0) {
            scriptParser.setScript(stringBuilder.toString());
            int n = scriptParser.getSize();
            for (int i = 0; i < n; ++i) {
                String string = scriptParser.getCommand(i);
                list.add(SqlUtil.addSemicolon(string));
            }
        }
    }

    private void createRestoreStatements(List<String> list, DependencyNode dependencyNode) {
        TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(this.connection);
        ScriptParser scriptParser = new ScriptParser(ParserType.getTypeFromConnection(this.connection));
        scriptParser.setScript(tableSourceBuilder.getFkSource(dependencyNode.getTable()).toString());
        int n = scriptParser.getSize();
        for (int i = 0; i < n; ++i) {
            String string = scriptParser.getCommand(i);
            if (!string.contains(dependencyNode.getFkName())) continue;
            list.add(SqlUtil.addSemicolon(string));
        }
    }

    private String createDropFKStatement(DependencyNode dependencyNode) {
        if (dependencyNode == null) {
            return null;
        }
        String string = TemplateHandler.replaceTablePlaceholder(this.dropTemplate, dependencyNode.getTable(), this.connection);
        string = string.replace("%constraint_name%", dependencyNode.getFkName());
        return SqlUtil.addSemicolon(string);
    }

    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.rowMonitor = rowActionMonitor;
    }

    @Override
    public void setProgressMonitor(ScriptGenerationMonitor scriptGenerationMonitor) {
        this.scriptMonitor = scriptGenerationMonitor;
    }

    public String getScript() {
        if (CollectionUtil.isEmpty(this.dropConstraints)) {
            this.generateScript();
        }
        StringBuilder stringBuilder = new StringBuilder(this.dropConstraints.size() * 30);
        if (this.sortByType) {
            this.appendDropFKs(stringBuilder);
            if (this.includeDropTable) {
                this.appendDropTables(stringBuilder);
            }
            if (this.includeCreate) {
                this.appendCreateFks(stringBuilder);
            }
        } else {
            boolean bl = this.includeTableMarkers && this.tables.size() > 1;
            for (TableIdentifier tableIdentifier : this.tables) {
                this.appendTable(stringBuilder, tableIdentifier, bl);
            }
        }
        return stringBuilder.toString();
    }

    private void appendCreateFks(StringBuilder stringBuilder) {
        for (List<String> list : this.restoreConstraints.values()) {
            for (String string : list) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append('\n');
    }

    private void appendDropTables(StringBuilder stringBuilder) {
        for (String string : this.dropTableStatements.values()) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        stringBuilder.append('\n');
    }

    private void appendDropFKs(StringBuilder stringBuilder) {
        int n = 0;
        for (List<String> list : this.dropConstraints.values()) {
            for (String string : list) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
                ++n;
            }
        }
        if (n > 0) {
            stringBuilder.append('\n');
        }
    }

    private void appendTable(StringBuilder stringBuilder, TableIdentifier tableIdentifier, boolean bl) {
        List<String> list = this.dropConstraints.get(tableIdentifier);
        if (list == null) {
            return;
        }
        boolean bl2 = false;
        if (bl && (list.size() > 0 || this.includeDropTable)) {
            stringBuilder.append("--- BEGIN ");
            stringBuilder.append(tableIdentifier.getTableName());
            stringBuilder.append(" ---\n");
            bl2 = true;
        }
        for (String object : list) {
            stringBuilder.append(object);
            stringBuilder.append('\n');
        }
        if (list.size() > 0) {
            stringBuilder.append('\n');
        }
        if (this.includeDropTable) {
            stringBuilder.append(this.dropTableStatements.get(tableIdentifier));
            stringBuilder.append("\n\n");
        }
        if (this.includeCreate) {
            List<String> list2 = this.restoreConstraints.get(tableIdentifier);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
        }
        if (bl2) {
            stringBuilder.append("--- END ");
            stringBuilder.append(tableIdentifier.getTableName());
            stringBuilder.append(" ---\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateScript() {
        try {
            this.reset();
            if (this.rowMonitor != null) {
                this.rowMonitor.setMonitorType(6);
            }
            int n = this.tables.size();
            int n2 = 1;
            for (TableIdentifier tableIdentifier : this.tables) {
                if (this.rowMonitor != null) {
                    this.rowMonitor.setCurrentObject(tableIdentifier.getTableName(), n2, n);
                }
                if (this.scriptMonitor != null) {
                    this.scriptMonitor.setCurrentObject(tableIdentifier.getTableName(), n2, n);
                }
                this.createStatementsForTable(tableIdentifier);
                ++n2;
            }
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
            }
            if (this.display != null) {
                this.display.append(this.getScript());
            }
        }
        finally {
            if (this.endTransaction) {
                ExplorerUtils.endTransaction(this.connection);
            }
        }
    }

    public List<TableIdentifier> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public String getScriptFor(TableIdentifier tableIdentifier) {
        if (CollectionUtil.isEmpty(this.dropConstraints)) {
            this.generateScript();
        }
        StringBuilder stringBuilder = new StringBuilder(250);
        this.appendTable(stringBuilder, tableIdentifier, false);
        return stringBuilder.toString();
    }

    public List<String> getDropConstraintStatements(TableIdentifier tableIdentifier) {
        if (CollectionUtil.isEmpty(this.dropConstraints)) {
            this.generateScript();
        }
        return Collections.unmodifiableList(this.dropConstraints.get(tableIdentifier));
    }

    public List<String> getRestoreStatements(TableIdentifier tableIdentifier) {
        if (CollectionUtil.isEmpty(this.dropConstraints)) {
            this.generateScript();
        }
        return Collections.unmodifiableList(this.restoreConstraints.get(tableIdentifier));
    }
}

