/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.DummyDML;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.resource.Settings;
import workbench.sql.formatter.FormatterUtil;

public class DummyInsert
extends DummyDML
implements DbObject {
    public DummyInsert(TableIdentifier tableIdentifier) {
        super(tableIdentifier);
        this.doFormat = Settings.getInstance().getDoFormatInserts();
    }

    public DummyInsert(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        super(tableIdentifier, list);
        this.doFormat = Settings.getInstance().getDoFormatInserts();
    }

    @Override
    public String getObjectType() {
        return "INSERT";
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        int n;
        List<ColumnIdentifier> list = this.getColumns(wbConnection);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        StringBuilder stringBuilder = new StringBuilder(list.size() * 20 + 100);
        stringBuilder.append(FormatterUtil.getKeyword("insert into"));
        stringBuilder.append(' ');
        stringBuilder.append(FormatterUtil.getIdentifier(this.table.getTableExpression(wbConnection)));
        stringBuilder.append(string);
        stringBuilder.append("  (");
        for (n = 0; n < list.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getColumnName(list.get(n), wbConnection));
        }
        stringBuilder.append(')');
        stringBuilder.append(string);
        stringBuilder.append(FormatterUtil.getKeyword("VALUES"));
        stringBuilder.append(string);
        stringBuilder.append("  (");
        for (n = 0; n < list.size(); ++n) {
            ColumnIdentifier columnIdentifier = list.get(n);
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getValueString(columnIdentifier));
        }
        stringBuilder.append(");");
        return this.formatSql(stringBuilder.toString(), wbConnection);
    }
}

