/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ComparableDbObject;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;

public class EnumIdentifier
implements ComparableDbObject {
    private String catalog;
    private String schema;
    private String enumName;
    private String remarks;
    private List<String> values;

    public EnumIdentifier(String string, String string2, String string3) {
        this.catalog = string;
        this.schema = string2;
        this.enumName = string3;
    }

    public void addEnumValue(String string) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(string);
    }

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getObjectType() {
        return "ENUM";
    }

    @Override
    public void setName(String string) {
        this.enumName = string;
    }

    @Override
    public String getObjectName() {
        return this.enumName;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.enumName;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.enumName;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return wbConnection.getMetadata().getObjectSource(this);
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return this.remarks;
    }

    @Override
    public void setComment(String string) {
        this.remarks = string;
    }

    @Override
    public boolean isComparableWith(DbObject dbObject) {
        return dbObject instanceof EnumIdentifier;
    }

    @Override
    public boolean isEqualTo(DbObject dbObject) {
        if (dbObject instanceof EnumIdentifier) {
            int n;
            EnumIdentifier enumIdentifier = (EnumIdentifier)dbObject;
            int n2 = this.values == null ? 0 : this.values.size();
            int n3 = n = enumIdentifier.values == null ? 0 : enumIdentifier.values.size();
            if (n2 != n) {
                return false;
            }
            return this.values.equals(enumIdentifier.values);
        }
        return false;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

