/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import workbench.db.DbSettings;
import workbench.db.JdbcUtils;
import workbench.db.SchemaInformationReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class GenericSchemaInfoReader
implements SchemaInformationReader,
PropertyChangeListener {
    private WbConnection connection;
    private String schemaQuery;
    private final boolean useSavepoint;
    private boolean reuseStmt;
    private boolean isCacheable;
    private PreparedStatement query;
    private String cachedSchema;
    private final String reuseProp = "currentschema.reuse.stmt";
    private final String queryProp = "currentschema.query";
    private final String cacheProp = "currentschema.cacheable";
    private final String timeoutProp = "currentschema.timeout";

    public GenericSchemaInfoReader(WbConnection wbConnection, DbSettings dbSettings) {
        this.connection = wbConnection;
        this.useSavepoint = dbSettings.getBoolProperty("currentschema.query.usesavepoint", false);
        this.schemaQuery = dbSettings.getProperty("currentschema.query", null);
        this.reuseStmt = dbSettings.getBoolProperty("currentschema.reuse.stmt", false);
        this.isCacheable = dbSettings.getBoolProperty("currentschema.cacheable", false);
        this.connection.addChangeListener(this);
        this.logSettings();
    }

    @Override
    public boolean isSupported() {
        return StringUtil.isNonEmpty(this.schemaQuery);
    }

    private void logSettings() {
        LogMgr.logDebug(new CallerInfo(){}, this.connection.getId() + ": Re-Use statement: " + this.reuseStmt + ", cache current schema: " + this.isCacheable + ", SQL: " + this.schemaQuery);
    }

    @Override
    public void clearCache() {
        this.cachedSchema = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.connection && propertyChangeEvent.getPropertyName().equals("schema")) {
            Object object = propertyChangeEvent.getNewValue();
            this.cachedSchema = object instanceof String ? (String)object : null;
        }
    }

    private int getQueryTimeout() {
        int n = this.connection.getDbSettings().getIntProperty("currentschema.timeout", 0);
        if (n < 0) {
            return 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() {
        if (this.connection == null) {
            return null;
        }
        if (StringUtil.isEmptyString(this.schemaQuery)) {
            return null;
        }
        if (this.isCacheable && this.cachedSchema != null) {
            return this.cachedSchema;
        }
        String string = null;
        Savepoint savepoint = null;
        ResultSet resultSet = null;
        Statement statement = null;
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            if (this.useSavepoint) {
                savepoint = this.connection.setSavepoint(callerInfo);
            }
            if (this.reuseStmt) {
                if (this.query == null) {
                    this.query = this.connection.getSqlConnection().prepareStatement(this.schemaQuery);
                }
                this.setQueryTimeout(this.query);
                resultSet = this.query.executeQuery();
            } else {
                statement = this.connection.createStatement();
                this.setQueryTimeout(statement);
                resultSet = statement.executeQuery(this.schemaQuery);
            }
            if (resultSet != null && resultSet.next()) {
                string = resultSet.getString(1);
            }
            if (string != null) {
                string = string.trim();
            }
            this.connection.releaseSavepoint(savepoint, callerInfo);
        }
        catch (Exception exception) {
            try {
                this.connection.rollback(savepoint, callerInfo);
                LogMgr.logWarning(callerInfo, "Error reading current schema using query: " + this.schemaQuery, exception);
                string = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        if (this.isCacheable) {
            this.cachedSchema = string;
            LogMgr.logDebug(callerInfo, "Caching current schema: " + this.cachedSchema);
        } else {
            this.cachedSchema = null;
        }
        return string;
    }

    private void setQueryTimeout(Statement statement) {
        int n = this.getQueryTimeout();
        try {
            if (n > 0) {
                statement.setQueryTimeout(n);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not set query timeout to " + n + " Please adjust the value of the property: " + "currentschema.query", throwable);
        }
    }

    @Override
    public String getCachedSchema() {
        return this.cachedSchema;
    }

    @Override
    public void dispose() {
        JdbcUtils.closeStatement(this.query);
        this.cachedSchema = null;
        this.connection = null;
        Settings.getInstance().removePropertyChangeListener(this);
    }
}

