/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import workbench.db.CommentSqlManager;
import workbench.db.ConstraintDefinition;
import workbench.db.DbMetadata;
import workbench.db.GetMetaDataSql;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.db.IndexReader;
import workbench.db.JdbcUtils;
import workbench.db.PkDefinition;
import workbench.db.ReaderFactory;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.UniqueConstraintReader;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class JdbcIndexReader
implements IndexReader {
    public static final String KEY_INCLUDED_COLS = "include_columns";
    protected DbMetadata metaData;
    protected String pkIndexNameColumn;
    protected String pkStatusColumn;
    protected String partitionedFlagColumn;
    private static final String COL_NAME_STATUS = "STATUS";
    private static final String COL_NAME_TABLESPACE = "TABLESPACE";
    private UniqueConstraintReader uniqueConstraintReader;

    public JdbcIndexReader(DbMetadata dbMetadata) {
        this.metaData = dbMetadata;
        if (dbMetadata != null && dbMetadata.getWbConnection() != null) {
            this.uniqueConstraintReader = ReaderFactory.getUniqueConstraintReader(dbMetadata.getWbConnection());
        }
    }

    @Override
    public boolean supportsTableSpaces() {
        return false;
    }

    public boolean supportsIndexStatus() {
        return false;
    }

    public boolean supportsIndexComments() {
        return false;
    }

    @Override
    public void indexInfoProcessed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logDebug(new CallerInfo(){}, "Calling getIndexInfo() using: catalog=" + tableIdentifier.getCatalog() + ", schema=" + tableIdentifier.getSchema() + ", name=" + tableIdentifier.getTableName() + ", unique=" + bl + ", approximate=true");
        }
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        try {
            if (this.metaData.getDbSettings().useSavePointForDML()) {
                savepoint = this.metaData.getWbConnection().setSavepoint();
            }
            resultSet = this.metaData.getSqlConnection().getMetaData().getIndexInfo(tableIdentifier.getRawCatalog(), tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName(), bl, true);
            this.metaData.getWbConnection().releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.metaData.getWbConnection().rollback(savepoint);
                LogMgr.logWarning(new CallerInfo(){}, "Error calling DatabaseMetaData.getIndexInfo()", exception);
                this.metaData.getWbConnection().releaseSavepoint(savepoint);
            }
            catch (Throwable throwable) {
                this.metaData.getWbConnection().releaseSavepoint(savepoint);
                throw throwable;
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PkDefinition getPrimaryKey(TableIdentifier tableIdentifier) {
        CallerInfo callerInfo;
        PkDefinition pkDefinition;
        block16: {
            if (this.metaData.getDbSettings().isViewType(tableIdentifier.getType())) {
                return null;
            }
            if (this.metaData.isExtendedObject(tableIdentifier)) {
                return null;
            }
            String string = null;
            String string2 = null;
            pkDefinition = null;
            boolean bl = this.metaData.getDbSettings().useColumnNameForMetadata();
            callerInfo = new CallerInfo(){};
            if (!this.metaData.getDbSettings().supportsGetPrimaryKeys()) break block16;
            String string3 = tableIdentifier.getCatalog();
            String string4 = tableIdentifier.getSchema();
            ArrayList<IndexColumn> arrayList = new ArrayList<IndexColumn>();
            ResultSet resultSet = null;
            String string5 = null;
            long l = System.currentTimeMillis();
            Savepoint savepoint = null;
            try {
                if (this.metaData.getDbSettings().useSavePointForDML()) {
                    savepoint = this.metaData.getWbConnection().setSavepoint();
                }
                resultSet = this.getPrimaryKeyInfo(string3, string4, tableIdentifier.getRawTableName());
                while (resultSet.next()) {
                    int n;
                    if (string == null) {
                        String string6 = string = bl ? resultSet.getString("PK_NAME") : resultSet.getString(6);
                    }
                    if (this.pkIndexNameColumn != null && string2 == null) {
                        string2 = resultSet.getString(this.pkIndexNameColumn);
                    }
                    if (this.pkStatusColumn != null && string5 == null) {
                        string5 = resultSet.getString(this.pkStatusColumn);
                    }
                    String string7 = bl ? resultSet.getString("COLUMN_NAME") : resultSet.getString(4);
                    int n2 = n = bl ? resultSet.getInt("KEY_SEQ") : resultSet.getInt(5);
                    if (n < 1) {
                        LogMgr.logWarning(callerInfo, "Invalid column sequence '" + n + "' for key column " + tableIdentifier.getTableName() + "." + string7 + " received!");
                    }
                    arrayList.add(new IndexColumn(this.quoteIndexColumn(string7), n));
                }
                this.metaData.getWbConnection().releaseSavepoint(savepoint);
            }
            catch (Exception exception) {
                try {
                    this.metaData.getWbConnection().rollback(savepoint);
                    LogMgr.logWarning(callerInfo, "Error retrieving PK information", exception);
                    this.metaData.getWbConnection().releaseSavepoint(savepoint);
                }
                catch (Throwable throwable) {
                    this.metaData.getWbConnection().releaseSavepoint(savepoint);
                    JdbcUtils.closeResult(resultSet);
                    this.primaryKeysResultDone();
                    throw throwable;
                }
                JdbcUtils.closeResult(resultSet);
                this.primaryKeysResultDone();
            }
            JdbcUtils.closeResult(resultSet);
            this.primaryKeysResultDone();
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(callerInfo, "PK Information for " + tableIdentifier.getTableName() + ", PK Name=" + string + ", PK Index=" + string2 + ", columns=" + arrayList + " (" + l2 + "ms)");
            if (arrayList.size() > 0) {
                pkDefinition = new PkDefinition(this.getPkName(string, string2, tableIdentifier), arrayList);
                pkDefinition.setPkIndexName(string2);
                if (string5 != null) {
                    pkDefinition.setEnabled(this.isStatusEnabled(string5));
                }
            }
        }
        if (pkDefinition == null && this.metaData.getDbSettings().pkIndexHasTableName()) {
            LogMgr.logDebug(callerInfo, "No primary key returned from the driver, checking the unique indexes");
            pkDefinition = this.findPKFromIndexList(tableIdentifier);
        }
        tableIdentifier.setPkInitialized(true);
        if (pkDefinition != null && tableIdentifier.getPrimaryKey() == null) {
            tableIdentifier.setPrimaryKey(pkDefinition);
        }
        return pkDefinition;
    }

    protected String quoteIndexColumn(String string) {
        if (string == null) {
            return null;
        }
        if (this.metaData.getDbSettings().quoteIndexColumnNames()) {
            string = this.metaData.quoteObjectname(string);
        }
        return string;
    }

    protected Boolean isStatusEnabled(String string) {
        return null;
    }

    private PkDefinition findPKFromIndexList(TableIdentifier tableIdentifier) {
        List<IndexDefinition> list = this.getTableIndexList(tableIdentifier, true, false, false);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        for (IndexDefinition indexDefinition : list) {
            if (!indexDefinition.isPrimaryKeyIndex()) continue;
            LogMgr.logInfo(new CallerInfo(){}, "Using unique index " + indexDefinition.getObjectName() + " as a primary key");
            PkDefinition pkDefinition = new PkDefinition(indexDefinition.getObjectName(), indexDefinition.getColumns());
            pkDefinition.setPkIndexDefinition(indexDefinition);
            return pkDefinition;
        }
        return null;
    }

    private String getPkName(String string, String string2, TableIdentifier tableIdentifier) {
        if (string != null) {
            return string;
        }
        if (string2 != null) {
            return string2;
        }
        String string3 = "pk_" + SqlUtil.cleanupIdentifier(tableIdentifier.getRawTableName()).toLowerCase();
        LogMgr.logInfo(new CallerInfo(){}, "Using generated PK name " + string3 + " for " + tableIdentifier.getTableName());
        return string3;
    }

    protected void primaryKeysResultDone() {
    }

    protected ResultSet getPrimaryKeyInfo(String string, String string2, String string3) throws SQLException {
        return this.metaData.getJdbcMetaData().getPrimaryKeys(string, string2, string3);
    }

    @Override
    public StringBuilder getIndexSource(TableIdentifier tableIdentifier, List<IndexDefinition> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 100);
        for (IndexDefinition indexDefinition : list) {
            CharSequence charSequence;
            if (indexDefinition == null || indexDefinition.isPrimaryKeyIndex() || indexDefinition.isAutoGenerated() || (charSequence = this.getIndexSource(tableIdentifier, indexDefinition)) == null) continue;
            stringBuilder.append(charSequence);
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    protected String getUniqueConstraint(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        Boolean bl;
        String string = this.metaData.getDbSettings().getCreateUniqeConstraintSQL();
        String string2 = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier, this.metaData.getWbConnection());
        string2 = StringUtil.replace(string2, "%columnlist%", indexDefinition.getColumnList());
        string2 = StringUtil.replace(string2, "%constraint_name%", this.metaData.quoteObjectname(indexDefinition.getUniqueConstraintName()));
        ConstraintDefinition constraintDefinition = indexDefinition.getUniqueConstraint();
        Boolean bl2 = constraintDefinition == null ? Boolean.FALSE : constraintDefinition.isInitiallyDeferred();
        Boolean bl3 = bl = constraintDefinition == null ? Boolean.FALSE : constraintDefinition.isDeferrable();
        if (bl == null) {
            string2 = StringUtil.replace(string2, "%deferrable%", "");
            string2 = StringUtil.replace(string2, "%deferred%", "");
        } else if (Boolean.TRUE.equals(bl)) {
            string2 = StringUtil.replace(string2, "%deferrable%", "DEFERRABLE");
            string2 = Boolean.TRUE.equals(bl2) ? StringUtil.replace(string2, "%deferred%", "INITIALLY DEFERRED") : StringUtil.replace(string2, "%deferred%", "INITIALLY IMMEDIATE");
        } else {
            string2 = StringUtil.replace(string2, "%deferrable%", "");
            string2 = StringUtil.replace(string2, "%deferred%", "");
        }
        string2 = string2.trim();
        if (constraintDefinition != null) {
            String string3 = this.metaData.getDbSettings().getDisabledConstraintKeyword();
            String string4 = this.metaData.getDbSettings().getNoValidateConstraintKeyword();
            string2 = TemplateHandler.replacePlaceholder(string2, "%enabled%", constraintDefinition.isEnabled() ? "" : string3, true);
            string2 = TemplateHandler.replacePlaceholder(string2, "%validated%", constraintDefinition.isValid() != false ? "" : string4, true);
            if (this.metaData.isOracle() && !constraintDefinition.getConstraintName().equals(indexDefinition.getName())) {
                string2 = string2 + "\n   USING INDEX ";
                string2 = string2 + indexDefinition.getObjectExpression(this.metaData.getWbConnection());
            }
        }
        if (!string2.endsWith(";")) {
            string2 = string2 + ";";
        }
        string2 = string2 + "\n";
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNativeIndexSource(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        String string = this.metaData.getDbSettings().getRetrieveIndexSourceSql();
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(250);
        int n = this.metaData.getDbSettings().getRetrieveIndexSourceCol();
        boolean bl = this.metaData.getDbSettings().getRetrieveObjectSourceNeedsQuotes(tableIdentifier.getType());
        WbConnection wbConnection = this.metaData.getWbConnection();
        string = TableSourceBuilder.replacePlaceHolder(string, "%schema%", indexDefinition.getSchema(), bl, this.metaData);
        string = TableSourceBuilder.replacePlaceHolder(string, "%catalog%", indexDefinition.getCatalog(), bl, this.metaData);
        string = TableSourceBuilder.replacePlaceHolder(string, "%indexname%", indexDefinition.getName(), bl, this.metaData);
        string = TableSourceBuilder.replacePlaceHolder(string, "%fq_index_name%", indexDefinition.getFullyQualifiedName(wbConnection), false, this.metaData);
        string = TableSourceBuilder.replacePlaceHolder(string, "%table_expression%", tableIdentifier.getTableExpression(wbConnection), false, this.metaData);
        string = TableSourceBuilder.replacePlaceHolder(string, "%table_name%", tableIdentifier.getTableName(), bl, this.metaData);
        string = TableSourceBuilder.replacePlaceHolder(string, "%fq_table_name%", tableIdentifier.getFullyQualifiedName(wbConnection), false, this.metaData);
        LogMgr.logMetadataSql(new CallerInfo(){}, "index definition", string, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                stringBuilder.append(resultSet.getString(n));
            }
            stringBuilder.append('\n');
        }
        catch (Exception exception) {
            String string2;
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "index definition", string, new Object[0]);
                string2 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
            return string2;
        }
        JdbcUtils.closeAll(resultSet, statement);
        StringUtil.trimTrailingWhitespace(stringBuilder);
        if (stringBuilder.charAt(stringBuilder.length() - 1) != ';') {
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public CharSequence getIndexSource(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        if (indexDefinition == null) {
            return null;
        }
        String string = this.getNativeIndexSource(tableIdentifier, indexDefinition);
        if (string != null) {
            return string;
        }
        String string2 = null;
        if (indexDefinition.isUniqueConstraint()) {
            string2 = this.getUniqueConstraint(tableIdentifier, indexDefinition);
            if (indexDefinition.getUniqueConstraintName().equals(indexDefinition.getName())) {
                return string2;
            }
        }
        StringBuilder stringBuilder = this.processCreateIndexTemplate(tableIdentifier, indexDefinition);
        if (string2 != null) {
            stringBuilder.append('\n');
            stringBuilder.append(string2);
        }
        return stringBuilder;
    }

    protected StringBuilder processCreateIndexTemplate(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        StringBuilder stringBuilder = new StringBuilder(100);
        String string = this.metaData.getDbSettings().getCreateIndexSQL();
        String string2 = indexDefinition.getIndexType();
        string2 = this.getSQLKeywordForType(string2);
        String string3 = this.getIndexOptions(tableIdentifier, indexDefinition);
        WbConnection wbConnection = this.metaData.getWbConnection();
        String string4 = string;
        string4 = StringUtil.replace(string4, "%fq_table_name%", tableIdentifier.getFullyQualifiedName(wbConnection));
        string4 = StringUtil.replace(string4, "%table_expression%", tableIdentifier.getTableExpression(wbConnection));
        string4 = StringUtil.replace(string4, "%table_name%", tableIdentifier.getTableName());
        if (indexDefinition.isUnique()) {
            string4 = StringUtil.replace(string4, "%unique_key%", "UNIQUE");
            if ("unique".equalsIgnoreCase(string2)) {
                string2 = "";
            }
        } else {
            string4 = TemplateHandler.removePlaceholder(string4, "%unique_key%", true);
        }
        string4 = StringUtil.isEmptyString(string2) ? TemplateHandler.removePlaceholder(string4, "%indextype%", true) : TemplateHandler.replacePlaceholder(string4, "%indextype%", string2, true);
        String string5 = indexDefinition.getExpression(wbConnection);
        string4 = indexDefinition.isNonStandardExpression() ? StringUtil.replace(string4, "(%columnlist%)", string5) : TemplateHandler.replacePlaceholder(string4, "%columnlist%", string5, true);
        string4 = !StringUtil.equalStringIgnoreCase("ASC", indexDefinition.getDirection()) ? StringUtil.replace(string4, "%idx_dir%", indexDefinition.getDirection()) : TemplateHandler.removePlaceholder(string4, "%idx_dir%", true);
        string4 = StringUtil.replace(string4, "%fq_index_name%", indexDefinition.getObjectExpression(this.metaData.getWbConnection()));
        string4 = StringUtil.replace(string4, "%indexname%", indexDefinition.getObjectName());
        stringBuilder.append(string4);
        if (StringUtil.isNonBlank(string3)) {
            stringBuilder.append(string3);
        }
        stringBuilder.append(";\n");
        CommentSqlManager commentSqlManager = new CommentSqlManager(this.metaData.getDbId());
        String string6 = commentSqlManager.getCommentSqlTemplate("INDEX", null);
        if (StringUtil.isNonBlank(indexDefinition.getComment()) && string6 != null) {
            string6 = StringUtil.replace(string6, "%fq_index_name%", indexDefinition.getObjectExpression(this.metaData.getWbConnection()));
            string6 = StringUtil.replace(string6, "%indexname%", indexDefinition.getObjectName());
            string6 = string6.replace("%comment%", indexDefinition.getComment());
            stringBuilder.append(string6);
            stringBuilder.append(";\n");
        }
        return stringBuilder;
    }

    @Override
    public String getIndexOptions(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        return null;
    }

    public String getSQLKeywordForType(String string) {
        if (string == null || string.startsWith("NORMAL") || "IOT - TOP".equals(string)) {
            return "";
        }
        return string;
    }

    @Override
    public String buildCreateIndexSql(TableIdentifier tableIdentifier, String string, boolean bl, List<IndexColumn> list) {
        if (list == null) {
            return "";
        }
        int n = list.size();
        if (n == 0) {
            return "";
        }
        String string2 = this.metaData.getDbSettings().getCreateIndexSQL();
        StringBuilder stringBuilder = new StringBuilder(n * 25);
        for (int i = 0; i < n; ++i) {
            IndexColumn indexColumn = list.get(i);
            if (indexColumn == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(indexColumn.getExpression());
        }
        String string3 = StringUtil.replace(string2, "%table_name%", tableIdentifier.getTableName());
        string3 = string3.replace("%table_expression%", tableIdentifier.getTableExpression(this.metaData.getWbConnection()));
        string3 = string3.replace("%fq_table_name%", tableIdentifier.getFullyQualifiedName(this.metaData.getWbConnection()));
        string3 = TemplateHandler.removePlaceholder(string3, "%indextype%", true);
        string3 = bl ? TemplateHandler.replacePlaceholder(string3, "%unique_key%", "UNIQUE", true) : TemplateHandler.removePlaceholder(string3, "%unique_key%", true);
        string3 = StringUtil.replace(string3, "%columnlist%", stringBuilder.toString());
        string3 = StringUtil.replace(string3, "%indexname%", string);
        string3 = StringUtil.replace(string3, "%fq_index_name%", string);
        return string3;
    }

    @Override
    public void processIndexList(Collection<IndexDefinition> collection) {
    }

    private DataStore createIndexListDataStore(boolean bl) {
        List<String> list = CollectionUtil.arrayList("INDEX_NAME", "UNIQUE", "PK", "DEFINITION", "TYPE");
        List<Integer> list2 = CollectionUtil.arrayList(12, 12, 12, 12, 12);
        List<Integer> list3 = CollectionUtil.arrayList(30, 7, 6, 40, 10, 15);
        if (this.supportsTableSpaces()) {
            list.add(COL_NAME_TABLESPACE);
            list2.add(12);
            list3.add(15);
        }
        if (this.supportsIndexStatus()) {
            list.add(COL_NAME_STATUS);
            list2.add(12);
            list3.add(15);
        }
        if (this.supportsIndexComments()) {
            list.add("REMARKS");
            list2.add(12);
            list3.add(15);
        }
        if (bl) {
            list.add(0, "TABLE_SCHEMA");
            list2.add(0, 12);
            list3.add(0, 30);
            list.add(1, "TABLENAME");
            list2.add(1, 12);
            list3.add(1, 30);
        }
        String[] stringArray = new String[list.size()];
        stringArray = list.toArray(stringArray);
        int[] nArray = new int[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            nArray[i] = list2.get(i);
        }
        int[] nArray2 = new int[list3.size()];
        for (int i = 0; i < list3.size(); ++i) {
            nArray2[i] = list3.get(i);
        }
        return new DataStore(stringArray, nArray, nArray2);
    }

    @Override
    public DataStore getTableIndexInformation(TableIdentifier tableIdentifier) {
        List<IndexDefinition> list = this.getTableIndexList(tableIdentifier, false);
        return this.fillDataStore(list, false);
    }

    @Override
    public DataStore fillDataStore(Collection<IndexDefinition> collection, boolean bl) {
        DataStore dataStore = this.createIndexListDataStore(bl);
        int n = bl ? 2 : 0;
        int n2 = dataStore.getColumnIndex(COL_NAME_STATUS);
        int n3 = dataStore.getColumnIndex(COL_NAME_TABLESPACE);
        int n4 = dataStore.getColumnIndex("REMARKS");
        for (IndexDefinition indexDefinition : collection) {
            int n5 = dataStore.addRow();
            if (bl) {
                dataStore.setValue(n5, 0, (Object)indexDefinition.getBaseTable().getSchema());
                dataStore.setValue(n5, 1, (Object)indexDefinition.getBaseTable().getTableName());
            }
            dataStore.setValue(n5, n + 0, (Object)indexDefinition.getName());
            dataStore.setValue(n5, n + 1, (Object)(indexDefinition.isUnique() ? "YES" : "NO"));
            dataStore.setValue(n5, n + 2, (Object)(indexDefinition.isPrimaryKeyIndex() ? "YES" : "NO"));
            dataStore.setValue(n5, n + 3, (Object)indexDefinition.getExpression());
            dataStore.setValue(n5, n + 4, (Object)indexDefinition.getIndexType());
            if (n3 > -1) {
                dataStore.setValue(n5, n3, (Object)indexDefinition.getTablespace());
            }
            if (n2 > -1) {
                dataStore.setValue(n5, n2, (Object)indexDefinition.getStatus());
            }
            if (n4 > -1) {
                dataStore.setValue(n5, n4, (Object)indexDefinition.getComment());
            }
            dataStore.getRow(n5).setUserObject(indexDefinition);
        }
        SortDefinition sortDefinition = new SortDefinition(new int[]{0, 1}, new boolean[]{true, true});
        dataStore.sort(sortDefinition);
        dataStore.resetStatus();
        return dataStore;
    }

    @Override
    public List<IndexDefinition> getTableIndexList(TableIdentifier tableIdentifier, boolean bl) {
        return this.getTableIndexList(tableIdentifier, false, true, bl);
    }

    @Override
    public List<IndexDefinition> getUniqueIndexes(TableIdentifier tableIdentifier) {
        return this.getTableIndexList(tableIdentifier, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IndexDefinition> getTableIndexList(TableIdentifier tableIdentifier, boolean bl, boolean bl2, boolean bl3) {
        if (tableIdentifier == null) {
            return new ArrayList<IndexDefinition>();
        }
        ResultSet resultSet = null;
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        WbConnection wbConnection = this.metaData.getWbConnection();
        tableIdentifier2.adjustCase(wbConnection);
        ArrayList<IndexDefinition> arrayList = null;
        Savepoint savepoint = null;
        try {
            PkDefinition pkDefinition;
            if (this.metaData.getDbSettings().useSavePointForDML()) {
                savepoint = wbConnection.setSavepoint();
            }
            if ((pkDefinition = tableIdentifier2.getPrimaryKey()) == null && bl2 && !tableIdentifier2.isPkInitialized()) {
                pkDefinition = this.getPrimaryKey(tableIdentifier2);
            }
            long l = System.currentTimeMillis();
            resultSet = this.getIndexInfo(tableIdentifier2, bl);
            arrayList = this.processIndexResult(resultSet, pkDefinition, tableIdentifier2);
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, "Retrieving index information for table " + tableIdentifier.getTableExpression() + " took: " + l2 + "ms");
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve indexes", exception);
                arrayList = new ArrayList(0);
                wbConnection.releaseSavepoint(savepoint);
            }
            catch (Throwable throwable) {
                wbConnection.releaseSavepoint(savepoint);
                JdbcUtils.closeResult(resultSet);
                this.indexInfoProcessed();
                throw throwable;
            }
            JdbcUtils.closeResult(resultSet);
            this.indexInfoProcessed();
        }
        JdbcUtils.closeResult(resultSet);
        this.indexInfoProcessed();
        if (bl3 && this.uniqueConstraintReader != null) {
            this.uniqueConstraintReader.readUniqueConstraints(tableIdentifier2, arrayList, this.metaData.getWbConnection());
        }
        return arrayList;
    }

    private boolean isSameTable(TableIdentifier tableIdentifier, String string, String string2, String string3) {
        if (tableIdentifier == null) {
            return string3 == null;
        }
        if (StringUtil.stringsAreNotEqual(string3, tableIdentifier.getRawTableName())) {
            return false;
        }
        if (tableIdentifier.getCatalog() != null && string != null && StringUtil.stringsAreNotEqual(string, tableIdentifier.getRawCatalog())) {
            return false;
        }
        return tableIdentifier.getSchema() == null || string2 == null || !StringUtil.stringsAreNotEqual(string2, tableIdentifier.getRawSchema());
    }

    protected List<IndexDefinition> processIndexResult(ResultSet resultSet, PkDefinition pkDefinition, TableIdentifier tableIdentifier) throws SQLException {
        Object object;
        Object object2;
        HashMap<String, IndexDefinition> hashMap = new HashMap<String, IndexDefinition>();
        boolean bl = this.metaData.getDbSettings().supportsSortedIndex();
        boolean bl2 = this.metaData.getDbSettings().ignoreIndexColumnWithOrdinalZero();
        boolean bl3 = false;
        boolean bl4 = this.metaData.getDbSettings().useColumnNameForMetadata();
        boolean bl5 = this.metaData.getDbSettings().checkIndexTable();
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        if (resultSet != null && Settings.getInstance().getDebugMetadataSql()) {
            SqlUtil.dumpResultSetInfo("DatabaseMetaData.processIndexResult()", resultSet.getMetaData());
        }
        CallerInfo callerInfo = new CallerInfo(){};
        while (resultSet != null && resultSet.next()) {
            IndexDefinition indexDefinition;
            String string;
            int n;
            object2 = bl4 ? resultSet.getString("TABLE_CAT") : resultSet.getString(1);
            String string2 = bl4 ? resultSet.getString("TABLE_SCHEM") : resultSet.getString(2);
            object = bl4 ? resultSet.getString("TABLE_NAME") : resultSet.getString(3);
            boolean bl6 = bl4 ? resultSet.getBoolean("NON_UNIQUE") : resultSet.getBoolean(4);
            String string3 = bl4 ? resultSet.getString("INDEX_NAME") : resultSet.getString(6);
            if (set.contains(string3)) continue;
            if (bl5 && !this.isSameTable(tableIdentifier, (String)object2, string2, (String)object)) {
                set.add(string3);
                TableIdentifier tableIdentifier2 = new TableIdentifier((String)object2, string2, (String)object);
                LogMgr.logInfo(callerInfo, "Ignoring index " + string3 + " because it belongs to " + tableIdentifier2.getFullyQualifiedName(this.metaData.getWbConnection()) + " and not to " + tableIdentifier.getFullyQualifiedName(this.metaData.getWbConnection()));
                continue;
            }
            if (resultSet.wasNull() || string3 == null) continue;
            int n2 = n = bl4 ? resultSet.getInt("ORDINAL_POSITION") : resultSet.getInt(8);
            if (resultSet.wasNull()) {
                n = -1;
            }
            String string4 = string = bl4 ? resultSet.getString("COLUMN_NAME") : resultSet.getString(9);
            if (bl2 && n < 1) {
                LogMgr.logDebug(callerInfo, "Ignoring column " + string + " for index " + string3 + " because ordinal_position was: " + n);
                continue;
            }
            String string5 = null;
            if (bl) {
                String string6 = string5 = bl4 ? resultSet.getString("ASC_OR_DESC") : resultSet.getString(10);
            }
            if ((indexDefinition = (IndexDefinition)hashMap.get(string3)) == null) {
                if (this.partitionedFlagColumn != null) {
                    bl3 = StringUtil.stringToBool(StringUtil.trim(resultSet.getString(this.partitionedFlagColumn)));
                }
                indexDefinition = new IndexDefinition(tableIdentifier, string3);
                indexDefinition.setUnique(!bl6);
                indexDefinition.setPartitioned(bl3);
                if (this.metaData.getDbSettings().pkIndexHasTableName()) {
                    indexDefinition.setPrimaryKeyIndex(string3.equals(tableIdentifier.getRawTableName()));
                }
                hashMap.put(string3, indexDefinition);
                int n3 = resultSet.getMetaData().getColumnType(7);
                if (n3 == 12) {
                    String string7 = resultSet.getString("TYPE");
                    int n4 = StringUtil.getIntValue(string7, Integer.MIN_VALUE);
                    if (n4 != Integer.MIN_VALUE) {
                        indexDefinition.setIndexType(this.metaData.getDbSettings().mapIndexType(n3));
                    } else {
                        indexDefinition.setIndexType(string7);
                    }
                } else if (SqlUtil.isNumberType(n3)) {
                    int n5;
                    int n6 = n5 = bl4 ? resultSet.getInt("TYPE") : resultSet.getInt(7);
                    if (!resultSet.wasNull()) {
                        indexDefinition.setIndexType(this.metaData.getDbSettings().mapIndexType(n5));
                    }
                }
            }
            indexDefinition.addColumn(this.quoteIndexColumn(string), string5);
            this.processIndexResultRow(resultSet, indexDefinition, tableIdentifier);
        }
        object2 = hashMap.values();
        boolean bl7 = false;
        if (pkDefinition != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                boolean bl8;
                IndexDefinition indexDefinition = (IndexDefinition)object.next();
                if (indexDefinition.isPrimaryKeyIndex() || !(bl8 = indexDefinition.getName().equals(pkDefinition.getPkIndexName()))) continue;
                indexDefinition.setPrimaryKeyIndex(true);
                bl7 = true;
                break;
            }
        }
        if (!bl7) {
            object = object2.iterator();
            while (object.hasNext()) {
                IndexDefinition indexDefinition = (IndexDefinition)object.next();
                if (indexDefinition.isPrimaryKeyIndex()) continue;
                boolean bl9 = this.isPkIndex(indexDefinition, pkDefinition);
                indexDefinition.setPrimaryKeyIndex(bl9);
                if (bl9 && pkDefinition != null) {
                    pkDefinition.setPkIndexDefinition(indexDefinition);
                }
                if (!bl9) continue;
                break;
            }
        }
        this.processIndexList((Collection<IndexDefinition>)object2);
        return new ArrayList<IndexDefinition>((Collection<IndexDefinition>)object2);
    }

    protected void processIndexResultRow(ResultSet resultSet, IndexDefinition indexDefinition, TableIdentifier tableIdentifier) throws SQLException {
    }

    private boolean isPkIndex(IndexDefinition indexDefinition, PkDefinition pkDefinition) {
        if (indexDefinition == null || pkDefinition == null) {
            return false;
        }
        if (indexDefinition.getName().equals(pkDefinition.getPkIndexName())) {
            return true;
        }
        List<IndexColumn> list = indexDefinition.getColumns();
        List<String> list2 = pkDefinition.getColumns();
        int n = list2.size();
        if (list.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (list.get(i).getColumn().equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected IndexDefinition findIndexByName(Collection<IndexDefinition> collection, String string) {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        for (IndexDefinition indexDefinition : collection) {
            if (indexDefinition == null || !indexDefinition.getName().equalsIgnoreCase(string)) continue;
            return indexDefinition;
        }
        return null;
    }

    @Override
    public boolean supportsIndexList() {
        GetMetaDataSql getMetaDataSql = this.metaData.getMetaDataSQLMgr().getListIndexesSql();
        return getMetaDataSql != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IndexDefinition> getIndexes(String string, String string2, String string3, String string4) {
        GetMetaDataSql getMetaDataSql = this.metaData.getMetaDataSQLMgr().getListIndexesSql();
        if (getMetaDataSql == null) {
            return Collections.emptyList();
        }
        string = DbMetadata.cleanupWildcards(this.metaData.adjustSchemaNameCase(string));
        string2 = DbMetadata.cleanupWildcards(this.metaData.adjustSchemaNameCase(string2));
        string3 = DbMetadata.cleanupWildcards(this.metaData.adjustObjectnameCase(string3));
        string4 = DbMetadata.cleanupWildcards(this.metaData.adjustObjectnameCase(string4));
        getMetaDataSql.setCatalog(string);
        getMetaDataSql.setSchema(string2);
        getMetaDataSql.setBaseObjectName(string3);
        getMetaDataSql.setObjectName(string4);
        String string5 = getMetaDataSql.getSql();
        LogMgr.logMetadataSql(new CallerInfo(){}, "index list", string5, new Object[0]);
        ArrayList<IndexDefinition> arrayList = new ArrayList<IndexDefinition>();
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = this.supportsIndexStatus();
        Savepoint savepoint = null;
        try {
            if (this.metaData.getDbSettings().useSavePointForDML()) {
                savepoint = this.metaData.getWbConnection().setSavepoint();
            }
            statement = this.metaData.getWbConnection().createStatementForQuery();
            resultSet = statement.executeQuery(string5);
            while (resultSet.next()) {
                String string6 = StringUtil.rtrim(resultSet.getString("index_name"));
                String string7 = StringUtil.rtrim(resultSet.getString("index_schema"));
                String string8 = StringUtil.rtrim(resultSet.getString("table_name"));
                String string9 = StringUtil.rtrim(resultSet.getString("table_schema"));
                String string10 = StringUtil.rtrim(resultSet.getString("table_catalog"));
                String string11 = StringUtil.rtrim(resultSet.getString("index_type"));
                String string12 = StringUtil.rtrim(resultSet.getString("is_unique"));
                String string13 = StringUtil.rtrim(resultSet.getString("is_pk"));
                String string14 = resultSet.getString("index_def");
                String string15 = resultSet.getString("index_tablespace");
                String string16 = bl ? resultSet.getString("index_status") : null;
                TableIdentifier tableIdentifier = new TableIdentifier(string10, string9, string8);
                IndexDefinition indexDefinition = new IndexDefinition(tableIdentifier, string6.trim());
                indexDefinition.setSchema(string7);
                indexDefinition.setIndexType(string11);
                indexDefinition.setTablespace(string15);
                indexDefinition.setStatus(string16);
                if (string12 != null) {
                    indexDefinition.setUnique(StringUtil.stringToBool(string12));
                }
                if (string13 != null) {
                    indexDefinition.setPrimaryKeyIndex(StringUtil.stringToBool(string13));
                }
                if (string14 != null) {
                    string14 = StringUtil.removeBrackets(string14);
                    List<String> list = StringUtil.stringToList(string14, ",", true, true, false, true);
                    for (String string17 : list) {
                        indexDefinition.addColumn(string17, null);
                    }
                }
                arrayList.add(indexDefinition);
            }
            this.metaData.getWbConnection().releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.metaData.getWbConnection().rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "index list", string5, new Object[0]);
                this.metaData.getWbConnection().releaseSavepoint(savepoint);
            }
            catch (Throwable throwable) {
                this.metaData.getWbConnection().releaseSavepoint(savepoint);
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        this.processIndexList(arrayList);
        arrayList.sort(IndexDefinition.getNameSorter());
        return arrayList;
    }
}

