/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.sql.Statement;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class KeepAliveDaemon
implements Runnable {
    private long idleTime;
    private WbThread idleThread;
    private boolean stopThread;
    private WbConnection dbConnection;
    private String sqlScript;
    private volatile long lastAction;

    public KeepAliveDaemon(long l, WbConnection wbConnection, String string) {
        this.idleTime = l;
        this.dbConnection = wbConnection;
        this.sqlScript = SqlUtil.trimSemicolon(string);
    }

    public void startThread() {
        if (this.idleThread != null) {
            LogMgr.logWarning(new CallerInfo(){}, "startThread() called on already running daemon", new Exception("Backtrace"));
            return;
        }
        LogMgr.logInfo(new CallerInfo(){}, "Initializing keep alive every " + KeepAliveDaemon.getTimeDisplay(this.idleTime) + " with sql: " + this.sqlScript);
        this.idleThread = new WbThread(this, "KeepAlive/" + this.dbConnection.getId());
        this.idleThread.setPriority(1);
        this.lastAction = 0L;
        this.stopThread = false;
        this.idleThread.start();
    }

    public void shutdown() {
        if (this.idleThread != null) {
            try {
                this.stopThread = true;
                this.dbConnection = null;
                this.idleThread.interrupt();
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Error when stopping thread", exception);
            }
        }
    }

    public void setLastDbAction(long l) {
        this.lastAction = l;
    }

    @Override
    public void run() {
        while (!this.stopThread) {
            long l;
            block5: {
                if (this.dbConnection == null) {
                    this.stopThread = true;
                    break;
                }
                l = System.currentTimeMillis();
                try {
                    long l2 = this.idleTime - (l - this.lastAction);
                    if (l2 <= 0L) {
                        l2 = this.idleTime;
                    }
                    LogMgr.logDebug(new CallerInfo(){}, Thread.currentThread().getName() + ": sleeping for " + l2 + "ms");
                    Thread.sleep(this.idleTime);
                }
                catch (InterruptedException interruptedException) {
                    if (this.stopThread) break block5;
                    LogMgr.logError(new CallerInfo(){}, Thread.currentThread().getName() + ": Thread was interrupted!", interruptedException);
                }
            }
            if (this.stopThread) break;
            l = System.currentTimeMillis();
            if (l - this.lastAction <= this.idleTime) continue;
            this.runSqlScript();
            this.lastAction = l;
        }
    }

    public static long parseTimeInterval(String string) {
        if (StringUtil.isBlank(string)) {
            return 0L;
        }
        long l = 0L;
        if ((string = string.trim()).endsWith("s")) {
            string = string.substring(0, string.length() - 1);
            l = StringUtil.getLongValue(string, 0L) * 1000L;
        } else if (string.endsWith("m")) {
            string = string.substring(0, string.length() - 1);
            l = StringUtil.getLongValue(string, 0L) * 1000L * 60L;
        } else if (string.endsWith("h")) {
            string = string.substring(0, string.length() - 1);
            l = StringUtil.getLongValue(string, 0L) * 1000L * 60L * 60L;
        } else {
            l = StringUtil.getLongValue(string, 0L);
        }
        return l;
    }

    public static String getTimeDisplay(long l) {
        if (l == 0L) {
            return "";
        }
        if (l < 60000L) {
            return Long.toString(l / 1000L) + "s";
        }
        return Long.toString(l / 60000L) + "m";
    }

    private void runSqlScript() {
        if (this.dbConnection == null) {
            return;
        }
        if (this.dbConnection.isBusy()) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.dbConnection.createStatement();
            LogMgr.logInfo(new CallerInfo(){}, Thread.currentThread().getName() + " - executing SQL: " + this.sqlScript);
            statement.execute(this.sqlScript);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, Thread.currentThread().getName() + ": SQL Error when running keep alive script: " + ExceptionUtil.getDisplay(sQLException), null);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when running keep alive script", throwable);
        }
        finally {
            JdbcUtils.closeStatement(statement);
        }
    }
}

