/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ObjectNameFilter
implements Serializable {
    public static final String PARAM_CURRENT_USER = "${current_user}";
    public static final String PARAM_CURRENT_SCHEMA = "${current_schema}";
    public static final String PARAM_CURRENT_CATALOG = "${current_catalog}";
    private static final Set<String> PARAMETERS = CollectionUtil.caseInsensitiveSet("${current_user}", "${current_schema}", "${current_catalog}");
    private Map<String, String> variables = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
    private final Set<Pattern> filterPatterns = new HashSet<Pattern>();
    private final Set<String> patternSource = CollectionUtil.caseInsensitiveSet();
    private boolean modified;
    private boolean inclusionFilter;
    private boolean isRetrievalFilter;

    public boolean isRetrievalFilter() {
        return this.isRetrievalFilter;
    }

    public void setIsRetrievalFilter(boolean bl) {
        this.modified = bl != this.isRetrievalFilter;
        this.isRetrievalFilter = bl;
    }

    public void setInclusionFilter(boolean bl) {
        this.modified = bl != this.inclusionFilter;
        this.inclusionFilter = bl;
    }

    public boolean isInclusionFilter() {
        return this.inclusionFilter;
    }

    public void setFilterExpressions(Collection<String> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        this.patternSource.clear();
        this.filterPatterns.clear();
        for (String string : collection) {
            String string2 = StringUtil.trim(string);
            if (!StringUtil.isNonBlank(string2)) continue;
            this.patternSource.add(string2);
        }
        for (String string : collection) {
            this.addExpression(string);
        }
        this.modified = false;
    }

    private boolean usesVariables() {
        if (CollectionUtil.isEmpty(this.patternSource)) {
            return false;
        }
        for (String string : this.patternSource) {
            if (!PARAMETERS.contains(string)) continue;
            return true;
        }
        return false;
    }

    public void setReplacements(Map<String, String> map) {
        if (CollectionUtil.isEmpty(map)) {
            return;
        }
        if (!this.usesVariables()) {
            return;
        }
        this.filterPatterns.clear();
        this.variables = new HashMap<String, String>(map);
        Iterator<String> iterator = this.patternSource.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            if (PARAMETERS.contains(string)) {
                string2 = this.replaceVariable(map, string);
            }
            if (!StringUtil.isNonBlank(string2)) continue;
            this.addPattern(string2);
        }
    }

    private String replaceVariable(Map<String, String> map, String string) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return string;
    }

    public Collection<String> getFilterExpressions() {
        if (this.usesVariables() && this.isRetrievalFilter()) {
            ArrayList<String> arrayList = new ArrayList<String>(this.patternSource.size());
            Iterator<String> iterator = this.patternSource.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                if (this.variables != null && PARAMETERS.contains(string2)) {
                    string2 = this.replaceVariable(this.variables, string);
                }
                arrayList.add(string2);
            }
            return arrayList;
        }
        return Collections.unmodifiableCollection(this.patternSource);
    }

    public void resetModified() {
        this.modified = false;
    }

    public void removeExpressions() {
        this.modified = CollectionUtil.isNonEmpty(this.filterPatterns);
        this.patternSource.clear();
        this.filterPatterns.clear();
    }

    public void setExpressionList(String string) {
        List<String> list = StringUtil.stringToList(string, ";", true, true);
        this.setFilterExpressions(list);
    }

    public void addExpression(String string) {
        if (StringUtil.isBlank(string)) {
            return;
        }
        try {
            this.patternSource.add(string);
            if (!PARAMETERS.contains(string)) {
                this.addPattern(string);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            LogMgr.logError(new CallerInfo(){}, "Could not compile expression: " + string, patternSyntaxException);
        }
        this.modified = true;
    }

    private void addPattern(String string) {
        try {
            this.filterPatterns.add(Pattern.compile(string.trim(), 2));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not compile expression: " + string, patternSyntaxException);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isExcluded(String string) {
        if (string == null) {
            return this.inclusionFilter;
        }
        if (CollectionUtil.isEmpty(this.filterPatterns)) {
            return this.inclusionFilter;
        }
        for (Pattern pattern : this.filterPatterns) {
            if (!pattern.matcher(string).matches()) continue;
            return !this.inclusionFilter;
        }
        return this.inclusionFilter;
    }

    public int getSize() {
        return this.patternSource == null ? 0 : this.patternSource.size();
    }

    public ObjectNameFilter createCopy() {
        ObjectNameFilter objectNameFilter = new ObjectNameFilter();
        objectNameFilter.setFilterExpressions(this.patternSource);
        objectNameFilter.modified = this.modified;
        objectNameFilter.inclusionFilter = this.inclusionFilter;
        objectNameFilter.isRetrievalFilter = this.isRetrievalFilter;
        return objectNameFilter;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ObjectNameFilter objectNameFilter = (ObjectNameFilter)object;
        Collection<String> collection = this.getFilterExpressions();
        Collection<String> collection2 = objectNameFilter.getFilterExpressions();
        for (String string : collection) {
            if (collection2.contains(string)) continue;
            return false;
        }
        for (String string : collection2) {
            if (collection.contains(string)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 7 + this.filterPatterns.hashCode();
    }

    public void applyFilter(Collection<String> collection) {
        if (collection == null) {
            return;
        }
        collection.removeIf(string -> this.isExcluded((String)string));
    }

    public String getFilterString() {
        Collection<String> collection = this.getFilterExpressions();
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        String string = "";
        for (String string2 : collection) {
            if (string.length() > 0) {
                string = string + ";";
            }
            if (string2.indexOf(59) > -1) {
                string = string + "\"" + string2 + "\"";
                continue;
            }
            string = string + string2;
        }
        return string;
    }
}

