/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import workbench.db.DbObject;
import workbench.db.GenericObjectDropper;
import workbench.db.ProcedureDefinition;
import workbench.db.ReaderFactory;
import workbench.db.ScriptSection;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.SynonymReader;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.db.WbConnection;
import workbench.gui.dbobjects.ExplorerUtils;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.interfaces.Scripter;
import workbench.interfaces.TextOutput;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringBuilderOutput;
import workbench.util.StringUtil;

public class ObjectScripter
implements Scripter {
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_TYPE = "type";
    public static final String TYPE_RULE = "rule";
    public static final String TYPE_VIEW = "view";
    public static final String TYPE_SYNONYM = "synonym";
    public static final String TYPE_INSERT = "insert";
    public static final String TYPE_UPDATE = "update";
    public static final String TYPE_SELECT = "select";
    public static final String TYPE_PROC = "procedure";
    public static final String TYPE_PACKAGE = "package";
    public static final String TYPE_FUNC = "function";
    public static final String TYPE_TRG = "trigger";
    public static final String TYPE_DOMAIN = "domain";
    public static final String TYPE_ENUM = "enum";
    public static final String TYPE_MVIEW = "MATERIALIZED VIEW".toLowerCase();
    private List<? extends DbObject> objectList;
    private ScriptGenerationMonitor progressMonitor;
    private WbConnection dbConnection;
    private boolean cancel;
    private String nl = Settings.getInstance().getInternalEditorLineEnding();
    private Collection<String> commitTypes;
    private boolean commitNeeded;
    private boolean includeCommitIfNeeded = true;
    private boolean useSeparator;
    private boolean includeDrop;
    private boolean includeGrants = true;
    private boolean includeForeignKeys = true;
    private Collection<String> typesWithoutSeparator;
    private String sequenceType;
    private String synonymType = "synonym";
    private GenericObjectDropper dropper;
    private boolean extractPackageProcedure;
    private boolean needsAlternateDelimiter;
    private Set<String> additionalTableTypes = CollectionUtil.caseInsensitiveSet();
    private Set<String> additionalViewTypes = CollectionUtil.caseInsensitiveSet();
    private Set<String> typesToGenerate = CollectionUtil.caseInsensitiveSet();
    private Map<ScriptSection, List<String>> additionalSQL = new EnumMap<ScriptSection, List<String>>(ScriptSection.class);
    private int currentObject;
    private int totalObjects;
    private TextOutput output;
    private boolean endTransaction;
    private DelimiterDefinition delimiterToUse;

    public ObjectScripter(List<? extends DbObject> list, WbConnection wbConnection) {
        SynonymReader synonymReader;
        this.objectList = list;
        this.dbConnection = wbConnection;
        this.totalObjects = this.objectList.size();
        SequenceReader sequenceReader = wbConnection.getMetadata().getSequenceReader();
        if (sequenceReader != null) {
            this.sequenceType = sequenceReader.getSequenceTypeName();
        }
        if ((synonymReader = wbConnection.getMetadata().getSynonymReader()) != null) {
            this.synonymType = synonymReader.getSynonymTypeName();
        }
        this.additionalTableTypes.addAll(this.dbConnection.getMetadata().getTableTypes());
        this.additionalViewTypes.addAll(this.dbConnection.getDbSettings().getViewTypes());
        this.additionalViewTypes.remove(TYPE_VIEW);
        this.additionalTableTypes.remove(TYPE_TABLE);
        this.commitTypes = CollectionUtil.caseInsensitiveSet(TYPE_TABLE, TYPE_VIEW, TYPE_PACKAGE, TYPE_PROC, TYPE_FUNC, TYPE_TRG, TYPE_DOMAIN, TYPE_ENUM, TYPE_TYPE, TYPE_RULE);
        this.commitTypes.addAll(this.additionalTableTypes);
        if (this.sequenceType != null) {
            this.commitTypes.add(this.sequenceType.toLowerCase());
        }
        if (this.synonymType != null) {
            this.commitTypes.add(this.synonymType.toLowerCase());
        }
        this.useSeparator = DbExplorerSettings.getGenerateScriptSeparator();
        this.typesWithoutSeparator = CollectionUtil.caseInsensitiveSet(TYPE_SELECT, TYPE_INSERT, TYPE_UPDATE);
        this.dropper = new GenericObjectDropper();
        this.dropper.setConnection(this.dbConnection);
        this.dropper.setCascade(true);
        for (DbObject object2 : list) {
            this.typesToGenerate.add(object2.getObjectType());
        }
        Set<String> set = wbConnection.getDbSettings().getTypesRequiringAlternateDelimiter();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.typesToGenerate.contains(string)) continue;
            this.needsAlternateDelimiter = true;
            break;
        }
    }

    public void setDelimiterToUse(DelimiterDefinition delimiterDefinition) {
        this.delimiterToUse = delimiterDefinition;
    }

    public void setIncludeCommit(boolean bl) {
        this.includeCommitIfNeeded = bl;
    }

    @Override
    public WbConnection getCurrentConnection() {
        return this.dbConnection;
    }

    @Override
    public void setEndTransaction(boolean bl) {
        this.endTransaction = bl;
    }

    public void setIncludeForeignKeys(boolean bl) {
        this.includeForeignKeys = bl;
    }

    public void setIncludeGrants(boolean bl) {
        this.includeGrants = bl;
    }

    public void setIncludeDrop(boolean bl) {
        this.includeDrop = bl;
    }

    public void setUseSeparator(boolean bl) {
        this.useSeparator = bl;
    }

    @Override
    public void setProgressMonitor(ScriptGenerationMonitor scriptGenerationMonitor) {
        this.progressMonitor = scriptGenerationMonitor;
    }

    public String getScript() {
        this.output = new StringBuilderOutput(this.totalObjects * 50);
        this.generateScript();
        return this.output.toString();
    }

    @Override
    public void setTextOutput(TextOutput textOutput) {
        this.output = textOutput;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void generateScript() {
        try {
            this.currentObject = 1;
            this.dbConnection.setBusy(true);
            this.cancel = false;
            this.generateIfNeeded(this.sequenceType);
            this.generateIfNeeded(TYPE_ENUM);
            this.generateIfNeeded(TYPE_TYPE);
            this.generateIfNeeded(TYPE_DOMAIN);
            this.generateIfNeeded(TYPE_TABLE);
            for (String string : this.additionalTableTypes) {
                if (this.cancel) break;
                this.generateIfNeeded(string);
            }
            this.appendSectionSQL(ScriptSection.AfterAllTables);
            if (!this.cancel && this.includeForeignKeys) {
                this.generateForeignKeys();
            }
            this.generateIfNeeded(TYPE_VIEW);
            for (String string : this.additionalViewTypes) {
                if (this.cancel) break;
                this.generateIfNeeded(string);
            }
            this.generateIfNeeded(this.synonymType);
            this.generateIfNeeded(TYPE_MVIEW);
            this.generateIfNeeded(TYPE_INSERT);
            this.generateIfNeeded(TYPE_UPDATE);
            this.generateIfNeeded(TYPE_SELECT);
            this.generateIfNeeded(TYPE_FUNC);
            this.generateIfNeeded(TYPE_PROC);
            this.generateIfNeeded(TYPE_PACKAGE);
            this.generateIfNeeded(TYPE_TRG);
            this.generateIfNeeded(TYPE_RULE);
            for (String string : this.typesToGenerate) {
                if (this.cancel) {
                    break;
                }
                this.appendObjectType(string);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not generate script", exception);
        }
        finally {
            this.dbConnection.setBusy(false);
            if (this.endTransaction) {
                ExplorerUtils.endTransaction(this.dbConnection);
            }
        }
        if (this.includeCommitIfNeeded && this.commitNeeded && this.dbConnection.generateCommitForDDL()) {
            this.output.append(this.nl);
            this.output.append("COMMIT");
            Iterator<String> iterator = this.getDelimiter();
            this.output.append(((DelimiterDefinition)((Object)iterator)).getScriptText());
        }
    }

    private void appendSectionSQL(ScriptSection scriptSection) {
        List<String> list = this.additionalSQL.get((Object)scriptSection);
        if (list != null) {
            for (String string : list) {
                this.output.append(string);
                if (StringUtil.endsWith((CharSequence)string, this.nl)) continue;
                this.output.append(this.nl);
            }
            this.output.append(this.nl);
        }
    }

    private void generateIfNeeded(String string) {
        if (string == null) {
            return;
        }
        if (this.cancel) {
            return;
        }
        if (this.typesToGenerate.contains(string)) {
            this.appendObjectType(string);
            this.typesToGenerate.remove(string);
        }
    }

    private DelimiterDefinition getDelimiter() {
        if (this.delimiterToUse != null) {
            return this.delimiterToUse;
        }
        if (this.needsAlternateDelimiter) {
            return Settings.getInstance().getAlternateDelimiter(this.dbConnection, DelimiterDefinition.STANDARD_DELIMITER);
        }
        return DelimiterDefinition.STANDARD_DELIMITER;
    }

    public void setShowPackageProcedureOnly(boolean bl) {
        this.extractPackageProcedure = bl;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    private boolean isTable(DbObject dbObject) {
        return dbObject.getObjectType().equalsIgnoreCase(TYPE_TABLE) || this.additionalTableTypes.contains(dbObject.getObjectType());
    }

    public void generateForeignKeys() {
        List list = this.objectList.stream().filter(dbObject -> this.isTable((DbObject)dbObject)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return;
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.setCurrentObject(ResourceMgr.getString("TxtScriptProcessFk"), -1, -1);
        }
        if (this.useSeparator) {
            this.output.append("-- BEGIN FOREIGN KEYS --");
        }
        TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(this.dbConnection);
        for (DbObject dbObject2 : list) {
            if (this.cancel) break;
            TableIdentifier tableIdentifier = (TableIdentifier)dbObject2;
            tableIdentifier.adjustCase(this.dbConnection);
            StringBuilder stringBuilder = tableSourceBuilder.getFkSource(tableIdentifier);
            if (stringBuilder == null || stringBuilder.length() <= 0) continue;
            this.output.append(this.nl);
            this.output.append(stringBuilder);
        }
        if (this.useSeparator) {
            this.output.append("-- END FOREIGN KEYS --");
            this.output.append(this.nl);
        }
        this.output.append(this.nl);
    }

    private void appendObjectType(String string) {
        List list = this.objectList.stream().filter(dbObject -> dbObject.getObjectType().equalsIgnoreCase(string)).collect(Collectors.toList());
        SequenceReader sequenceReader = this.dbConnection.getMetadata().getSequenceReader();
        for (DbObject dbObject2 : list) {
            boolean bl;
            Object object;
            List<String> list2;
            if (this.cancel) break;
            String string2 = dbObject2.getObjectType();
            CharSequence charSequence = null;
            if (this.progressMonitor != null) {
                this.progressMonitor.setCurrentObject(dbObject2.getObjectName(), this.currentObject++, this.totalObjects);
            }
            boolean bl2 = true;
            try {
                if (dbObject2 instanceof TableIdentifier) {
                    if (this.dbConnection.getMetadata().isSequenceType(dbObject2.getObjectType())) {
                        SequenceDefinition sequenceDefinition = sequenceReader.getSequenceDefinition(dbObject2.getCatalog(), dbObject2.getSchema(), dbObject2.getObjectName());
                        charSequence = this.adjustDelimiter(sequenceReader.getSequenceSource(sequenceDefinition, false));
                        list2 = this.additionalSQL.get((Object)ScriptSection.AfterAllTables);
                        if (list2 == null) {
                            list2 = new ArrayList<String>();
                            this.additionalSQL.put(ScriptSection.AfterAllTables, list2);
                        }
                        list2.add(sequenceDefinition.getPostCreationSQL());
                    } else {
                        charSequence = this.adjustDelimiter(((TableIdentifier)dbObject2).getSource(this.dbConnection, false, this.includeGrants));
                    }
                } else {
                    charSequence = dbObject2.getSource(this.dbConnection);
                    if (dbObject2 instanceof ProcedureDefinition && this.extractPackageProcedure) {
                        ProcedureDefinition procedureDefinition = (ProcedureDefinition)dbObject2;
                        if (procedureDefinition.isPackageProcedure() && (object = (list2 = ReaderFactory.getProcedureReader(this.dbConnection.getMetadata())).getPackageProcedureSource(procedureDefinition)) != null) {
                            charSequence = object;
                            bl2 = false;
                        }
                    } else {
                        charSequence = this.adjustDelimiter(charSequence);
                    }
                }
                if (bl2) {
                    this.commitNeeded = this.commitNeeded || this.commitTypes.contains(string2.toLowerCase());
                }
            }
            catch (Exception exception) {
                this.output.append("\nError creating script for ");
                this.output.append(dbObject2.getObjectName());
                this.output.append(" ");
                this.output.append(ExceptionUtil.getDisplay(exception));
            }
            if (charSequence == null || charSequence.length() <= 0) continue;
            boolean bl3 = bl = this.useSeparator && !this.typesWithoutSeparator.contains(string2) && this.objectList.size() > 1;
            if (bl) {
                this.output.append("-- BEGIN " + string2 + " " + dbObject2.getObjectName() + this.nl);
            }
            if (this.includeDrop && (list2 = this.dropper.getDropForObject(dbObject2)) != null && list2.length() > 0) {
                this.output.append((CharSequence)((Object)list2));
                object = this.getDelimiter();
                if (!((DelimiterDefinition)object).terminatesScript(list2.toString(), false, '\"')) {
                    this.output.append(((DelimiterDefinition)object).getScriptText());
                }
                this.output.append(this.nl);
            }
            this.output.append(charSequence);
            if (!StringUtil.endsWith(charSequence, this.nl)) {
                this.output.append(this.nl);
            }
            if (bl) {
                this.output.append("-- END " + string2 + " " + dbObject2.getObjectName() + this.nl);
            }
            this.output.append(this.nl);
        }
    }

    private CharSequence adjustDelimiter(CharSequence charSequence) {
        if (charSequence == null) {
            return charSequence;
        }
        if (this.delimiterToUse == null) {
            return charSequence;
        }
        if (this.delimiterToUse.isStandard()) {
            return charSequence;
        }
        String string = SqlUtil.trimSemicolon(charSequence.toString());
        return string + this.delimiterToUse.getScriptText();
    }
}

