/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import workbench.db.DbObject;
import workbench.db.ProcedureDefinition;
import workbench.db.ProcedureReader;
import workbench.db.ReaderFactory;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;

public class PackageDefinition
implements DbObject,
Serializable {
    private String schema;
    private String packageName;
    private String remarks;

    public PackageDefinition(String string, String string2) {
        this.schema = string;
        this.packageName = string2;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getObjectType() {
        return "PACKAGE";
    }

    @Override
    public String getObjectName() {
        return this.packageName;
    }

    @Override
    public void setName(String string) {
        this.packageName = string;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, this);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, this);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        ProcedureReader procedureReader = ReaderFactory.getProcedureReader(wbConnection.getMetadata());
        return procedureReader.getPackageSource(this.getCatalog(), this.getSchema(), this.getObjectName());
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return this.remarks;
    }

    @Override
    public void setComment(String string) {
        this.remarks = string;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return "DROP PACKAGE " + this.getFullyQualifiedName(wbConnection);
    }

    public List<ProcedureDefinition> getProcedures() {
        return Collections.emptyList();
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

