/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.util.StringUtil;

public class PkDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<IndexColumn> columns = new ArrayList<IndexColumn>();
    private String pkName;
    private String pkIndexName;
    private boolean enabled = true;
    private IndexDefinition pkIndex;

    public PkDefinition(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            IndexColumn indexColumn = new IndexColumn(list.get(i), i);
            this.columns.add(indexColumn);
        }
    }

    public PkDefinition(String string, List<IndexColumn> list) {
        this.pkName = StringUtil.trim(string);
        if (list != null) {
            this.columns = new ArrayList<IndexColumn>(list);
        }
    }

    public IndexDefinition getPkIndexDefinition() {
        return this.pkIndex;
    }

    public void setPkIndexDefinition(IndexDefinition indexDefinition) {
        this.pkIndex = indexDefinition;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPkIndexName() {
        if (this.pkIndex != null) {
            return this.pkIndex.getName();
        }
        if (this.pkIndexName == null) {
            return this.pkName;
        }
        return this.pkIndexName;
    }

    public void setPkIndexName(String string) {
        this.pkIndexName = StringUtil.trim(string);
    }

    public void setPkName(String string) {
        this.pkName = string;
    }

    public String getPkName() {
        return this.pkName;
    }

    public List<String> getColumns() {
        if (this.columns == null) {
            return Collections.emptyList();
        }
        if (this.columns.size() > 1) {
            Collections.sort(this.columns, IndexColumn.getSequenceSorter());
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.columns.size());
        for (IndexColumn indexColumn : this.columns) {
            arrayList.add(indexColumn.getColumn());
        }
        return arrayList;
    }

    public void addColumn(IndexColumn indexColumn) {
        this.columns.add(indexColumn);
    }

    public PkDefinition createCopy() {
        PkDefinition pkDefinition = new PkDefinition(this.pkName, this.columns);
        pkDefinition.pkIndexName = this.pkIndexName;
        return pkDefinition;
    }

    public String toString() {
        if (this.pkName == null) {
            return this.columns.toString();
        }
        return this.pkName + ": " + this.columns;
    }
}

