/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.regex.Matcher;
import workbench.util.SqlUtil;

public interface QuoteHandler {
    public static final QuoteHandler STANDARD_HANDLER = new QuoteHandler(){

        @Override
        public boolean isQuoted(String string) {
            if (string == null) {
                return false;
            }
            if ((string = string.trim()).isEmpty()) {
                return false;
            }
            return string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
        }

        @Override
        public String removeQuotes(String string) {
            return SqlUtil.removeObjectQuotes(string);
        }

        @Override
        public String quoteObjectname(String string) {
            return SqlUtil.quoteObjectname(string, false, true, '\"');
        }

        @Override
        public String quoteObjectname(String string, boolean bl) {
            return SqlUtil.quoteObjectname(string, bl, true, '\"');
        }

        @Override
        public boolean isLegalIdentifier(String string) {
            Matcher matcher = SqlUtil.SQL_IDENTIFIER.matcher(string);
            return matcher.matches();
        }

        @Override
        public boolean needsQuotes(String string) {
            return !this.isLegalIdentifier(string);
        }
    };

    public boolean isQuoted(String var1);

    public String removeQuotes(String var1);

    public String quoteObjectname(String var1);

    public String quoteObjectname(String var1, boolean var2);

    public boolean needsQuotes(String var1);

    public boolean isLegalIdentifier(String var1);

    default public String getIdentifierQuoteCharacter() {
        return "\"";
    }
}

