/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import workbench.db.DbMetadata;
import workbench.db.DependencyNode;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ColumnData;
import workbench.storage.SqlLiteralFormatter;

public class ReferenceTableNavigation {
    private final TableIdentifier baseTable;
    private final WbConnection dbConn;
    private final SqlLiteralFormatter formatter;
    private TableDependency dependencyTree;

    public ReferenceTableNavigation(TableIdentifier tableIdentifier, WbConnection wbConnection) {
        this.baseTable = tableIdentifier;
        this.dbConn = wbConnection;
        this.formatter = new SqlLiteralFormatter(this.dbConn);
    }

    public void readTreeForChildren() {
        this.readDependencyTree(true);
    }

    public void readTreeForParents() {
        this.readDependencyTree(false);
    }

    protected void readDependencyTree(boolean bl) {
        this.dependencyTree = new TableDependency(this.dbConn, this.baseTable);
        this.dependencyTree.setRetrieveDirectChildrenOnly(true);
        if (bl) {
            this.dependencyTree.readTreeForChildren();
        } else {
            this.dependencyTree.readTreeForParents();
        }
    }

    public DependencyNode getNodeForTable(TableIdentifier tableIdentifier, String string) {
        if (this.dependencyTree == null) {
            return null;
        }
        if (tableIdentifier == null) {
            return null;
        }
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        tableIdentifier2.adjustCatalogAndSchema(this.dbConn);
        tableIdentifier2.adjustCase(this.dbConn);
        return this.dependencyTree.findLeafNodeForTable(tableIdentifier2, string);
    }

    public TableDependency getTree() {
        return this.dependencyTree;
    }

    public String getSelectForChild(TableIdentifier tableIdentifier, String string, List<List<ColumnData>> list) {
        return this.generateSelect(tableIdentifier, string, true, list);
    }

    public String getSelectForParent(TableIdentifier tableIdentifier, String string, List<List<ColumnData>> list) {
        return this.generateSelect(tableIdentifier, string, false, list);
    }

    private String generateSelect(TableIdentifier tableIdentifier, String string, boolean bl, List<List<ColumnData>> list) {
        String string2 = null;
        try {
            if (this.dependencyTree == null) {
                this.readDependencyTree(bl);
            }
            DependencyNode dependencyNode = this.getNodeForTable(tableIdentifier, string);
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("SELECT * \nFROM ");
            stringBuilder.append(dependencyNode.getTable().getTableExpression(this.dbConn));
            stringBuilder.append("\nWHERE ");
            this.addWhere(stringBuilder, dependencyNode, list);
            string2 = stringBuilder.toString();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving parent tables", exception);
        }
        return string2;
    }

    private void addWhere(StringBuilder stringBuilder, DependencyNode dependencyNode, List<List<ColumnData>> list) {
        Map<String, String> map = dependencyNode.getColumns();
        Iterator<List<ColumnData>> iterator = list.iterator();
        DbMetadata dbMetadata = this.dbConn.getMetadata();
        while (iterator.hasNext()) {
            List<ColumnData> list2 = iterator.next();
            stringBuilder.append('(');
            Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> entry = iterator2.next();
                String string = entry.getKey();
                String string2 = entry.getValue();
                ColumnData columnData = this.getPkValue(list2, string2);
                if (columnData == null) continue;
                stringBuilder.append(dbMetadata.quoteObjectname(string));
                if (columnData.isNull()) {
                    stringBuilder.append(" IS NULL");
                } else {
                    stringBuilder.append(" = ");
                    stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
                }
                if (!iterator2.hasNext()) continue;
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(')');
            if (!iterator.hasNext()) continue;
            stringBuilder.append("\n   OR ");
        }
    }

    private ColumnData getPkValue(List<ColumnData> list, String string) {
        for (ColumnData columnData : list) {
            if (!columnData.getIdentifier().getColumnName().equalsIgnoreCase(string)) continue;
            return columnData;
        }
        return null;
    }
}

