/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.SqlParsingUtil;
import workbench.util.StringUtil;

public class SelectIntoVerifier {
    private Pattern selectIntoPattern;

    public SelectIntoVerifier(String string) {
        String string2 = Settings.getInstance().getProperty("workbench.db." + string + ".selectinto.pattern", null);
        if (string2 != null) {
            try {
                this.selectIntoPattern = Pattern.compile(string2, 2);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Incorrect Pattern for detecting SELECT ... INTO <new table> specified", exception);
                this.selectIntoPattern = null;
            }
        }
    }

    public boolean isSelectIntoNewTable(String string) {
        if (this.selectIntoPattern == null) {
            return false;
        }
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        int n = SqlParsingUtil.getInstance(null).getKeywordPosition("SELECT", (CharSequence)string);
        if (n > -1) {
            string = string.substring(n);
        }
        Matcher matcher = this.selectIntoPattern.matcher(string);
        return matcher.find();
    }

    public boolean supportsSelectIntoNewTable() {
        return this.selectIntoPattern != null;
    }
}

