/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.db.DbObject;
import workbench.db.SequenceReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.storage.DataStore;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.SqlUtil;

public class SequenceDefinition
implements DbObject,
Serializable {
    private String sequenceName;
    private String schema;
    private String catalog;
    private CharSequence source;
    private String comment;
    private TableIdentifier relatedTable;
    private String relatedColumn;
    private String typeName = "SEQUENCE";
    private String postCreationSQL;
    private Map<String, Object> properties = new TreeMap<String, Object>(CaseInsensitiveComparator.INSTANCE);

    public SequenceDefinition(String string, String string2) {
        this.sequenceName = string2;
        this.schema = string;
    }

    public SequenceDefinition(String string, String string2, String string3) {
        this.catalog = string;
        this.sequenceName = string3;
        this.schema = string2;
    }

    public void setRelatedTable(TableIdentifier tableIdentifier, String string) {
        this.relatedTable = tableIdentifier;
        this.relatedColumn = string;
    }

    public TableIdentifier getRelatedTable() {
        return this.relatedTable;
    }

    public String getRelatedColumn() {
        return this.relatedColumn;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        if (wbConnection == null) {
            return null;
        }
        SequenceReader sequenceReader = wbConnection.getMetadata().getSequenceReader();
        if (sequenceReader == null) {
            return null;
        }
        return sequenceReader.getSequenceSource(this.catalog, this.schema, this.sequenceName);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setName(String string) {
        this.sequenceName = string;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return wbConnection.getMetadata().quoteObjectname(this.sequenceName);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, this.catalog, this.schema, this.sequenceName);
    }

    @Override
    public String getObjectType() {
        return this.typeName;
    }

    public void setObjectTypeName(String string) {
        this.typeName = string;
    }

    @Override
    public String getObjectName() {
        return this.getSequenceName();
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public String getSequenceOwner() {
        return this.schema;
    }

    public void setSequenceProperty(String string, Object object) {
        this.properties.put(string.toUpperCase().trim(), object);
    }

    public Object getSequenceProperty(String string) {
        return this.properties.get(string.toUpperCase().trim());
    }

    public CharSequence getSource() {
        return this.source;
    }

    public void setSource(CharSequence charSequence) {
        this.source = charSequence;
    }

    public Set<String> getProperties() {
        return this.properties.keySet();
    }

    public boolean propertiesAreEqual(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition.properties.size() != this.properties.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object object = sequenceDefinition.properties.get(entry.getKey());
            if (object == null && entry.getValue() != null) {
                return false;
            }
            if (object != null && entry.getValue() == null) {
                return false;
            }
            if (object == null || entry.getValue() == null || object.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof SequenceDefinition) {
            SequenceDefinition sequenceDefinition = (SequenceDefinition)object;
            return SqlUtil.objectNamesAreEqual(this, sequenceDefinition);
        }
        return false;
    }

    public DataStore getRawDefinition() {
        int n = this.properties.size() + 1;
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        stringArray[0] = "SEQUENCE_NAME";
        int n2 = 1;
        Object dataStore = this.properties.keySet().iterator();
        while (dataStore.hasNext()) {
            String object;
            stringArray[n2] = object = dataStore.next();
            Object object2 = this.properties.get(object);
            if (object2 instanceof String) {
                nArray[n2] = 12;
            } else if (object2 instanceof Integer || object2 instanceof Long) {
                nArray[n2] = 4;
            } else if (object2 instanceof Number) {
                nArray[n2] = 3;
            }
            ++n2;
        }
        dataStore = new DataStore(stringArray, nArray);
        ((DataStore)dataStore).addRow();
        n2 = 1;
        ((DataStore)dataStore).setValue(0, 0, (Object)this.getSequenceName());
        for (String string : this.properties.keySet()) {
            Object object = this.properties.get(string);
            ((DataStore)dataStore).setValue(0, n2, object);
            ++n2;
        }
        ((DataStore)dataStore).resetStatus();
        return dataStore;
    }

    public int hashCode() {
        int n = 3;
        n = 67 * n + (this.properties != null ? this.properties.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.getSequenceName();
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }

    public void setPostCreationSQL(String string) {
        this.postCreationSQL = string;
    }

    public String getPostCreationSQL() {
        return this.postCreationSQL;
    }
}

