/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import workbench.db.MetaDataSqlManager;
import workbench.util.ClasspathUtil;
import workbench.util.WbFile;

public class SourceStatementsHelp {
    public static final String VIEW_ERROR_START = "Support for displaying view source is currently not configured for:";
    public static final String PROC_ERROR_START = "Support for displaying procedure source is currently not configured for:";
    private final String product;

    public SourceStatementsHelp(MetaDataSqlManager metaDataSqlManager) {
        this.product = metaDataSqlManager.getProductName();
    }

    public String explainMissingViewSourceSql() {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        String string = classpathUtil.getJarPath();
        WbFile wbFile = new WbFile(string, "ViewSourceStatements.xml");
        String string2 = "Support for displaying view source is currently not configured for: " + this.product + "\n\nTo enable this, create the file:\n" + wbFile.getFullPath() + "\nusing the supplied sample below, filling out the necessary SELECT statement where indicated, \nto retrieve the source from the DBMS:\n\n--- Example ViewSourceStatements.xml starts here ---\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>  \n<java version=\"1.5\" class=\"java.beans.XMLDecoder\">  \n \n <object class=\"java.util.HashMap\">  \n  <void method=\"put\">  \n   <string>" + this.product + "</string>  \n   <object class=\"workbench.db.GetMetaDataSql\">  \n    <void property=\"baseSql\">  \n     <string>The SELECT statement to retrieve the source for a view</string>  \n    </void>  \n    <void property=\"objectNameField\">  \n     <string>The column name from the above SELECT that identifies the view name</string>  \n    </void>  \n    <void property=\"schemaField\">  \n     <string>The column from the above SELECT that identifies the view schema (if necessary)</string>  \n    </void>  \n    <void property=\"orderBy\">  \n     <string>Define an order by clause for the select statement in case the source is returned in more than one row.</string>  \n    </void>  \n   </object>  \n  </void>  \n   \n </object>  \n</java>\n";
        return string2;
    }

    public String explainMissingProcSourceSql() {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        String string = classpathUtil.getJarPath();
        WbFile wbFile = new WbFile(string, "ProcSourceStatements.xml");
        String string2 = "Support for displaying procedure source is currently not configured for: " + this.product + "\n\nTo enable this, create the file\n" + wbFile.getFullPath() + "\nusing the supplied sample below, filling out the necessary SELECT statement where indicated, \nto retrieve the source from the DBMS:\n\n--- Example ProcSourceStatements.xml starts here ---\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>  \n<java version=\"1.5\" class=\"java.beans.XMLDecoder\">  \n <object class=\"java.util.HashMap\">  \n  <void method=\"put\">  \n   <string>" + this.product + "</string>  \n   <object class=\"workbench.db.GetMetaDataSql\">  \n    <void property=\"baseSql\">  \n     <string>The SELECT statement to retrieve the source for a Procedure/Function</string>  \n    </void>  \n    <void property=\"objectNameField\">  \n     <string>The column name from the select that identifies the procedure name</string>  \n    </void>  \n    <void property=\"schemaField\">  \n     <string>The column name from the select that identifies the procedure schema (if necessary)</string>  \n    </void>  \n    <void property=\"orderBy\">  \n     <string>Define an order by clause for the above SELECT statement in case the source is returned in more than one row.</string>  \n    </void>  \n   </object>  \n  </void>  \n   \n </object>  \n</java>\n";
        return string2;
    }
}

