/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;

public class TableDefinition {
    private TableIdentifier table;
    private List<ColumnIdentifier> columns;

    public TableDefinition(TableIdentifier tableIdentifier) {
        this(tableIdentifier, null);
    }

    public TableDefinition(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        this.table = tableIdentifier;
        this.columns = list;
    }

    public TableIdentifier getTable() {
        return this.table;
    }

    public List<ColumnIdentifier> getColumns() {
        if (this.columns == null) {
            return Collections.emptyList();
        }
        return this.columns;
    }

    public int getColumnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.size();
    }

    public ColumnIdentifier findColumn(String string) {
        if (this.getColumnCount() == 0) {
            return null;
        }
        for (ColumnIdentifier columnIdentifier : this.columns) {
            if (!columnIdentifier.getColumnName().equalsIgnoreCase(string)) continue;
            return columnIdentifier;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getColumnCount() * 10 + 25);
        stringBuilder.append(this.table.toString());
        stringBuilder.append(" (");
        List<ColumnIdentifier> list = this.getColumns();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(list.get(i).getColumnName());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

