/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.db.DbMetadata;
import workbench.db.DbObjectFinder;
import workbench.db.DbSettings;
import workbench.db.DependencyNode;
import workbench.db.FKHandler;
import workbench.db.FKMatchType;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.DbObjectCache;
import workbench.db.objectcache.DbObjectCacheFactory;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class TableDependency {
    private final WbConnection connection;
    private TableIdentifier theTable;
    private DependencyNode tableRoot;
    private final DbMetadata metaData;
    private final FKHandler fkHandler;
    private final List<DependencyNode> leafs = new ArrayList<DependencyNode>();
    private boolean directChildrenOnly;
    private boolean readAborted;
    private boolean cancelRetrieve;
    private boolean cancelled;
    private final Map<DependencyNode, DependencyNode> visitedRelations = new HashMap<DependencyNode, DependencyNode>();
    private final Set<DependencyNode> visitedParents = new HashSet<DependencyNode>();
    private ScriptGenerationMonitor monitor;
    private final List<TableIdentifier> excludeTables = new ArrayList<TableIdentifier>();
    private final DbObjectFinder finder;

    public TableDependency(WbConnection wbConnection) {
        this.connection = wbConnection;
        this.metaData = this.connection.getMetadata();
        this.finder = new DbObjectFinder(this.metaData);
        this.fkHandler = FKHandler.createInstance(this.connection);
    }

    public TableDependency(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        this(wbConnection);
        this.setMainTable(tableIdentifier, false);
    }

    public final void setMainTable(TableIdentifier tableIdentifier) {
        this.setMainTable(tableIdentifier, true);
    }

    public final void setMainTable(TableIdentifier tableIdentifier, boolean bl) {
        this.theTable = bl ? this.finder.findTable(tableIdentifier, false) : tableIdentifier.createCopy();
        this.visitedParents.clear();
        this.visitedRelations.clear();
        this.leafs.clear();
        this.tableRoot = null;
    }

    public FKHandler getFKHandler() {
        return this.fkHandler;
    }

    public void setExcludedTables(List<TableIdentifier> list) {
        if (CollectionUtil.isEmpty(list)) {
            this.excludeTables.clear();
        } else {
            this.excludeTables.clear();
            this.excludeTables.addAll(list);
        }
    }

    public void setScriptMonitor(ScriptGenerationMonitor scriptGenerationMonitor) {
        this.monitor = scriptGenerationMonitor;
    }

    public void setRetrieveDirectChildrenOnly(boolean bl) {
        this.directChildrenOnly = bl;
    }

    public DependencyNode findLeafNodeForTable(TableIdentifier tableIdentifier) {
        return this.findLeafNodeForTable(tableIdentifier, null);
    }

    public DependencyNode findLeafNodeForTable(TableIdentifier tableIdentifier, String string) {
        String string2 = tableIdentifier.getRawTableName();
        for (DependencyNode dependencyNode : this.leafs) {
            TableIdentifier tableIdentifier2 = dependencyNode.getTable();
            String string3 = tableIdentifier2.getRawTableName();
            if (!string3.equalsIgnoreCase(string2)) continue;
            if (string == null) {
                return dependencyNode;
            }
            if (!StringUtil.equalStringIgnoreCase(dependencyNode.getFkName(), string)) continue;
            return dependencyNode;
        }
        return null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
        this.cancelRetrieve = true;
        LogMgr.logDebug(new CallerInfo(){}, "Cancelling dependency retrieval");
    }

    public void readTreeForChildren() {
        this.readDependencyTree(true);
    }

    public void readTreeForParents() {
        this.readDependencyTree(false);
    }

    public List<DependencyNode> getIncomingForeignKeys() {
        boolean bl = this.directChildrenOnly;
        try {
            this.setRetrieveDirectChildrenOnly(true);
            this.readTreeForChildren();
        }
        finally {
            this.setRetrieveDirectChildrenOnly(bl);
        }
        return this.getLeafs();
    }

    public List<DependencyNode> getOutgoingForeignKeys() {
        boolean bl = this.directChildrenOnly;
        try {
            this.setRetrieveDirectChildrenOnly(true);
            this.readTreeForParents();
        }
        finally {
            this.setRetrieveDirectChildrenOnly(bl);
        }
        return this.getLeafs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDependencyTree(boolean bl) {
        if (this.theTable == null) {
            return;
        }
        if (this.connection == null) {
            return;
        }
        this.readAborted = false;
        this.cancelRetrieve = false;
        this.cancelled = false;
        this.leafs.clear();
        TableIdentifier tableIdentifier = this.theTable;
        if (!this.theTable.getNeverAdjustCase()) {
            tableIdentifier = this.finder.findTable(this.theTable, false);
        }
        if (tableIdentifier == null) {
            return;
        }
        this.tableRoot = new DependencyNode(tableIdentifier);
        this.visitedRelations.clear();
        this.visitedParents.clear();
        long l = System.currentTimeMillis();
        boolean bl2 = false;
        try {
            if (!this.connection.isBusy()) {
                this.connection.setBusy(true);
                bl2 = true;
            }
            this.readTree(this.tableRoot, bl, 0);
            if (this.cancelRetrieve) {
                this.tableRoot = new DependencyNode(tableIdentifier);
                this.visitedRelations.clear();
                this.visitedParents.clear();
                this.leafs.clear();
            }
        }
        finally {
            if (bl2) {
                this.connection.setBusy(false);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving " + (bl ? "referencing" : "referenced") + " tables for " + this.tableRoot.getTable().toString() + " took: " + l2 + "ms");
    }

    private void readTree(DependencyNode dependencyNode, boolean bl, int n) {
        if (this.cancelRetrieve) {
            return;
        }
        if (this.visitedParents.contains(dependencyNode)) {
            LogMgr.logTrace(new CallerInfo(){}, "Foreign key " + dependencyNode.getFkName() + " has already been processed.");
            return;
        }
        if (this.excludeTables.contains(dependencyNode.getTable())) {
            LogMgr.logDebug(new CallerInfo(){}, "Table dependency for " + dependencyNode.getTable() + " will not be analyzed because it has been excluded.");
            return;
        }
        if (this.monitor != null) {
            this.monitor.setCurrentObject(dependencyNode.getTable().toString(), -1, -1);
        }
        DbSettings dbSettings = this.metaData.getDbSettings();
        try {
            DataStore dataStore;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            TableIdentifier tableIdentifier = this.metaData.resolveSynonym(dependencyNode.getTable());
            if (LogMgr.isTraceEnabled()) {
                LogMgr.logTrace(new CallerInfo(){}, "level: " + n + ", retrieving: " + dependencyNode.debugString());
            }
            if (bl) {
                n7 = 4;
                n6 = 5;
                n5 = 6;
                n4 = 11;
                n3 = 7;
                n2 = 3;
                dataStore = this.fkHandler.getExportedKeys(tableIdentifier);
            } else {
                n7 = 0;
                n6 = 1;
                n5 = 2;
                n4 = 11;
                n3 = 3;
                n2 = 7;
                dataStore = this.fkHandler.getImportedKeys(tableIdentifier);
            }
            int n8 = dataStore.getRowCount();
            if (!dependencyNode.getTable().equals(this.theTable)) {
                this.visitedParents.add(dependencyNode);
            }
            int n9 = dataStore.getColumnIndex("REMARKS");
            int n10 = dataStore.getColumnIndex("MATCH_TYPE");
            for (int i = 0; i < n8; ++i) {
                String string;
                Iterator<DependencyNode> iterator = dataStore.getValueAsString(i, n7);
                String object = dataStore.getValueAsString(i, n6);
                String string2 = dataStore.getValueAsString(i, n5);
                String string3 = dataStore.getValueAsString(i, n4);
                int n11 = dataStore.getValueAsInt(i, 13, 7);
                String string4 = dbSettings.getRuleDisplay(n11);
                if (string3 == null) {
                    string3 = bl ? "WbGenerated_fk_" + dependencyNode.getTable().getTableName() + "_referenced_by_" + string2 : "WbGenerated_fk_" + dependencyNode.getTable().getTableName() + "_references_" + string2;
                    LogMgr.logError(new CallerInfo(){}, "JDBC Driver returned a NULL value for the FK name for table " + dependencyNode.getTable().getTableExpression() + "  Using: " + string3 + " instead", null);
                }
                TableIdentifier tableIdentifier2 = new TableIdentifier((String)((Object)iterator), object, string2);
                tableIdentifier2.setNeverAdjustCase(true);
                DependencyNode dependencyNode2 = dependencyNode.addChild(tableIdentifier2, string3);
                String string5 = dataStore.getValueAsString(i, n3);
                String string6 = dataStore.getValueAsString(i, n2);
                int n12 = dataStore.getValueAsInt(i, 9, -1);
                int n13 = dataStore.getValueAsInt(i, 10, -1);
                dependencyNode2.setUpdateActionValue(n12);
                dependencyNode2.setDeleteActionValue(n13);
                dependencyNode2.setDeferrableValue(n11);
                dependencyNode2.setUpdateAction(this.metaData.getDbSettings().getRuleDisplay(n12));
                dependencyNode2.setDeleteAction(this.metaData.getDbSettings().getRuleDisplay(n13));
                dependencyNode2.addColumnDefinition(string5, string6);
                dependencyNode2.setDeferrableType(string4);
                dependencyNode2.setEnabled(true);
                if (this.fkHandler.supportsStatus()) {
                    string = null;
                    if (this.fkHandler.containsStatusColumn()) {
                        string = dataStore.getValueAsString(i, "ENABLED");
                        if (string != null) {
                            dependencyNode2.setEnabled(StringUtil.stringToBool(string));
                        }
                        if ((string = dataStore.getValueAsString(i, "VALIDATED")) != null) {
                            dependencyNode2.setValidated(StringUtil.stringToBool(string));
                        }
                    } else {
                        FKHandler.FkStatusInfo fkStatusInfo = this.fkHandler.getFkEnabledFlag(tableIdentifier, string3);
                        if (fkStatusInfo != null) {
                            dependencyNode2.setEnabled(fkStatusInfo.enabled);
                            dependencyNode2.setValidated(fkStatusInfo.validated);
                        }
                    }
                }
                if (n9 > -1 && StringUtil.isNonBlank(string = dataStore.getValueAsString(i, n9))) {
                    dependencyNode2.setComment(string);
                }
                if (n10 <= -1 || !StringUtil.isNonBlank(string = dataStore.getValueAsString(i, n10)) || string.equals("s")) continue;
                dependencyNode2.setMatchType(FKMatchType.fromString(string));
            }
            if (n > 25) {
                LogMgr.logError(new CallerInfo(){}, "Endless reference cycle detected for root=" + this.tableRoot + ", parent=" + dependencyNode, null);
                this.readAborted = true;
                return;
            }
            if (this.directChildrenOnly && n == 0) {
                List<DependencyNode> list = dependencyNode.getChildren();
                for (DependencyNode dependencyNode3 : list) {
                    this.leafs.add(dependencyNode3);
                }
                return;
            }
            List<DependencyNode> list = dependencyNode.getChildren();
            for (DependencyNode dependencyNode4 : list) {
                if (!this.isCycle(dependencyNode4, dependencyNode)) {
                    this.readTree(dependencyNode4, bl, n + 1);
                }
                this.visitedRelations.put(dependencyNode, dependencyNode4);
                this.leafs.add(dependencyNode4);
                if (!this.readAborted && !this.cancelRetrieve) continue;
                break;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when reading FK definition for " + this.tableRoot, exception);
        }
    }

    private boolean isCycle(DependencyNode dependencyNode, DependencyNode dependencyNode2) {
        if (dependencyNode.equals(dependencyNode2)) {
            return true;
        }
        if (dependencyNode.getTable().equals(dependencyNode2.getTable())) {
            return true;
        }
        DependencyNode dependencyNode3 = this.visitedRelations.get(dependencyNode2);
        if (dependencyNode3 != null && dependencyNode3.equals(dependencyNode)) {
            return true;
        }
        for (DependencyNode dependencyNode4 = dependencyNode2.getParent(); dependencyNode4 != null; dependencyNode4 = dependencyNode4.getParent()) {
            if (dependencyNode.equals(dependencyNode4)) {
                return true;
            }
            if (!dependencyNode4.getChildren().contains(dependencyNode)) continue;
            return true;
        }
        return false;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public boolean wasAborted() {
        return this.readAborted;
    }

    public List<DependencyNode> getLeafs() {
        return this.leafs;
    }

    public DependencyNode getRootNode() {
        return this.tableRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void dumpTree(String string, DependencyNode dependencyNode, boolean bl) {
        FileWriter fileWriter;
        block9: {
            if (!Settings.getInstance().getBoolProperty("workbench.debug.dependency", false)) {
                return;
            }
            fileWriter = null;
            try {
                fileWriter = new FileWriter(new File(string), bl);
                boolean bl2 = true;
                if (dependencyNode.getChildren().isEmpty()) {
                    fileWriter.append("No children for " + dependencyNode.debugString() + ". Starting from top-level node: \n");
                    while (dependencyNode.getParent() != null) {
                        dependencyNode = dependencyNode.getParent();
                    }
                    fileWriter.append(dependencyNode.getTable() + "\n----------------------------------------\n");
                    bl2 = false;
                } else {
                    fileWriter.append("Tree for: " + dependencyNode.debugString() + "\n");
                }
                TableDependency.dumpChildren(fileWriter, dependencyNode, 0);
                if (!bl2 || dependencyNode.getParent() == null) break block9;
                fileWriter.append("------ Parents for: " + dependencyNode.debugString() + "\n");
                for (DependencyNode dependencyNode2 = dependencyNode.getParent(); dependencyNode2 != null; dependencyNode2 = dependencyNode2.getParent()) {
                    int n = dependencyNode2.getLevel();
                    fileWriter.write(StringUtil.padRight("", n * 4));
                    fileWriter.write(dependencyNode2.getTable().getTableName() + " (" + dependencyNode2.getFkName() + ")");
                    fileWriter.write(", nodeLevel: " + n);
                    fileWriter.write("\n");
                }
            }
            catch (IOException iOException) {
                FileUtil.closeQuietely(fileWriter);
                catch (Throwable throwable) {
                    FileUtil.closeQuietely(fileWriter);
                    throw throwable;
                }
            }
        }
        FileUtil.closeQuietely(fileWriter);
    }

    private static void dumpChildren(FileWriter fileWriter, DependencyNode dependencyNode, int n) throws IOException {
        if (dependencyNode == null) {
            return;
        }
        for (DependencyNode dependencyNode2 : dependencyNode.getChildren()) {
            fileWriter.write(StringUtil.padRight("", n * 4));
            fileWriter.write(dependencyNode2.getTable().getTableName() + " (" + dependencyNode2.getFkName() + ")");
            fileWriter.write(", nodeLevel: " + dependencyNode.getLevel());
            fileWriter.write(", iterationLevel: " + n);
            fileWriter.write("\n");
        }
        for (DependencyNode dependencyNode2 : dependencyNode.getChildren()) {
            TableDependency.dumpChildren(fileWriter, dependencyNode2, n + 1);
        }
    }

    public Set<TableIdentifier> getAllTables() {
        Set<TableIdentifier> set = this.getAllTables(this.getRootNode());
        set.add(this.getRootNode().getTable());
        return set;
    }

    private Set<TableIdentifier> getAllTables(DependencyNode dependencyNode) {
        HashSet<TableIdentifier> hashSet = new HashSet<TableIdentifier>();
        if (dependencyNode == null) {
            return hashSet;
        }
        List<DependencyNode> list = dependencyNode.getChildren();
        for (DependencyNode dependencyNode2 : list) {
            hashSet.add(dependencyNode2.getTable());
            hashSet.addAll(this.getAllTables(dependencyNode2));
        }
        return hashSet;
    }

    public List<DependencyNode> getAllNodes() {
        List<DependencyNode> list = this.getAllNodes(this.getRootNode());
        list.add(this.getRootNode());
        return list;
    }

    private List<DependencyNode> getAllNodes(DependencyNode dependencyNode) {
        ArrayList<DependencyNode> arrayList = new ArrayList<DependencyNode>();
        if (dependencyNode == null) {
            return arrayList;
        }
        List<DependencyNode> list = dependencyNode.getChildren();
        for (DependencyNode dependencyNode2 : list) {
            arrayList.add(dependencyNode2);
            arrayList.addAll(this.getAllNodes(dependencyNode2));
        }
        return arrayList;
    }

    public DataStore getDisplayDataStore(boolean bl) {
        this.setRetrieveDirectChildrenOnly(true);
        if (bl) {
            this.readTreeForParents();
        } else {
            this.readTreeForChildren();
        }
        DbObjectCache dbObjectCache = DbObjectCacheFactory.getInstance().getCache(this.connection);
        if (bl) {
            dbObjectCache.addReferencedTables(this.theTable, this.leafs);
        } else {
            dbObjectCache.addReferencingTables(this.theTable, this.leafs);
        }
        return TableDependency.createDisplayDataStore(this.connection, this.theTable, this.leafs, bl);
    }

    public static DataStore createDisplayDataStore(WbConnection wbConnection, TableIdentifier tableIdentifier, List<DependencyNode> list, boolean bl) {
        String string = bl ? "REFERENCES" : "REFERENCED BY";
        FKHandler fKHandler = FKHandler.createInstance(wbConnection);
        DataStore dataStore = fKHandler.createDisplayDataStore(string, false);
        int n = -1;
        int n2 = -1;
        if (fKHandler.supportsMatchType()) {
            dataStore.addColumn(FKHandler.MATCH_TYPE_COLUMN);
            n2 = dataStore.getColumnIndex("MATCH_TYPE");
        }
        if (fKHandler.supportsRemarks()) {
            dataStore.addColumn(FKHandler.REMARKS_COLUMN);
            n = dataStore.getColumnIndex("REMARKS");
        }
        int n3 = -1;
        int n4 = -1;
        if (fKHandler.supportsStatus()) {
            n3 = dataStore.getColumnIndex("VALIDATED");
            n4 = dataStore.getColumnIndex("ENABLED");
        }
        for (DependencyNode dependencyNode : list) {
            int n5 = dataStore.addRow();
            int n6 = 0;
            dataStore.setValue(n5, n6++, (Object)dependencyNode.getFkName());
            dataStore.setValue(n5, n6++, (Object)dependencyNode.getTargetColumnsList());
            dataStore.setValue(n5, n6++, (Object)(dependencyNode.getTable().getTableExpression(wbConnection) + "(" + dependencyNode.getSourceColumnsList() + ")"));
            if (fKHandler.supportsRemarks()) {
                // empty if block
            }
            dataStore.setValue(n5, n6++, (Object)dependencyNode.getUpdateAction());
            dataStore.setValue(n5, n6++, (Object)dependencyNode.getDeleteAction());
            dataStore.setValue(n5, n6++, (Object)dependencyNode.getDeferrableType());
            if (n2 > -1) {
                FKMatchType fKMatchType = dependencyNode.getMatchType();
                dataStore.setValue(n5, n2, (Object)(fKMatchType == null ? null : fKMatchType.toString()));
            }
            if (n > -1) {
                dataStore.setValue(n5, n, (Object)dependencyNode.getComment());
            }
            if (n4 > -1) {
                dataStore.setValue(n5, n6++, (Object)(dependencyNode.isEnabled() ? "YES" : "NO"));
            }
            if (n3 > -1) {
                dataStore.setValue(n5, n6++, (Object)(dependencyNode.isValidated() ? "YES" : "NO"));
            }
            dataStore.getRow(n5).setUserObject(dependencyNode);
        }
        dataStore.resetStatus();
        return dataStore;
    }
}

