/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import workbench.storage.RowData;
import workbench.storage.RowDataListSorter;
import workbench.storage.SortDefinition;

public class TableListSorter
extends RowDataListSorter {
    private static final String TABLE_TYPE = "TABLE";
    private boolean mviewAsTable = false;
    private int typeColumnIndex = 1;

    public TableListSorter(SortDefinition sortDefinition) {
        super(sortDefinition);
    }

    public TableListSorter(int n, boolean bl) {
        super(n, bl);
    }

    public TableListSorter(int[] nArray, boolean[] blArray) {
        super(nArray, blArray);
    }

    public void setSortMViewAsTable(boolean bl) {
        this.mviewAsTable = bl;
    }

    public void setTypeColumnIndex(int n) {
        this.typeColumnIndex = n;
    }

    @Override
    protected int compareColumn(int n, RowData rowData, RowData rowData2) {
        if (n == this.typeColumnIndex) {
            String string = this.getType(rowData);
            String string2 = this.getType(rowData2);
            return string.compareTo(string2);
        }
        return super.compareColumn(n, rowData, rowData2);
    }

    private String getType(RowData rowData) {
        String string = (String)rowData.getValue(this.typeColumnIndex);
        if (string == null) {
            return "";
        }
        if (this.mviewAsTable && "MATERIALIZED VIEW".equals(string)) {
            return TABLE_TYPE;
        }
        if ("RANGE TYPE".equals(string)) {
            return "TYPE";
        }
        return string;
    }
}

